/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util.serviceStatus;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.accumulo.server.util.serviceStatus.ServiceStatusReport;

public class StatusSummary {
    private final ServiceStatusReport.ReportKey serviceType;
    private final Map<String, Integer> resourceGroups;
    private final Map<String, Set<String>> serviceByGroups;
    private final int serviceCount;
    private final int errorCount;

    public StatusSummary(ServiceStatusReport.ReportKey serviceType, Map<String, Integer> resourceGroups, Map<String, Set<String>> serviceByGroups, int serviceCount, int errorCount) {
        this.serviceType = serviceType;
        this.resourceGroups = resourceGroups;
        this.serviceByGroups = serviceByGroups;
        this.serviceCount = serviceCount;
        this.errorCount = errorCount;
    }

    public ServiceStatusReport.ReportKey getServiceType() {
        return this.serviceType;
    }

    public String getDisplayName() {
        return this.serviceType.getDisplayName();
    }

    public Map<String, Integer> getResourceGroups() {
        return this.resourceGroups;
    }

    public Map<String, Set<String>> getServiceByGroups() {
        return this.serviceByGroups;
    }

    public int getServiceCount() {
        return this.serviceCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public StatusSummary withoutHosts() {
        return new StatusSummary(this.serviceType, this.resourceGroups, Map.of(), this.serviceCount, this.errorCount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StatusSummary)) {
            return false;
        }
        StatusSummary that = (StatusSummary)o;
        return this.serviceCount == that.serviceCount && this.errorCount == that.errorCount && this.serviceType == that.serviceType && Objects.equals(this.resourceGroups, that.resourceGroups) && Objects.equals(this.serviceByGroups, that.serviceByGroups);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.serviceType, this.resourceGroups, this.serviceCount, this.serviceByGroups, this.errorCount});
    }

    public String toString() {
        return "StatusSummary{serviceName=" + String.valueOf((Object)this.serviceType) + ", resourceGroups=" + String.valueOf(this.resourceGroups) + ", serviceCount=" + this.serviceCount + ", names=" + String.valueOf(this.serviceByGroups) + ", errorCount=" + this.errorCount + "}";
    }
}

