/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public final class ModuleOpens
implements Cloneable,
Node {
    private final int opens_index;
    private final int opens_flags;
    private final int opens_to_count;
    private final int[] opens_to_index;

    ModuleOpens(DataInput file) throws IOException {
        this.opens_index = file.readUnsignedShort();
        this.opens_flags = file.readUnsignedShort();
        this.opens_to_count = file.readUnsignedShort();
        this.opens_to_index = new int[this.opens_to_count];
        for (int i = 0; i < this.opens_to_count; ++i) {
            this.opens_to_index[i] = file.readUnsignedShort();
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitModuleOpens(this);
    }

    public void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.opens_index);
        file.writeShort(this.opens_flags);
        file.writeShort(this.opens_to_count);
        for (int entry : this.opens_to_index) {
            file.writeShort(entry);
        }
    }

    public String toString() {
        return "opens(" + this.opens_index + ", " + this.opens_flags + ", " + this.opens_to_count + ", ...)";
    }

    public String toString(ConstantPool constant_pool) {
        StringBuilder buf = new StringBuilder();
        String package_name = constant_pool.constantToString(this.opens_index, (byte)20);
        buf.append(Utility.compactClassName(package_name, false));
        buf.append(", ").append(String.format("%04x", this.opens_flags));
        buf.append(", to(").append(this.opens_to_count).append("):\n");
        for (int index : this.opens_to_index) {
            String module_name = constant_pool.getConstantString(index, (byte)19);
            buf.append("      ").append(Utility.compactClassName(module_name, false)).append("\n");
        }
        return buf.substring(0, buf.length() - 1);
    }

    public ModuleOpens copy() {
        try {
            return (ModuleOpens)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

