/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.dispatchers;

import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.dispatchers.AbstractServiceDispatcher;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.LoggingControl;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SOAPMessageBodyBasedServiceDispatcher
extends AbstractServiceDispatcher {
    public static final String NAME = "SOAPMessageBodyBasedServiceDispatcher";
    private static final Log log = LogFactory.getLog(SOAPMessageBodyBasedServiceDispatcher.class);

    @Override
    public AxisService findService(MessageContext messageContext) throws AxisFault {
        OMNamespace ns;
        String serviceName = null;
        String localPart = messageContext.getEnvelope().getSOAPBodyFirstElementLocalName();
        if (localPart != null && (ns = messageContext.getEnvelope().getSOAPBodyFirstElementNS()) != null) {
            String[] values;
            String filePart = ns.getNamespaceURI();
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)(messageContext.getLogIDString() + "Checking for Service using SOAP message body's first child's namespace : " + filePart));
            }
            if ((values = Utils.parseRequestURLForServiceAndOperation(filePart, messageContext.getConfigurationContext().getServiceContextPath()))[0] != null) {
                serviceName = values[0];
                AxisConfiguration registry = messageContext.getConfigurationContext().getAxisConfiguration();
                return registry.getService(serviceName);
            }
        }
        return null;
    }

    @Override
    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }
}

