/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.replication;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiConsumer;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.replication.Auditor;
import org.apache.bookkeeper.replication.AuditorStats;
import org.apache.bookkeeper.replication.ReplicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AuditorTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(AuditorTask.class);
    protected final ServerConfiguration conf;
    protected AuditorStats auditorStats;
    protected BookKeeperAdmin admin;
    protected LedgerManager ledgerManager;
    protected LedgerUnderreplicationManager ledgerUnderreplicationManager;
    private final ShutdownTaskHandler shutdownTaskHandler;
    private final BiConsumer<AtomicBoolean, Throwable> hasAuditCheckTask;
    private final AtomicBoolean hasTask = new AtomicBoolean(false);

    AuditorTask(ServerConfiguration conf, AuditorStats auditorStats, BookKeeperAdmin admin, LedgerManager ledgerManager, LedgerUnderreplicationManager ledgerUnderreplicationManager, ShutdownTaskHandler shutdownTaskHandler, BiConsumer<AtomicBoolean, Throwable> hasAuditCheckTask) {
        this.conf = conf;
        this.auditorStats = auditorStats;
        this.admin = admin;
        this.ledgerManager = ledgerManager;
        this.ledgerUnderreplicationManager = ledgerUnderreplicationManager;
        this.shutdownTaskHandler = shutdownTaskHandler;
        this.hasAuditCheckTask = hasAuditCheckTask;
    }

    @Override
    public void run() {
        this.runTask();
    }

    protected abstract void runTask();

    protected boolean isLedgerReplicationEnabled() throws ReplicationException.UnavailableException {
        return this.ledgerUnderreplicationManager.isLedgerReplicationEnabled();
    }

    protected CompletableFuture<?> publishSuspectedLedgersAsync(Collection<String> missingBookies, Set<Long> ledgers) {
        if (null == ledgers || ledgers.size() == 0) {
            LOG.info("There is no ledgers for the failed bookie: {}", missingBookies);
            return FutureUtils.Void();
        }
        LOG.info("Following ledgers: {} of bookie: {} are identified as underreplicated", ledgers, missingBookies);
        this.auditorStats.getNumUnderReplicatedLedger().registerSuccessfulValue((long)ledgers.size());
        LongAdder underReplicatedSize = new LongAdder();
        FutureUtils.processList((List)Lists.newArrayList(ledgers), ledgerId -> this.ledgerManager.readLedgerMetadata((long)ledgerId).whenComplete((metadata, exception) -> {
            if (exception == null) {
                underReplicatedSize.add(((LedgerMetadata)metadata.getValue()).getLength());
            }
        }), null).whenComplete((res, e) -> this.auditorStats.getUnderReplicatedLedgerTotalSize().registerSuccessfulValue(underReplicatedSize.longValue()));
        return FutureUtils.processList((List)Lists.newArrayList(ledgers), ledgerId -> this.ledgerUnderreplicationManager.markLedgerUnderreplicatedAsync((long)ledgerId, missingBookies), null);
    }

    protected List<String> getAvailableBookies() throws BKException {
        Collection<BookieId> availableBkAddresses = this.admin.getAvailableBookies();
        Collection<BookieId> readOnlyBkAddresses = this.admin.getReadOnlyBookies();
        availableBkAddresses.addAll(readOnlyBkAddresses);
        ArrayList<String> availableBookies = new ArrayList<String>();
        for (BookieId addr : availableBkAddresses) {
            availableBookies.add(addr.toString());
        }
        return availableBookies;
    }

    BookKeeper getBookKeeper(ServerConfiguration conf) throws IOException, InterruptedException {
        return Auditor.createBookKeeperClient(conf);
    }

    BookKeeperAdmin getBookKeeperAdmin(BookKeeper bookKeeper) {
        return new BookKeeperAdmin(bookKeeper, this.auditorStats.getStatsLogger(), new ClientConfiguration(this.conf));
    }

    protected void submitShutdownTask() {
        if (this.shutdownTaskHandler != null) {
            this.shutdownTaskHandler.submitShutdownTask();
        }
    }

    public abstract void shutdown();

    protected boolean hasBookieCheckTask() {
        this.hasTask.set(false);
        this.hasAuditCheckTask.accept(this.hasTask, null);
        return this.hasTask.get();
    }

    static interface ShutdownTaskHandler {
        public void submitShutdownTask();
    }
}

