/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Synthesize speech using AWS Polly and AWS SDK version 2.x.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface Polly2EndpointBuilderFactory {

    /**
     * Builder for endpoint for the AWS Polly component.
     */
    public interface Polly2EndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedPolly2EndpointBuilder advanced() {
            return (AdvancedPolly2EndpointBuilder) this;
        }

        /**
         * The engine to use for synthesis (standard, neural, long-form,
         * generative).
         * 
         * The option is a:
         * <code>software.amazon.awssdk.services.polly.model.Engine</code> type.
         * 
         * Group: producer
         * 
         * @param engine the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder engine(software.amazon.awssdk.services.polly.model.Engine engine) {
            doSetProperty("engine", engine);
            return this;
        }
        /**
         * The engine to use for synthesis (standard, neural, long-form,
         * generative).
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.services.polly.model.Engine</code> type.
         * 
         * Group: producer
         * 
         * @param engine the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder engine(String engine) {
            doSetProperty("engine", engine);
            return this;
        }
        /**
         * The language code for the synthesis.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param languageCode the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder languageCode(String languageCode) {
            doSetProperty("languageCode", languageCode);
            return this;
        }
        /**
         * The content of the lexicon in PLS format for putLexicon operation.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param lexiconContent the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder lexiconContent(String lexiconContent) {
            doSetProperty("lexiconContent", lexiconContent);
            return this;
        }
        /**
         * The name of the lexicon to use for getLexicon, putLexicon, or
         * deleteLexicon operations.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param lexiconName the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder lexiconName(String lexiconName) {
            doSetProperty("lexiconName", lexiconName);
            return this;
        }
        /**
         * Lexicon names to apply during synthesis.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param lexiconNames the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder lexiconNames(String lexiconNames) {
            doSetProperty("lexiconNames", lexiconNames);
            return this;
        }
        /**
         * The operation to perform.
         * 
         * The option is a:
         * <code>org.apache.camel.component.aws2.polly.Polly2Operations</code>
         * type.
         * 
         * Required: true
         * Default: synthesizeSpeech
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder operation(org.apache.camel.component.aws2.polly.Polly2Operations operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The operation to perform.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.aws2.polly.Polly2Operations</code>
         * type.
         * 
         * Required: true
         * Default: synthesizeSpeech
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The audio output format.
         * 
         * The option is a:
         * <code>software.amazon.awssdk.services.polly.model.OutputFormat</code>
         * type.
         * 
         * Default: MP3
         * Group: producer
         * 
         * @param outputFormat the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder outputFormat(software.amazon.awssdk.services.polly.model.OutputFormat outputFormat) {
            doSetProperty("outputFormat", outputFormat);
            return this;
        }
        /**
         * The audio output format.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.services.polly.model.OutputFormat</code>
         * type.
         * 
         * Default: MP3
         * Group: producer
         * 
         * @param outputFormat the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder outputFormat(String outputFormat) {
            doSetProperty("outputFormat", outputFormat);
            return this;
        }
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with the uriEndpointOverride option.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder overrideEndpoint(boolean overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with the uriEndpointOverride option.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder overrideEndpoint(String overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * If we want to use a POJO request as body or not.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param pojoRequest the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder pojoRequest(boolean pojoRequest) {
            doSetProperty("pojoRequest", pojoRequest);
            return this;
        }
        /**
         * If we want to use a POJO request as body or not.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param pojoRequest the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder pojoRequest(String pojoRequest) {
            doSetProperty("pojoRequest", pojoRequest);
            return this;
        }
        /**
         * The region in which the Polly client needs to work. When using this
         * parameter, the configuration will expect the lowercase name of the
         * region (for example, ap-east-1) You'll need to use the name
         * Region.EU_WEST_1.id().
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param region the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder region(String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * The S3 bucket name for startSpeechSynthesisTask operation output.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param s3Bucket the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder s3Bucket(String s3Bucket) {
            doSetProperty("s3Bucket", s3Bucket);
            return this;
        }
        /**
         * The S3 key prefix for startSpeechSynthesisTask operation output.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param s3KeyPrefix the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder s3KeyPrefix(String s3KeyPrefix) {
            doSetProperty("s3KeyPrefix", s3KeyPrefix);
            return this;
        }
        /**
         * The sample rate in Hz for the audio output.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param sampleRate the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder sampleRate(String sampleRate) {
            doSetProperty("sampleRate", sampleRate);
            return this;
        }
        /**
         * The SNS topic ARN for startSpeechSynthesisTask notifications.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param snsTopicArn the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder snsTopicArn(String snsTopicArn) {
            doSetProperty("snsTopicArn", snsTopicArn);
            return this;
        }
        /**
         * The task ID for getSpeechSynthesisTask operation.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param taskId the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder taskId(String taskId) {
            doSetProperty("taskId", taskId);
            return this;
        }
        /**
         * The type of text input (text or ssml).
         * 
         * The option is a:
         * <code>software.amazon.awssdk.services.polly.model.TextType</code>
         * type.
         * 
         * Default: TEXT
         * Group: producer
         * 
         * @param textType the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder textType(software.amazon.awssdk.services.polly.model.TextType textType) {
            doSetProperty("textType", textType);
            return this;
        }
        /**
         * The type of text input (text or ssml).
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.services.polly.model.TextType</code>
         * type.
         * 
         * Default: TEXT
         * Group: producer
         * 
         * @param textType the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder textType(String textType) {
            doSetProperty("textType", textType);
            return this;
        }
        /**
         * Set the overriding uri endpoint. This option needs to be used in
         * combination with overrideEndpoint option.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param uriEndpointOverride the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder uriEndpointOverride(String uriEndpointOverride) {
            doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }
        /**
         * The voice ID to use for synthesis.
         * 
         * The option is a:
         * <code>software.amazon.awssdk.services.polly.model.VoiceId</code>
         * type.
         * 
         * Group: producer
         * 
         * @param voiceId the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder voiceId(software.amazon.awssdk.services.polly.model.VoiceId voiceId) {
            doSetProperty("voiceId", voiceId);
            return this;
        }
        /**
         * The voice ID to use for synthesis.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.services.polly.model.VoiceId</code>
         * type.
         * 
         * Group: producer
         * 
         * @param voiceId the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder voiceId(String voiceId) {
            doSetProperty("voiceId", voiceId);
            return this;
        }
        /**
         * To define a proxy host when instantiating the Polly client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * To define a proxy port when instantiating the Polly client.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder proxyPort(Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy port when instantiating the Polly client.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the Polly client.
         * 
         * The option is a: <code>software.amazon.awssdk.core.Protocol</code>
         * type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder proxyProtocol(software.amazon.awssdk.core.Protocol proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the Polly client.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.core.Protocol</code> type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder proxyProtocol(String proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * If using a profile credentials provider, this parameter will set the
         * profile name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param profileCredentialsName the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder profileCredentialsName(String profileCredentialsName) {
            doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
        /**
         * Amazon AWS Session Token used when the user needs to assume an IAM
         * role.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param sessionToken the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder sessionToken(String sessionToken) {
            doSetProperty("sessionToken", sessionToken);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder trustAllCertificates(boolean trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder trustAllCertificates(String trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * Set whether the Polly client should expect to load credentials
         * through a default credentials provider or to expect static
         * credentials to be passed in.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the Polly client should expect to load credentials
         * through a default credentials provider or to expect static
         * credentials to be passed in.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder useDefaultCredentialsProvider(String useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the Polly client should expect to load credentials
         * through a profile credentials provider.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
        /**
         * Set whether the Polly client should expect to load credentials
         * through a profile credentials provider.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder useProfileCredentialsProvider(String useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
        /**
         * Set whether the Polly client should expect to use Session
         * Credentials. This is useful in a situation in which the user needs to
         * assume an IAM role for doing operations in Polly.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useSessionCredentials the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder useSessionCredentials(boolean useSessionCredentials) {
            doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
        /**
         * Set whether the Polly client should expect to use Session
         * Credentials. This is useful in a situation in which the user needs to
         * assume an IAM role for doing operations in Polly.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useSessionCredentials the value to set
         * @return the dsl builder
         */
        default Polly2EndpointBuilder useSessionCredentials(String useSessionCredentials) {
            doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the AWS Polly component.
     */
    public interface AdvancedPolly2EndpointBuilder
            extends
                EndpointProducerBuilder {
        default Polly2EndpointBuilder basic() {
            return (Polly2EndpointBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedPolly2EndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedPolly2EndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * To use an existing configured AWS Polly client.
         * 
         * The option is a:
         * <code>software.amazon.awssdk.services.polly.PollyClient</code> type.
         * 
         * Group: advanced
         * 
         * @param pollyClient the value to set
         * @return the dsl builder
         */
        default AdvancedPolly2EndpointBuilder pollyClient(software.amazon.awssdk.services.polly.PollyClient pollyClient) {
            doSetProperty("pollyClient", pollyClient);
            return this;
        }
        /**
         * To use an existing configured AWS Polly client.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.services.polly.PollyClient</code> type.
         * 
         * Group: advanced
         * 
         * @param pollyClient the value to set
         * @return the dsl builder
         */
        default AdvancedPolly2EndpointBuilder pollyClient(String pollyClient) {
            doSetProperty("pollyClient", pollyClient);
            return this;
        }
    }

    public interface Polly2Builders {
        /**
         * AWS Polly (camel-aws2-polly)
         * Synthesize speech using AWS Polly and AWS SDK version 2.x.
         * 
         * Category: cloud,ai
         * Since: 4.18
         * Maven coordinates: org.apache.camel:camel-aws2-polly
         * 
         * @return the dsl builder for the headers' name.
         */
        default Polly2HeaderNameBuilder aws2Polly() {
            return Polly2HeaderNameBuilder.INSTANCE;
        }
        /**
         * AWS Polly (camel-aws2-polly)
         * Synthesize speech using AWS Polly and AWS SDK version 2.x.
         * 
         * Category: cloud,ai
         * Since: 4.18
         * Maven coordinates: org.apache.camel:camel-aws2-polly
         * 
         * Syntax: <code>aws2-polly:label</code>
         * 
         * Path parameter: label (required)
         * Logical name
         * 
         * @param path label
         * @return the dsl builder
         */
        default Polly2EndpointBuilder aws2Polly(String path) {
            return Polly2EndpointBuilderFactory.endpointBuilder("aws2-polly", path);
        }
        /**
         * AWS Polly (camel-aws2-polly)
         * Synthesize speech using AWS Polly and AWS SDK version 2.x.
         * 
         * Category: cloud,ai
         * Since: 4.18
         * Maven coordinates: org.apache.camel:camel-aws2-polly
         * 
         * Syntax: <code>aws2-polly:label</code>
         * 
         * Path parameter: label (required)
         * Logical name
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path label
         * @return the dsl builder
         */
        default Polly2EndpointBuilder aws2Polly(String componentName, String path) {
            return Polly2EndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the AWS Polly component.
     */
    public static class Polly2HeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final Polly2HeaderNameBuilder INSTANCE = new Polly2HeaderNameBuilder();

        /**
         * The operation we want to perform.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsPollyOperation}.
         */
        public String awsPollyOperation() {
            return "CamelAwsPollyOperation";
        }
        /**
         * The voice ID to use for synthesis.
         * 
         * The option is a: {@code
         * software.amazon.awssdk.services.polly.model.VoiceId} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsPollyVoiceId}.
         */
        public String awsPollyVoiceId() {
            return "CamelAwsPollyVoiceId";
        }
        /**
         * The output format for the audio stream.
         * 
         * The option is a: {@code
         * software.amazon.awssdk.services.polly.model.OutputFormat} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsPollyOutputFormat}.
         */
        public String awsPollyOutputFormat() {
            return "CamelAwsPollyOutputFormat";
        }
        /**
         * The type of text input (text or ssml).
         * 
         * The option is a: {@code
         * software.amazon.awssdk.services.polly.model.TextType} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsPollyTextType}.
         */
        public String awsPollyTextType() {
            return "CamelAwsPollyTextType";
        }
        /**
         * The sample rate in Hz.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsPollySampleRate}.
         */
        public String awsPollySampleRate() {
            return "CamelAwsPollySampleRate";
        }
        /**
         * The engine to use (standard, neural, long-form, generative).
         * 
         * The option is a: {@code
         * software.amazon.awssdk.services.polly.model.Engine} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsPollyEngine}.
         */
        public String awsPollyEngine() {
            return "CamelAwsPollyEngine";
        }
        /**
         * The language code.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsPollyLanguageCode}.
         */
        public String awsPollyLanguageCode() {
            return "CamelAwsPollyLanguageCode";
        }
        /**
         * Comma-separated list of lexicon names.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsPollyLexiconNames}.
         */
        public String awsPollyLexiconNames() {
            return "CamelAwsPollyLexiconNames";
        }
        /**
         * The name of the lexicon.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsPollyLexiconName}.
         */
        public String awsPollyLexiconName() {
            return "CamelAwsPollyLexiconName";
        }
        /**
         * The content of the lexicon in PLS format.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsPollyLexiconContent}.
         */
        public String awsPollyLexiconContent() {
            return "CamelAwsPollyLexiconContent";
        }
        /**
         * The task ID for speech synthesis task.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsPollyTaskId}.
         */
        public String awsPollyTaskId() {
            return "CamelAwsPollyTaskId";
        }
        /**
         * The S3 bucket name for output.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsPollyS3Bucket}.
         */
        public String awsPollyS3Bucket() {
            return "CamelAwsPollyS3Bucket";
        }
        /**
         * The S3 key prefix for output.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsPollyS3KeyPrefix}.
         */
        public String awsPollyS3KeyPrefix() {
            return "CamelAwsPollyS3KeyPrefix";
        }
        /**
         * The SNS topic ARN for notifications.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsPollySnsTopicArn}.
         */
        public String awsPollySnsTopicArn() {
            return "CamelAwsPollySnsTopicArn";
        }
        /**
         * The content type of the audio stream.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsPollyContentType}.
         */
        public String awsPollyContentType() {
            return "CamelAwsPollyContentType";
        }
        /**
         * Number of characters synthesized.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsPollyRequestCharacters}.
         */
        public String awsPollyRequestCharacters() {
            return "CamelAwsPollyRequestCharacters";
        }
    }
    static Polly2EndpointBuilder endpointBuilder(String componentName, String path) {
        class Polly2EndpointBuilderImpl extends AbstractEndpointBuilder implements Polly2EndpointBuilder, AdvancedPolly2EndpointBuilder {
            public Polly2EndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new Polly2EndpointBuilderImpl(path);
    }
}