/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.metrics;

import com.datastax.shaded.metrics.Counting;
import com.datastax.shaded.metrics.LongAdderAdapter;
import com.datastax.shaded.metrics.LongAdderProxy;
import com.datastax.shaded.metrics.Metric;
import com.datastax.shaded.metrics.Reservoir;
import com.datastax.shaded.metrics.Sampling;
import com.datastax.shaded.metrics.Snapshot;

public class Histogram
implements Metric,
Sampling,
Counting {
    private final Reservoir reservoir;
    private final LongAdderAdapter count;

    public Histogram(Reservoir reservoir) {
        this.reservoir = reservoir;
        this.count = LongAdderProxy.create();
    }

    public void update(int value) {
        this.update((long)value);
    }

    public void update(long value) {
        this.count.increment();
        this.reservoir.update(value);
    }

    @Override
    public long getCount() {
        return this.count.sum();
    }

    @Override
    public Snapshot getSnapshot() {
        return this.reservoir.getSnapshot();
    }
}

