/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.MessageParams;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.PartitionRangeReadCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.RejectException;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.QueryCancelledException;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.NoSpamLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadCommandVerbHandler
implements IVerbHandler<ReadCommand> {
    public static final ReadCommandVerbHandler instance = new ReadCommandVerbHandler();
    private static final Logger logger = LoggerFactory.getLogger(ReadCommandVerbHandler.class);
    private static final String logMessageTemplate = "Receiving read(s) for token(s) neither owned nor pending. Example: from {} for token {} in {}.{}";
    private static final String exceptionMessageTemplate = "Exception thrown checking if token {} outside valid range for keyspace {} - permitting";

    @Override
    public void doVerb(Message<ReadCommand> message) {
        ReadResponse response;
        ReadCommand command;
        block25: {
            if (StorageService.instance.isBootstrapMode()) {
                throw new RuntimeException("Cannot service reads while bootstrapping!");
            }
            command = (ReadCommand)message.payload;
            if (command.isSinglePartitionRead()) {
                boolean outOfRangeTokenLogging = DatabaseDescriptor.getLogOutOfTokenRangeRequests();
                boolean outOfRangeTokenRejection = DatabaseDescriptor.getRejectOutOfTokenRangeRequests();
                DecoratedKey key = ((SinglePartitionReadCommand)command).partitionKey();
                if (!command.metadata().isVirtual() && this.isOutOfRangeRead(command.metadata().keyspace, key)) {
                    StorageService.instance.incOutOfRangeOperationCount();
                    Keyspace.open((String)command.metadata().keyspace).metric.outOfRangeTokenReads.inc();
                    if (outOfRangeTokenLogging) {
                        NoSpamLogger.log(logger, NoSpamLogger.Level.WARN, 1L, TimeUnit.SECONDS, logMessageTemplate, message.from(), key.getToken(), command.metadata().keyspace, command.metadata().name);
                    }
                    if (outOfRangeTokenRejection) {
                        return;
                    }
                }
            }
            this.validateTransientStatus(message);
            MessageParams.reset();
            long timeout = message.expiresAtNanos() - message.createdAtNanos();
            command.setMonitoringTime(message.createdAtNanos(), message.isCrossNode(), timeout, DatabaseDescriptor.getSlowQueryTimeout(TimeUnit.NANOSECONDS));
            if (message.trackWarnings()) {
                command.trackWarnings();
            }
            try (ReadExecutionController controller = command.executionController(message.trackRepairedData());
                 UnfilteredPartitionIterator iterator = command.executeLocally(controller);){
                response = command.createResponse(iterator, controller.getRepairedDataInfo());
            }
            catch (RejectException e) {
                if (!command.isTrackingWarnings()) {
                    throw e;
                }
                logger.error(e.getMessage());
                response = command.createEmptyResponse();
                Message<ReadCommand> reply = message.responseWith((ReadCommand)((Object)response));
                reply = MessageParams.addToMessage(reply);
                MessagingService.instance().send(reply, message.from());
                return;
            }
            catch (AssertionError t) {
                throw new AssertionError(String.format("Caught an error while trying to process the command: %s", command.toCQLString()), (Throwable)((Object)t));
            }
            catch (QueryCancelledException e) {
                logger.debug("Query cancelled (timeout)", (Throwable)e);
                response = null;
                if ($assertionsDisabled || !command.isCompleted()) break block25;
                throw new AssertionError((Object)("Read marked as completed despite being aborted by timeout to table " + command.metadata()));
            }
        }
        if (command.complete()) {
            Tracing.trace("Enqueuing response to {}", (Object)message.from());
            Message<ReadCommand> reply = message.responseWith((ReadCommand)((Object)response));
            reply = MessageParams.addToMessage(reply);
            MessagingService.instance().send(reply, message.from());
        } else {
            Tracing.trace("Discarding partial response to {} (timed out)", (Object)message.from());
            MessagingService.instance().metrics.recordDroppedMessage(message, message.elapsedSinceCreated(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
        }
    }

    private void validateTransientStatus(Message<ReadCommand> message) {
        ReadCommand command = (ReadCommand)message.payload;
        if (command.metadata().isVirtual()) {
            return;
        }
        Token token = command instanceof SinglePartitionReadCommand ? ((SinglePartitionReadCommand)command).partitionKey().getToken() : ((PartitionPosition)((PartitionRangeReadCommand)command).dataRange().keyRange().right).getToken();
        Replica replica = Keyspace.open(command.metadata().keyspace).getReplicationStrategy().getLocalReplicaFor(token);
        if (replica == null) {
            if (command.isTopK()) {
                return;
            }
            logger.warn("Received a read request from {} for a range that is not owned by the current replica {}.", (Object)message.from(), (Object)command);
            return;
        }
        if (!command.acceptsTransient() && replica.isTransient()) {
            MessagingService.instance().metrics.recordDroppedMessage(message, message.elapsedSinceCreated(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
            throw new InvalidRequestException(String.format("Attempted to serve %s data request from %s node in %s", command.acceptsTransient() ? "transient" : "full", replica.isTransient() ? "transient" : "full", this));
        }
    }

    private boolean isOutOfRangeRead(String keyspace, DecoratedKey key) {
        try {
            return Keyspace.open(keyspace).getReplicationStrategy().getNaturalReplicas(key).selfIfPresent() == null;
        }
        catch (Throwable tr) {
            NoSpamLogger.log(logger, NoSpamLogger.Level.WARN, 1L, TimeUnit.SECONDS, exceptionMessageTemplate, keyspace, key.getKey(), tr);
            return false;
        }
    }
}

