/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.client.retry;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import o.a.c.sidecar.client.shaded.client.HttpResponse;
import o.a.c.sidecar.client.shaded.client.retry.RetryAction;
import o.a.c.sidecar.client.shaded.client.retry.RetryPolicy;
import o.a.c.sidecar.client.shaded.common.request.Request;

public class RunnableOnStatusCodeRetryPolicy
extends RetryPolicy {
    private final RetryPolicy delegate;
    private final AtomicInteger recordedAttempts = new AtomicInteger(0);
    private final int statusCode;
    private final int numberOfEntriesToSkip;
    private final Runnable runnable;

    public RunnableOnStatusCodeRetryPolicy(Runnable runnable, RetryPolicy delegate, int statusCode) {
        this(runnable, delegate, statusCode, 10);
    }

    public RunnableOnStatusCodeRetryPolicy(Runnable runnable, RetryPolicy delegate, int statusCode, int numberOfEntriesToSkip) {
        this.runnable = runnable;
        this.delegate = delegate;
        this.statusCode = statusCode;
        this.numberOfEntriesToSkip = numberOfEntriesToSkip;
    }

    @Override
    public void onResponse(CompletableFuture<HttpResponse> responseFuture, Request request, HttpResponse response, Throwable throwable, int attempts, boolean canRetryOnADifferentHost, RetryAction retryAction) {
        if (response != null && response.statusCode() == this.statusCode && this.recordedAttempts.getAndIncrement() % this.numberOfEntriesToSkip == 0) {
            this.runnable.run();
        }
        this.delegate.onResponse(responseFuture, request, response, throwable, attempts, canRetryOnADifferentHost, retryAction);
    }
}

