/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.avro;

import java.util.Collections;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.spark.data.CqlTable;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.data.partitioner.Partitioner;

public interface CqlToAvroSchemaConverter {
    public CassandraBridge cassandraBridge();

    default public Schema convert(String keyspace, String tableCreateStatement) {
        return this.convert(keyspace, tableCreateStatement, Collections.emptySet());
    }

    default public String schemaStringFromCql(String keyspace, String tableCreateStmt) {
        return this.schemaStringFromCql(keyspace, tableCreateStmt, Collections.emptySet());
    }

    default public String schemaStringFromCql(String keyspace, String tableCreateStmt, Set<String> udts) {
        Schema schema = this.convert(keyspace, tableCreateStmt, udts);
        return schema.toString(true);
    }

    default public void printSchemaFromCql(String keyspace, String tableCreateStmt) {
        this.printSchemaFromCql(keyspace, tableCreateStmt, Collections.emptySet());
    }

    default public void printSchemaFromCql(String keyspace, String tableCreateStmt, Set<String> udts) {
        System.out.println(this.schemaStringFromCql(keyspace, tableCreateStmt, udts));
    }

    default public Schema convert(String keyspace, String tableCreateStatement, Set<String> udts) {
        CqlTable cqlTable = this.cassandraBridge().buildSchema(tableCreateStatement, keyspace, new ReplicationFactor(ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy, Collections.singletonMap("DC1", 3)), Partitioner.Murmur3Partitioner, udts, null, 0, true);
        return this.convert(cqlTable);
    }

    public Schema convert(CqlTable var1);
}

