/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.exceptions;

import org.jetbrains.annotations.Nullable;

public class TransportFailureException
extends RuntimeException {
    public static final int NOT_FOUND_404 = 404;
    @Nullable
    protected final transient Integer statusCode;

    public static TransportFailureException of(String message, Throwable cause) {
        return new TransportFailureException(null, message, cause);
    }

    public static TransportFailureException nonretryable(int statusCode) {
        return new Nonretryable(statusCode);
    }

    public static TransportFailureException retryExhausted(String message, Throwable cause) {
        return new RetryExhausted(message, cause);
    }

    public static TransportFailureException unexpectedResponseType(int statusCode) {
        return new UnexpectedResponseType(statusCode);
    }

    public boolean isNotFound() {
        return this.statusCode != null && this.statusCode == 404;
    }

    public TransportFailureException(int statusCode, String message) {
        super(message);
        this.statusCode = statusCode;
    }

    public TransportFailureException(@Nullable Integer statusCode, String message, Throwable cause) {
        super(message, cause);
        this.statusCode = statusCode;
    }

    public TransportFailureException(@Nullable Integer statusCode, Throwable cause) {
        super(cause);
        this.statusCode = statusCode;
    }

    public static class RetryExhausted
    extends TransportFailureException {
        public RetryExhausted(String message, Throwable cause) {
            super(null, message, cause);
        }
    }

    public static class UnexpectedResponseType
    extends TransportFailureException {
        public UnexpectedResponseType(int statusCode) {
            super(statusCode, "Unexpected http response type: " + statusCode);
        }
    }

    public static class Nonretryable
    extends TransportFailureException {
        public Nonretryable(int statusCode) {
            super(statusCode, "Non-retryable status code: " + statusCode);
        }
    }
}

