/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.reader;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.cassandra.spark.utils.ByteBufferUtils;

public class IndexEntry {
    public final ByteBuffer partitionKey;
    public final BigInteger token;
    public final long uncompressed;
    public final long compressed;

    public IndexEntry(ByteBuffer partitionKey, BigInteger token, long uncompressed, long compressed) {
        this.partitionKey = partitionKey;
        this.token = token;
        this.uncompressed = uncompressed;
        this.compressed = compressed;
    }

    public ByteBuffer getPartitionKey() {
        return this.partitionKey;
    }

    public BigInteger getToken() {
        return this.token;
    }

    public long getCompressed() {
        return this.compressed;
    }

    public long getUncompressed() {
        return this.uncompressed;
    }

    public String toString() {
        return ByteBufferUtils.toHexString(this.partitionKey) + ": " + this.uncompressed + " uncompressed bytes, " + this.compressed + " compressed bytes";
    }
}

