/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.reader.common;

public class BigLongArray {
    static final int DEFAULT_PAGE_SIZE = 4096;
    private final long[][] pages;
    public final int size;
    private final int pageSize;

    public BigLongArray(int size) {
        if (size < 0) {
            throw new IndexOutOfBoundsException(String.format("BigLongArray size cannot be less than 0: %d)", size));
        }
        this.size = size;
        this.pageSize = 4096;
        int lastPageSize = size % this.pageSize;
        int fullPageCount = size / this.pageSize;
        int pageCount = fullPageCount + (lastPageSize == 0 ? 0 : 1);
        this.pages = new long[pageCount][];
        for (int page = 0; page < fullPageCount; ++page) {
            this.pages[page] = new long[this.pageSize];
        }
        if (lastPageSize != 0) {
            this.pages[this.pages.length - 1] = new long[lastPageSize];
        }
    }

    public void set(int index, long value) {
        this.checkIdx(index);
        int page = index / this.pageSize;
        int pageIdx = index % this.pageSize;
        this.pages[page][pageIdx] = value;
    }

    public long get(int index) {
        this.checkIdx(index);
        int page = index / this.pageSize;
        int pageIdx = index % this.pageSize;
        return this.pages[page][pageIdx];
    }

    private void checkIdx(int index) {
        if (index < 0 || this.size < index) {
            throw new IndexOutOfBoundsException(String.format("%d is not within [0, %d)", index, this.size));
        }
    }
}

