/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import org.apache.cassandra.spark.bulkwriter.SqlToCqlTypeConverter;
import org.apache.cassandra.spark.bulkwriter.TTLOption;
import org.apache.cassandra.spark.bulkwriter.TableSchema;
import org.apache.cassandra.spark.bulkwriter.TimestampOption;
import org.apache.cassandra.spark.bulkwriter.WriteMode;
import org.apache.cassandra.spark.common.schema.ColumnType;
import org.jetbrains.annotations.NotNull;

public final class BroadcastableTableSchema
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String createStatement;
    private final String modificationStatement;
    private final List<String> partitionKeyColumns;
    private final List<ColumnType<?>> partitionKeyColumnTypes;
    private final List<SqlToCqlTypeConverter.Converter<?>> converters;
    private final List<Integer> keyFieldPositions;
    private final WriteMode writeMode;
    private final TTLOption ttlOption;
    private final TimestampOption timestampOption;
    private final String lowestCassandraVersion;
    private final boolean quoteIdentifiers;

    public static BroadcastableTableSchema from(@NotNull TableSchema source) {
        return new BroadcastableTableSchema(source.createStatement, source.modificationStatement, source.partitionKeyColumns, source.partitionKeyColumnTypes, source.converters, source.keyFieldPositions, source.writeMode, source.ttlOption, source.timestampOption, source.lowestCassandraVersion, source.quoteIdentifiers);
    }

    private BroadcastableTableSchema(String createStatement, String modificationStatement, List<String> partitionKeyColumns, List<ColumnType<?>> partitionKeyColumnTypes, List<SqlToCqlTypeConverter.Converter<?>> converters, List<Integer> keyFieldPositions, WriteMode writeMode, TTLOption ttlOption, TimestampOption timestampOption, String lowestCassandraVersion, boolean quoteIdentifiers) {
        this.createStatement = createStatement;
        this.modificationStatement = modificationStatement;
        this.partitionKeyColumns = partitionKeyColumns;
        this.partitionKeyColumnTypes = partitionKeyColumnTypes;
        this.converters = converters;
        this.keyFieldPositions = keyFieldPositions;
        this.writeMode = writeMode;
        this.ttlOption = ttlOption;
        this.timestampOption = timestampOption;
        this.lowestCassandraVersion = lowestCassandraVersion;
        this.quoteIdentifiers = quoteIdentifiers;
    }

    public String getCreateStatement() {
        return this.createStatement;
    }

    public String getModificationStatement() {
        return this.modificationStatement;
    }

    public List<String> getPartitionKeyColumns() {
        return this.partitionKeyColumns;
    }

    public List<ColumnType<?>> getPartitionKeyColumnTypes() {
        return this.partitionKeyColumnTypes;
    }

    public List<SqlToCqlTypeConverter.Converter<?>> getConverters() {
        return this.converters;
    }

    public List<Integer> getKeyFieldPositions() {
        return this.keyFieldPositions;
    }

    public WriteMode getWriteMode() {
        return this.writeMode;
    }

    public TTLOption getTtlOption() {
        return this.ttlOption;
    }

    public TimestampOption getTimestampOption() {
        return this.timestampOption;
    }

    public String getLowestCassandraVersion() {
        return this.lowestCassandraVersion;
    }

    public boolean isQuoteIdentifiers() {
        return this.quoteIdentifiers;
    }

    public Object[] normalize(Object[] row) {
        for (int index = 0; index < row.length; ++index) {
            row[index] = this.converters.get(index).convert(row[index]);
        }
        return row;
    }

    public Object[] getKeyColumns(Object[] allColumns) {
        return BroadcastableTableSchema.getKeyColumns(allColumns, this.keyFieldPositions);
    }

    @NotNull
    public static Object[] getKeyColumns(Object[] allColumns, List<Integer> keyFieldPositions) {
        Object[] result = new Object[keyFieldPositions.size()];
        for (int keyFieldPosition = 0; keyFieldPosition < keyFieldPositions.size(); ++keyFieldPosition) {
            Object colVal = allColumns[keyFieldPositions.get(keyFieldPosition)];
            Preconditions.checkNotNull((Object)colVal, (Object)"Found a null primary or composite key column in source data. All key columns must be non-null.");
            result[keyFieldPosition] = colVal;
        }
        return result;
    }
}

