/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.cassandra.spark.bulkwriter.util.FastByteOperations;
import org.apache.cassandra.spark.utils.ByteBufferUtils;
import org.jetbrains.annotations.NotNull;

public class DecoratedKey
implements Comparable<DecoratedKey>,
Serializable {
    @NotNull
    private final BigInteger token;
    @NotNull
    private final ByteBuffer key;

    DecoratedKey(@NotNull BigInteger token, @NotNull ByteBuffer key) {
        this.token = token;
        this.key = key;
    }

    @NotNull
    public BigInteger getToken() {
        return this.token;
    }

    @NotNull
    public ByteBuffer getKey() {
        return this.key;
    }

    @Override
    public int compareTo(@NotNull DecoratedKey that) {
        int cmp = this.token.compareTo(that.token);
        if (cmp != 0) {
            return cmp;
        }
        return FastByteOperations.compareUnsigned(this.key, that.key);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DecoratedKey that = (DecoratedKey)other;
        return this.token.equals(that.token) && this.key.equals(that.key);
    }

    public int hashCode() {
        return this.token.hashCode() ^ this.key.hashCode();
    }

    public String toString() {
        String keystring = ByteBufferUtils.toHexString((ByteBuffer)this.getKey());
        return "SBW-DecoratedKey(" + String.valueOf(this.getToken()) + ", " + keystring + ")";
    }
}

