/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.complex;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.base.Preconditions;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.cql3.functions.types.DataType;
import org.apache.cassandra.cql3.functions.types.SettableByIndexData;
import org.apache.cassandra.cql3.functions.types.UDTValue;
import org.apache.cassandra.cql3.functions.types.UserType;
import org.apache.cassandra.cql3.functions.types.UserTypeHelper;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.serializers.UTF8Serializer;
import org.apache.cassandra.spark.data.CassandraTypes;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.CqlType;
import org.apache.cassandra.spark.data.TypeConverter;
import org.apache.cassandra.spark.data.complex.CqlFrozen;
import org.apache.cassandra.spark.utils.ByteBufferUtils;
import org.apache.cassandra.transport.ProtocolVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CqlUdt
extends CqlType
implements CqlField.CqlUdt {
    private final String keyspace;
    private final String name;
    private final List<CqlField> fields;
    private final Map<String, CqlField> fieldMap;
    private final int hashCode;

    CqlUdt(String keyspace, String name, List<CqlField> fields) {
        this.keyspace = keyspace;
        this.name = name;
        this.fields = Collections.unmodifiableList(fields);
        this.fieldMap = this.fields.stream().collect(Collectors.toMap(CqlField::name, Function.identity()));
        this.hashCode = Objects.hash(this.internalType().ordinal(), this.keyspace, this.name, this.fields);
    }

    public Set<CqlField.CqlUdt> udts() {
        Set<CqlField.CqlUdt> udts = this.fields.stream().map(CqlField::type).map(type -> (CqlType)type).map(CqlField.CqlType::udts).flatMap(Collection::stream).collect(Collectors.toSet());
        udts.add(this);
        return udts;
    }

    @Override
    public Object randomValue(int minCollectionSize) {
        return this.fields().stream().collect(Collectors.toMap(CqlField::name, field -> Objects.requireNonNull(field.type().randomValue(minCollectionSize))));
    }

    @Override
    protected void setInnerValueInternal(SettableByIndexData<?> udtValue, int position, Object value) {
        udtValue.setUDTValue(position, (UDTValue)value);
    }

    @Override
    public DataType driverDataType(boolean isFrozen) {
        return UserTypeHelper.newUserType(this.keyspace(), this.name(), isFrozen, this.fields().stream().map(field -> UserTypeHelper.newField(field.name(), ((CqlType)field.type()).driverDataType(isFrozen))).collect(Collectors.toList()), ProtocolVersion.V3);
    }

    public Object convertForCqlWriter(@NotNull Object value, CassandraVersion version, boolean isCollectionElement) {
        if (value instanceof UDTValue) {
            return value;
        }
        return CqlUdt.toUserTypeValue(version, this, value);
    }

    @Override
    public String toString() {
        return this.cqlName();
    }

    public CqlFrozen frozen() {
        return CqlFrozen.build(this);
    }

    public static Builder builder(String keyspace, String name) {
        return new Builder(keyspace, name);
    }

    public boolean isSupported() {
        return true;
    }

    @Override
    public AbstractType<?> dataType() {
        return this.dataType(true);
    }

    @Override
    public AbstractType<?> dataType(boolean isMultiCell) {
        return (AbstractType)Schema.instance.getKeyspaceMetadata((String)this.keyspace()).types.get(UTF8Serializer.instance.serialize(this.name())).orElseThrow(() -> new RuntimeException(String.format("UDT '%s' not initialized", this.name())));
    }

    @Override
    public <T> TypeSerializer<T> serializer() {
        return ((org.apache.cassandra.db.marshal.UserType)Schema.instance.getKeyspaceMetadata((String)this.keyspace()).types.get(UTF8Serializer.instance.serialize(this.name())).orElseThrow(() -> new RuntimeException(String.format("UDT '%s' not initialized", this.name())))).getSerializer();
    }

    public Object deserializeToType(TypeConverter converter, ByteBuffer buffer, boolean isFrozen) {
        Map<String, Object> value = this.deserializeUdt(converter, buffer, isFrozen);
        return value != null ? converter.convert((CqlField.CqlType)this, value, isFrozen) : null;
    }

    public Map<String, Object> deserializeUdt(TypeConverter typeConverter, ByteBuffer buffer, boolean isFrozen) {
        if (!isFrozen) {
            int fieldCount = buffer.getInt();
            Preconditions.checkArgument((fieldCount == this.size() ? 1 : 0) != 0, (Object)String.format("Unexpected number of fields deserializing UDT '%s', expected %d fields but %d found", this.cqlName(), this.size(), fieldCount));
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(this.size());
        for (CqlField field : this.fields()) {
            if (buffer.remaining() < 4) break;
            int length = buffer.getInt();
            result.put(field.name(), length > 0 ? field.deserializeToType(typeConverter, ByteBufferUtils.readBytes((ByteBuffer)buffer, (int)length), isFrozen) : null);
        }
        return result;
    }

    @Override
    public ByteBuffer serialize(Object value) {
        return this.serializeUdt((Map)value);
    }

    public ByteBuffer serializeUdt(Map<String, Object> values) {
        List buffers = this.fields().stream().map(field -> field.serialize(values.get(field.name()))).collect(Collectors.toList());
        ByteBuffer result = ByteBuffer.allocate(4 + buffers.stream().map(Buffer::remaining).map(remaining -> remaining + 4).reduce(Integer::sum).orElse(0));
        result.putInt(buffers.size());
        for (ByteBuffer buffer : buffers) {
            result.putInt(buffer.remaining());
            result.put(buffer.duplicate());
        }
        return result.flip();
    }

    public CqlField.CqlType.InternalType internalType() {
        return CqlField.CqlType.InternalType.Udt;
    }

    public String createStatement(CassandraTypes cassandraTypes, String keyspace) {
        return String.format("CREATE TYPE %s.%s (%s);", cassandraTypes.maybeQuoteIdentifier(keyspace), cassandraTypes.maybeQuoteIdentifier(this.name), this.fieldsString(cassandraTypes));
    }

    private String fieldsString(CassandraTypes cassandraTypes) {
        return this.fields.stream().map(field -> CqlUdt.fieldString(cassandraTypes, field)).collect(Collectors.joining(", "));
    }

    private static String fieldString(CassandraTypes cassandraTypes, CqlField field) {
        return String.format("%s %s", cassandraTypes.maybeQuoteIdentifier(field.name()), field.type().cqlName());
    }

    public String keyspace() {
        return this.keyspace;
    }

    public String name() {
        return this.name;
    }

    public int size() {
        return this.fields.size();
    }

    public List<CqlField> fields() {
        return this.fields;
    }

    public CqlField field(String name) {
        return this.fieldMap.get(name);
    }

    public CqlField field(int position) {
        return this.fields.get(position);
    }

    public CqlField.CqlType type(int position) {
        return this.field(position).type();
    }

    public String cqlName() {
        return this.name;
    }

    public static CqlUdt read(Input input, CassandraTypes cassandraTypes) {
        Builder builder = CqlUdt.builder(input.readString(), input.readString());
        int numFields = input.readInt();
        for (int field = 0; field < numFields; ++field) {
            builder.withField(input.readString(), CqlField.CqlType.read((Input)input, (CassandraTypes)cassandraTypes));
        }
        return builder.build();
    }

    public void write(Output output) {
        CqlField.CqlType.write((CqlField.CqlType)this, (Output)output);
        output.writeString(this.keyspace);
        output.writeString(this.name);
        output.writeInt(this.fields.size());
        for (CqlField field : this.fields) {
            output.writeString(field.name());
            field.type().write(output);
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        CqlUdt that = (CqlUdt)other;
        return this.internalType() == that.internalType() && Objects.equals(this.keyspace, that.keyspace) && Objects.equals(this.name, that.name) && Objects.equals(this.fields, that.fields);
    }

    public static UDTValue toUserTypeValue(CassandraVersion version, CqlUdt udt, @NotNull Object value) {
        Map values = (Map)value;
        UDTValue udtValue = UserTypeHelper.newUDTValue(CqlUdt.toUserType(udt));
        int position = 0;
        for (CqlField field : udt.fields()) {
            CqlUdt.setNullableInnerValue(version, udtValue, (CqlType)field.type(), position++, values.get(field.name()));
        }
        return udtValue;
    }

    public static void setNullableInnerValue(CassandraVersion version, SettableByIndexData<?> udtValue, CqlType type, int position, @Nullable Object value) {
        type.setInnerValue(udtValue, position, value == null ? null : type.convertForCqlWriter(value, version, false));
    }

    public static UserType toUserType(CqlUdt udt) {
        List<UserType.Field> fields = udt.fields().stream().map(field -> UserTypeHelper.newField(field.name(), ((CqlType)field.type()).driverDataType())).collect(Collectors.toList());
        return UserTypeHelper.newUserType(udt.keyspace(), udt.name(), true, fields, ProtocolVersion.V3);
    }

    public static class Serializer
    extends com.esotericsoftware.kryo.Serializer<CqlUdt> {
        private final CassandraTypes cassandraTypes;

        public Serializer(CassandraTypes cassandraTypes) {
            this.cassandraTypes = cassandraTypes;
        }

        public CqlUdt read(Kryo kryo, Input input, Class type) {
            return CqlUdt.read(input, this.cassandraTypes);
        }

        public void write(Kryo kryo, Output output, CqlUdt udt) {
            udt.write(output);
        }
    }

    public static class Builder
    implements CqlField.CqlUdtBuilder {
        private final String keyspace;
        private final String name;
        private final List<CqlField> fields = new ArrayList<CqlField>();

        public Builder(String keyspace, String name) {
            this.keyspace = keyspace;
            this.name = name;
        }

        public Builder withField(String name, CqlField.CqlType type) {
            this.fields.add(new CqlField(false, false, false, name, type, this.fields.size()));
            return this;
        }

        public CqlUdt build() {
            return new CqlUdt(this.keyspace, this.name, this.fields);
        }
    }
}

