/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.types;

import java.math.BigInteger;
import org.apache.cassandra.bridge.BigNumberConfig;
import org.apache.cassandra.cql3.functions.types.DataType;
import org.apache.cassandra.cql3.functions.types.SettableByIndexData;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.spark.data.types.Decimal;
import org.apache.cassandra.spark.utils.RandomUtils;

public class VarInt
extends Decimal {
    public static final VarInt INSTANCE = new VarInt();

    @Override
    public String name() {
        return "varint";
    }

    @Override
    public AbstractType<?> dataType() {
        return IntegerType.instance;
    }

    @Override
    public Object randomValue(int minCollectionSize) {
        return new BigInteger(BigNumberConfig.DEFAULT.bigIntegerPrecision(), RandomUtils.RANDOM);
    }

    @Override
    protected void setInnerValueInternal(SettableByIndexData<?> udtValue, int position, Object value) {
        udtValue.setVarint(position, (BigInteger)value);
    }

    @Override
    public DataType driverDataType(boolean isFrozen) {
        return DataType.varint();
    }
}

