/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.validation;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.function.Supplier;
import org.apache.cassandra.secrets.SecretsProvider;
import org.apache.cassandra.spark.utils.Throwing;
import org.apache.cassandra.spark.validation.StartupValidation;
import org.jetbrains.annotations.NotNull;

public class TrustStoreValidation
implements StartupValidation {
    private final boolean configured;
    private final String type;
    private final char[] password;
    private final Supplier<InputStream> stream;

    public TrustStoreValidation(@NotNull SecretsProvider secrets) {
        this(secrets.hasTrustStoreSecrets(), secrets.trustStoreType(), secrets.trustStorePassword(), Throwing.supplier(() -> ((SecretsProvider)secrets).trustStoreInputStream()));
    }

    protected TrustStoreValidation(boolean configured, String type, char[] password, Supplier<InputStream> stream) {
        this.configured = configured;
        this.type = type;
        this.password = password;
        this.stream = stream;
    }

    @Override
    public void validate() {
        try {
            if (!this.configured) {
                return;
            }
            KeyStore trustStore = KeyStore.getInstance(this.type);
            trustStore.load(this.stream.get(), this.password);
            if (trustStore.size() == 0) {
                throw new RuntimeException("TrustStore is empty");
            }
            Enumeration<String> aliases = trustStore.aliases();
            while (aliases.hasMoreElements()) {
                Certificate certificate = trustStore.getCertificate(aliases.nextElement());
                if (certificate == null) continue;
                return;
            }
            throw new RuntimeException("TrustStore contains no certificates");
        }
        catch (IOException | GeneralSecurityException exception) {
            throw new RuntimeException("TrustStore is misconfigured", exception);
        }
    }
}

