/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.datahub;

import com.datastax.driver.core.TableMetadata;
import com.linkedin.common.urn.Urn;
import com.linkedin.container.Container;
import datahub.event.MetadataChangeProposalWrapper;
import java.net.URISyntaxException;
import org.apache.cassandra.sidecar.datahub.IdentifiersProvider;
import org.apache.cassandra.sidecar.datahub.TableToAspectConverter;
import org.jetbrains.annotations.NotNull;

public class TableToContainerConverter
extends TableToAspectConverter<Container> {
    public TableToContainerConverter(@NotNull IdentifiersProvider identifiers) {
        super(identifiers);
    }

    @Override
    @NotNull
    public MetadataChangeProposalWrapper<Container> convert(@NotNull TableMetadata table) throws URISyntaxException {
        String urn = this.identifiers.urnDataset(table);
        String container = this.identifiers.urnContainer(table.getKeyspace());
        Container aspect = new Container().setContainer(new Urn(container));
        return this.wrap(urn, aspect);
    }
}

