/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.livemigration;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationFileVisitor
extends SimpleFileVisitor<Path> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrationFileVisitor.class);
    private final String homeDir;
    private final List<Path> validFiles;
    private final List<PathMatcher> filesToExclude;
    private final List<PathMatcher> directoriesToExclude;

    public MigrationFileVisitor(@NotNull String homeDir, @NotNull List<PathMatcher> filesToExcludeMatchers, @NotNull List<PathMatcher> directoriesToExcludeMatchers) {
        this.homeDir = homeDir;
        this.validFiles = new ArrayList<Path>();
        this.filesToExclude = filesToExcludeMatchers;
        this.directoriesToExclude = directoriesToExcludeMatchers;
    }

    private boolean shouldExcludeDir(Path dir) {
        Objects.requireNonNull(dir);
        return this.directoriesToExclude.stream().anyMatch(matcher -> matcher.matches(dir));
    }

    private boolean shouldExcludeFile(Path file) {
        Objects.requireNonNull(file);
        return this.filesToExclude.stream().anyMatch(matcher -> matcher.matches(file));
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
        if (this.shouldExcludeDir(dir)) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        if (!dir.toAbsolutePath().toString().equals(this.homeDir)) {
            this.validFiles.add(dir);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
        Objects.requireNonNull(file);
        Objects.requireNonNull(attrs);
        if (!this.shouldExcludeFile(file)) {
            this.validFiles.add(file);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        Objects.requireNonNull(file);
        boolean isDirectory = Files.isDirectory(file, new LinkOption[0]);
        String absolutePath = file.toFile().getAbsolutePath();
        if (isDirectory && this.shouldExcludeDir(file) || !isDirectory && this.shouldExcludeFile(file)) {
            LOGGER.info("Got the exception wile trying to visit: {}. However, it's a part of the exclude list. Hence ignoring the exception.", (Object)absolutePath, (Object)exc);
            return FileVisitResult.CONTINUE;
        }
        LOGGER.error("File/Directory visit failed for: {}", (Object)absolutePath, (Object)exc);
        throw exc;
    }

    public List<Path> validFilePaths() {
        return this.validFiles;
    }
}

