/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client.read;

import com.github.luben.zstd.ZstdException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import net.jpountz.lz4.LZ4Exception;
import org.apache.celeborn.client.ClientUtils;
import org.apache.celeborn.client.ShuffleClient;
import org.apache.celeborn.client.compress.Decompressor;
import org.apache.celeborn.client.read.DfsPartitionReader;
import org.apache.celeborn.client.read.LocalPartitionReader;
import org.apache.celeborn.client.read.MetricsCallback;
import org.apache.celeborn.client.read.PartitionReader;
import org.apache.celeborn.client.read.WorkerPartitionReader;
import org.apache.celeborn.client.read.checkpoint.PartitionReaderCheckpointMetadata;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.exception.CelebornIOException;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.client.TransportClientFactory;
import org.apache.celeborn.common.network.protocol.TransportMessage;
import org.apache.celeborn.common.protocol.CompressionCodec;
import org.apache.celeborn.common.protocol.MessageType;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.PbBufferStreamEnd;
import org.apache.celeborn.common.protocol.PbStreamHandler;
import org.apache.celeborn.common.protocol.StorageInfo;
import org.apache.celeborn.common.protocol.StreamType;
import org.apache.celeborn.common.unsafe.Platform;
import org.apache.celeborn.common.util.ExceptionMaker;
import org.apache.celeborn.common.util.Utils;
import org.apache.celeborn.common.write.LocationPushFailedBatches;
import org.apache.celeborn.shaded.com.google.common.util.concurrent.Uninterruptibles;
import org.apache.celeborn.shaded.io.netty.buffer.ByteBuf;
import org.apache.celeborn.shaded.org.apache.commons.lang3.tuple.Pair;
import org.apache.celeborn.shaded.org.roaringbitmap.RoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public abstract class CelebornInputStream
extends InputStream {
    private static final Logger logger = LoggerFactory.getLogger(CelebornInputStream.class);
    private static final CelebornInputStream emptyInputStream = new CelebornInputStream(){

        @Override
        public int read() throws IOException {
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return -1;
        }

        @Override
        public int totalPartitionsToRead() {
            return 0;
        }

        @Override
        public int partitionsRead() {
            return 0;
        }
    };

    public static CelebornInputStream create(CelebornConf conf, TransportClientFactory clientFactory, String shuffleKey, ArrayList<PartitionLocation> locations, ArrayList<PbStreamHandler> streamHandlers, int[] attempts, Map<String, LocationPushFailedBatches> failedBatchSetMap, Map<String, Pair<Integer, Integer>> chunksRange, int attemptNumber, long taskId, int startMapIndex, int endMapIndex, ConcurrentHashMap<String, Long> fetchExcludedWorkers, ShuffleClient shuffleClient, int appShuffleId, int shuffleId, int partitionId, ExceptionMaker exceptionMaker, MetricsCallback metricsCallback, boolean needDecompress) throws IOException {
        if (locations == null || locations.isEmpty()) {
            return emptyInputStream;
        }
        boolean readSkewPartitionWithoutMapRange = ClientUtils.readSkewPartitionWithoutMapRange(conf, startMapIndex, endMapIndex);
        if (readSkewPartitionWithoutMapRange) {
            return new CelebornInputStreamImpl(conf, clientFactory, shuffleKey, locations, streamHandlers, attempts, failedBatchSetMap, attemptNumber, taskId, chunksRange, fetchExcludedWorkers, shuffleClient, appShuffleId, shuffleId, partitionId, exceptionMaker, true, metricsCallback, needDecompress);
        }
        return new CelebornInputStreamImpl(conf, clientFactory, shuffleKey, locations, streamHandlers, attempts, failedBatchSetMap, attemptNumber, taskId, startMapIndex, endMapIndex, null, fetchExcludedWorkers, shuffleClient, appShuffleId, shuffleId, partitionId, exceptionMaker, false, metricsCallback, needDecompress);
    }

    public static CelebornInputStream empty() {
        return emptyInputStream;
    }

    public abstract int totalPartitionsToRead();

    public abstract int partitionsRead();

    private static final class CelebornInputStreamImpl
    extends CelebornInputStream {
        private static final Random RAND = new Random();
        private final CelebornConf conf;
        private final TransportClientFactory clientFactory;
        private final String shuffleKey;
        private ArrayList<PartitionLocation> locations;
        private ArrayList<PbStreamHandler> streamHandlers;
        private int[] attempts;
        private final int attemptNumber;
        private final long taskId;
        private final int startMapIndex;
        private final int endMapIndex;
        private final Map<String, Pair<Integer, Integer>> partitionLocationToChunkRange;
        private Map<Integer, Set<Integer>> batchesRead = new HashMap<Integer, Set<Integer>>();
        private final Map<String, LocationPushFailedBatches> failedBatches;
        private byte[] compressedBuf;
        private byte[] rawDataBuf;
        private Decompressor decompressor;
        private ByteBuf currentChunk;
        private boolean firstChunk = true;
        private PartitionReader currentReader;
        private final int fetchChunkMaxRetry;
        private int fetchChunkRetryCnt = 0;
        int retryWaitMs;
        private int fileIndex;
        private int position;
        private int limit;
        private MetricsCallback callback;
        private final int BATCH_HEADER_SIZE = 16;
        private final byte[] sizeBuf = new byte[16];
        private LongAdder skipCount = new LongAdder();
        private final boolean rangeReadFilter;
        private final boolean enabledReadLocalShuffle;
        private final String localHostAddress;
        private boolean shouldDecompress;
        private long fetchExcludedWorkerExpireTimeout;
        private ConcurrentHashMap<String, Long> fetchExcludedWorkers;
        private boolean containLocalRead = false;
        private ShuffleClient shuffleClient;
        private int appShuffleId;
        private int shuffleId;
        private int partitionId;
        private ExceptionMaker exceptionMaker;
        private boolean closed = false;
        private final boolean readSkewPartitionWithoutMapRange;

        CelebornInputStreamImpl(CelebornConf conf, TransportClientFactory clientFactory, String shuffleKey, ArrayList<PartitionLocation> locations, ArrayList<PbStreamHandler> streamHandlers, int[] attempts, Map<String, LocationPushFailedBatches> failedBatchSet, int attemptNumber, long taskId, Map<String, Pair<Integer, Integer>> partitionLocationToChunkRange, ConcurrentHashMap<String, Long> fetchExcludedWorkers, ShuffleClient shuffleClient, int appShuffleId, int shuffleId, int partitionId, ExceptionMaker exceptionMaker, boolean splitSkewPartitionWithoutMapRange, MetricsCallback metricsCallback, boolean needDecompress) throws IOException {
            this(conf, clientFactory, shuffleKey, locations, streamHandlers, attempts, failedBatchSet, attemptNumber, taskId, -1, -1, partitionLocationToChunkRange, fetchExcludedWorkers, shuffleClient, appShuffleId, shuffleId, partitionId, exceptionMaker, splitSkewPartitionWithoutMapRange, metricsCallback, needDecompress);
        }

        CelebornInputStreamImpl(CelebornConf conf, TransportClientFactory clientFactory, String shuffleKey, ArrayList<PartitionLocation> locations, ArrayList<PbStreamHandler> streamHandlers, int[] attempts, Map<String, LocationPushFailedBatches> failedBatchSet, int attemptNumber, long taskId, int startMapIndex, int endMapIndex, Map<String, Pair<Integer, Integer>> partitionLocationToChunkRange, ConcurrentHashMap<String, Long> fetchExcludedWorkers, ShuffleClient shuffleClient, int appShuffleId, int shuffleId, int partitionId, ExceptionMaker exceptionMaker, boolean readSkewPartitionWithoutMapRange, MetricsCallback metricsCallback, boolean needDecompress) throws IOException {
            this.conf = conf;
            this.clientFactory = clientFactory;
            this.shuffleKey = shuffleKey;
            this.locations = locations;
            if (streamHandlers != null && streamHandlers.size() == locations.size()) {
                this.streamHandlers = streamHandlers;
            }
            this.attempts = attempts;
            this.attemptNumber = attemptNumber;
            this.taskId = taskId;
            this.startMapIndex = startMapIndex;
            this.endMapIndex = endMapIndex;
            this.partitionLocationToChunkRange = partitionLocationToChunkRange;
            this.rangeReadFilter = conf.shuffleRangeReadFilterEnabled();
            this.enabledReadLocalShuffle = conf.enableReadLocalShuffleFile();
            this.localHostAddress = Utils.localHostName(conf);
            this.shouldDecompress = !conf.shuffleCompressionCodec().equals((Object)CompressionCodec.NONE) && needDecompress;
            this.fetchExcludedWorkerExpireTimeout = conf.clientFetchExcludedWorkerExpireTimeout();
            this.failedBatches = failedBatchSet;
            this.readSkewPartitionWithoutMapRange = readSkewPartitionWithoutMapRange;
            this.fetchExcludedWorkers = fetchExcludedWorkers;
            this.fetchChunkMaxRetry = conf.clientPushReplicateEnabled() ? conf.clientFetchMaxRetriesForEachReplica() * 2 : conf.clientFetchMaxRetriesForEachReplica();
            this.retryWaitMs = conf.networkIoRetryWaitMs("data");
            this.callback = metricsCallback;
            this.exceptionMaker = exceptionMaker;
            this.partitionId = partitionId;
            this.appShuffleId = appShuffleId;
            this.shuffleId = shuffleId;
            this.shuffleClient = shuffleClient;
            boolean chunkPrefetchEnabled = conf.clientChunkPrefetchEnabled();
            this.moveToNextReader(chunkPrefetchEnabled);
            if (chunkPrefetchEnabled) {
                this.init();
                this.firstChunk = false;
            }
        }

        private boolean skipLocation(int startMapIndex, int endMapIndex, PartitionLocation location) {
            if (!this.rangeReadFilter) {
                return false;
            }
            if (endMapIndex == Integer.MAX_VALUE) {
                return false;
            }
            RoaringBitmap bitmap = location.getMapIdBitMap();
            if (bitmap == null && location.hasPeer()) {
                bitmap = location.getPeer().getMapIdBitMap();
            }
            for (int i = startMapIndex; i < endMapIndex; ++i) {
                if (!bitmap.contains(i)) continue;
                return false;
            }
            return true;
        }

        private Tuple2<PartitionLocation, PbStreamHandler> nextReadableLocation() {
            int locationCount = this.locations.size();
            if (this.fileIndex >= locationCount) {
                return null;
            }
            PartitionLocation currentLocation = this.locations.get(this.fileIndex);
            while (this.readSkewPartitionWithoutMapRange && !this.partitionLocationToChunkRange.containsKey(currentLocation.getUniqueId()) || !this.readSkewPartitionWithoutMapRange && this.skipLocation(this.startMapIndex, this.endMapIndex, currentLocation)) {
                this.skipCount.increment();
                ++this.fileIndex;
                if (this.fileIndex == locationCount) {
                    return null;
                }
                currentLocation = this.locations.get(this.fileIndex);
            }
            this.fetchChunkRetryCnt = 0;
            return new Tuple2((Object)currentLocation, this.streamHandlers == null ? null : this.streamHandlers.get(this.fileIndex));
        }

        private void moveToNextReader(boolean fetchChunk) throws IOException {
            Tuple2<PartitionLocation, PbStreamHandler> currentLocation;
            if (this.currentReader != null) {
                this.currentReader.close();
                this.currentReader = null;
            }
            if ((currentLocation = this.nextReadableLocation()) == null) {
                return;
            }
            this.currentReader = this.createReaderWithRetry((PartitionLocation)currentLocation._1, (PbStreamHandler)currentLocation._2);
            ++this.fileIndex;
            while (!this.currentReader.hasNext() || fetchChunk && (this.currentChunk = this.getNextChunk()) == null) {
                this.currentReader.close();
                this.currentReader = null;
                currentLocation = this.nextReadableLocation();
                if (currentLocation == null) {
                    return;
                }
                this.currentReader = this.createReaderWithRetry((PartitionLocation)currentLocation._1, (PbStreamHandler)currentLocation._2);
                ++this.fileIndex;
            }
        }

        private boolean isExcluded(PartitionLocation location) {
            Long timestamp = this.fetchExcludedWorkers.get(location.hostAndFetchPort());
            if (timestamp == null) {
                return false;
            }
            if (System.currentTimeMillis() - timestamp > this.fetchExcludedWorkerExpireTimeout) {
                this.fetchExcludedWorkers.remove(location.hostAndFetchPort());
                return false;
            }
            if (location.getPeer() != null) {
                Long peerTimestamp = this.fetchExcludedWorkers.get(location.getPeer().hostAndFetchPort());
                return peerTimestamp == null || peerTimestamp < timestamp;
            }
            return true;
        }

        private PartitionReader createReaderWithRetry(PartitionLocation location, PbStreamHandler pbStreamHandler) throws IOException {
            return this.createReaderWithRetry(location, pbStreamHandler, Optional.empty());
        }

        private PartitionReader createReaderWithRetry(PartitionLocation location, PbStreamHandler pbStreamHandler, Optional<PartitionReaderCheckpointMetadata> checkpointMetadata) throws IOException {
            Exception lastException = null;
            while (this.fetchChunkRetryCnt < this.fetchChunkMaxRetry) {
                try {
                    logger.debug("Create reader for location {}", (Object)location);
                    if (this.isExcluded(location)) {
                        throw new CelebornIOException("Fetch data from excluded worker! " + location);
                    }
                    PartitionReader reader = this.createReader(location, pbStreamHandler, this.fetchChunkRetryCnt, this.fetchChunkMaxRetry, checkpointMetadata);
                    return reader;
                }
                catch (Exception e) {
                    lastException = e;
                    this.shuffleClient.excludeFailedFetchLocation(location.hostAndFetchPort(), e);
                    ++this.fetchChunkRetryCnt;
                    if (location.hasPeer() && !this.readSkewPartitionWithoutMapRange) {
                        if (this.fetchChunkRetryCnt % 2 == 0) {
                            Uninterruptibles.sleepUninterruptibly(this.retryWaitMs, TimeUnit.MILLISECONDS);
                        }
                        logger.warn("CreatePartitionReader failed {}/{} times for location {}, change to peer", new Object[]{this.fetchChunkRetryCnt, this.fetchChunkMaxRetry, location, e});
                        if (pbStreamHandler != null) {
                            try {
                                TransportClient client = this.clientFactory.createClient(location.getHost(), location.getFetchPort());
                                TransportMessage bufferStreamEnd = new TransportMessage(MessageType.BUFFER_STREAM_END, PbBufferStreamEnd.newBuilder().setStreamType(StreamType.ChunkStream).setStreamId(pbStreamHandler.getStreamId()).build().toByteArray());
                                client.sendRpc(bufferStreamEnd.toByteBuffer());
                            }
                            catch (IOException | InterruptedException ex) {
                                logger.warn("Close {} stream {} failed", new Object[]{location.hostAndFetchPort(), pbStreamHandler.getStreamId(), ex});
                            }
                            pbStreamHandler = null;
                        }
                        location = location.getPeer();
                        continue;
                    }
                    logger.warn("CreatePartitionReader failed {}/{} times for location {}, retry the same location", new Object[]{this.fetchChunkRetryCnt, this.fetchChunkMaxRetry, location, e});
                    Uninterruptibles.sleepUninterruptibly(this.retryWaitMs, TimeUnit.MILLISECONDS);
                }
            }
            throw new CelebornIOException("createPartitionReader failed! " + location, (Throwable)lastException);
        }

        private ByteBuf getNextChunk() throws IOException {
            while (this.fetchChunkRetryCnt < this.fetchChunkMaxRetry) {
                try {
                    if (this.isExcluded(this.currentReader.getLocation())) {
                        throw new CelebornIOException("Fetch data from excluded worker! " + this.currentReader.getLocation());
                    }
                    if (!this.currentReader.hasNext()) {
                        return null;
                    }
                    return this.currentReader.next();
                }
                catch (Exception e) {
                    this.shuffleClient.excludeFailedFetchLocation(this.currentReader.getLocation().hostAndFetchPort(), e);
                    ++this.fetchChunkRetryCnt;
                    this.currentReader.close();
                    if (this.fetchChunkRetryCnt == this.fetchChunkMaxRetry) {
                        logger.warn("Fetch chunk fail exceeds max retry {}", (Object)this.fetchChunkRetryCnt, (Object)e);
                        throw new CelebornIOException("Fetch chunk failed for " + this.fetchChunkRetryCnt + " times for location " + this.currentReader.getLocation(), (Throwable)e);
                    }
                    if (this.currentReader.getLocation().hasPeer() && !this.readSkewPartitionWithoutMapRange) {
                        logger.warn("Fetch chunk failed {}/{} times for location {}, change to peer", new Object[]{this.fetchChunkRetryCnt, this.fetchChunkMaxRetry, this.currentReader.getLocation(), e});
                        if (this.fetchChunkRetryCnt % 2 == 0) {
                            Uninterruptibles.sleepUninterruptibly(this.retryWaitMs, TimeUnit.MILLISECONDS);
                        }
                        this.currentReader = this.createReaderWithRetry(this.currentReader.getLocation().getPeer(), null);
                        continue;
                    }
                    logger.warn("Fetch chunk failed {}/{} times for location {}", new Object[]{this.fetchChunkRetryCnt, this.fetchChunkMaxRetry, this.currentReader.getLocation(), e});
                    Uninterruptibles.sleepUninterruptibly(this.retryWaitMs, TimeUnit.MILLISECONDS);
                    this.currentReader = this.createReaderWithRetry(this.currentReader.getLocation(), null, this.currentReader.getPartitionReaderCheckpointMetadata());
                }
            }
            throw new CelebornIOException("Fetch chunk failed! " + this.currentReader.getLocation());
        }

        private PartitionReader createReader(PartitionLocation location, PbStreamHandler pbStreamHandler, int fetchChunkRetryCnt, int fetchChunkMaxRetry, Optional<PartitionReaderCheckpointMetadata> checkpointMetadata) throws IOException, InterruptedException {
            StorageInfo storageInfo = location.getStorageInfo();
            int startChunkIndex = -1;
            int endChunkIndex = -1;
            if (this.partitionLocationToChunkRange != null) {
                Pair<Integer, Integer> chunkRange = this.partitionLocationToChunkRange.get(location.getUniqueId());
                startChunkIndex = chunkRange.getLeft();
                endChunkIndex = chunkRange.getRight();
            }
            switch (storageInfo.getType()) {
                case HDD: 
                case SSD: 
                case MEMORY: {
                    if (this.enabledReadLocalShuffle && location.getHost().equals(this.localHostAddress) && storageInfo.getType() != StorageInfo.Type.MEMORY) {
                        logger.debug("Read local shuffle file {}", (Object)this.localHostAddress);
                        this.containLocalRead = true;
                        return new LocalPartitionReader(this.conf, this.shuffleKey, location, pbStreamHandler, this.clientFactory, this.startMapIndex, this.endMapIndex, this.callback, startChunkIndex, endChunkIndex);
                    }
                    return new WorkerPartitionReader(this.conf, this.shuffleKey, location, pbStreamHandler, this.clientFactory, this.startMapIndex, this.endMapIndex, fetchChunkRetryCnt, fetchChunkMaxRetry, this.callback, startChunkIndex, endChunkIndex, checkpointMetadata);
                }
                case S3: 
                case OSS: 
                case HDFS: {
                    return new DfsPartitionReader(this.conf, this.shuffleKey, location, pbStreamHandler, this.clientFactory, this.startMapIndex, this.endMapIndex, this.callback, startChunkIndex, endChunkIndex, checkpointMetadata);
                }
            }
            throw new CelebornIOException(String.format("Unknown storage info %s to read location %s", storageInfo, location));
        }

        @Override
        public int read() throws IOException {
            if (this.position < this.limit) {
                byte b = this.rawDataBuf[this.position];
                ++this.position;
                return b & 0xFF;
            }
            if (!this.fillBuffer()) {
                return -1;
            }
            if (this.position >= this.limit) {
                return this.read();
            }
            byte b = this.rawDataBuf[this.position];
            ++this.position;
            return b & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int readBytes;
            int bytesToRead;
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            for (readBytes = 0; readBytes < len; readBytes += bytesToRead) {
                while (this.position >= this.limit) {
                    if (this.fillBuffer()) continue;
                    return readBytes > 0 ? readBytes : -1;
                }
                bytesToRead = Math.min(this.limit - this.position, len - readBytes);
                System.arraycopy(this.rawDataBuf, this.position, b, off + readBytes, bytesToRead);
                this.position += bytesToRead;
            }
            return readBytes;
        }

        @Override
        public synchronized void close() {
            if (!this.closed) {
                int locationsCount = this.locations.size();
                logger.debug("AppShuffleId {}, shuffleId {}, partitionId {}, total location count {}, read {}, skip {}", new Object[]{this.appShuffleId, this.shuffleId, this.partitionId, locationsCount, (long)locationsCount - this.skipCount.sum(), this.skipCount.sum()});
                if (this.currentChunk != null) {
                    logger.debug("Release chunk {}", (Object)this.currentChunk);
                    this.currentChunk.release();
                    this.currentChunk = null;
                }
                if (this.currentReader != null) {
                    logger.debug("Closing reader");
                    this.currentReader.close();
                    this.currentReader = null;
                }
                if (this.containLocalRead) {
                    ShuffleClient.printReadStats(logger);
                }
                this.compressedBuf = null;
                this.rawDataBuf = null;
                this.batchesRead = null;
                this.locations = null;
                this.attempts = null;
                this.decompressor = null;
                this.fetchExcludedWorkers = null;
                this.closed = true;
            }
        }

        private boolean moveToNextChunk() throws IOException {
            if (this.currentChunk != null) {
                this.currentChunk.release();
            }
            this.currentChunk = null;
            if (this.currentReader.hasNext() && (this.currentChunk = this.getNextChunk()) != null) {
                return true;
            }
            if (this.fileIndex < this.locations.size()) {
                this.moveToNextReader(true);
                return this.currentReader != null;
            }
            if (this.currentReader != null) {
                this.currentReader.close();
                this.currentReader = null;
            }
            return false;
        }

        private void init() {
            int bufferSize = this.conf.clientFetchBufferSize();
            if (this.shouldDecompress) {
                int headerLen = Decompressor.getCompressionHeaderLength(this.conf);
                this.compressedBuf = new byte[bufferSize += headerLen];
                this.decompressor = Decompressor.getDecompressor(this.conf);
            }
            this.rawDataBuf = new byte[bufferSize];
        }

        private boolean fillBuffer() throws IOException {
            try {
                if (this.firstChunk && this.currentReader != null) {
                    this.init();
                    this.currentChunk = this.getNextChunk();
                    while (this.currentChunk == null && this.moveToNextChunk()) {
                    }
                    this.firstChunk = false;
                }
                if (this.currentChunk == null) {
                    this.close();
                    return false;
                }
                LocationPushFailedBatches failedBatch = new LocationPushFailedBatches();
                boolean hasData = false;
                while (this.currentChunk.isReadable() || this.moveToNextChunk()) {
                    Set<Object> batchSet;
                    LocationPushFailedBatches locationPushFailedBatches;
                    this.currentChunk.readBytes(this.sizeBuf);
                    int mapId = Platform.getInt(this.sizeBuf, Platform.BYTE_ARRAY_OFFSET);
                    int attemptId = Platform.getInt(this.sizeBuf, Platform.BYTE_ARRAY_OFFSET + 4);
                    int batchId = Platform.getInt(this.sizeBuf, Platform.BYTE_ARRAY_OFFSET + 8);
                    int size = Platform.getInt(this.sizeBuf, Platform.BYTE_ARRAY_OFFSET + 12);
                    if (this.shouldDecompress) {
                        if (size > this.compressedBuf.length) {
                            this.compressedBuf = new byte[size];
                        }
                        this.currentChunk.readBytes(this.compressedBuf, 0, size);
                    } else {
                        if (size > this.rawDataBuf.length) {
                            this.rawDataBuf = new byte[size];
                        }
                        this.currentChunk.readBytes(this.rawDataBuf, 0, size);
                    }
                    if (attemptId != this.attempts[mapId]) continue;
                    if (this.readSkewPartitionWithoutMapRange && null != (locationPushFailedBatches = this.failedBatches.get(this.currentReader.getLocation().getUniqueId())) && locationPushFailedBatches.contains(mapId, attemptId, batchId)) {
                        logger.warn("Skip duplicated batch: mapId={}, attemptId={}, batchId={}", new Object[]{mapId, attemptId, batchId});
                        continue;
                    }
                    if (!this.batchesRead.containsKey(mapId)) {
                        batchSet = new HashSet();
                        this.batchesRead.put(mapId, batchSet);
                    }
                    if (!(batchSet = this.batchesRead.get(mapId)).contains(batchId)) {
                        batchSet.add(batchId);
                        this.callback.incBytesRead(16 + size);
                        if (this.shouldDecompress) {
                            int originalLength = this.decompressor.getOriginalLen(this.compressedBuf);
                            if (this.rawDataBuf.length < originalLength) {
                                this.rawDataBuf = new byte[originalLength];
                            }
                            this.limit = this.decompressor.decompress(this.compressedBuf, this.rawDataBuf, 0);
                        } else {
                            this.limit = size;
                        }
                        this.position = 0;
                        hasData = true;
                        break;
                    }
                    this.callback.incDuplicateBytesRead(16 + size);
                    logger.debug("Skip duplicated batch: mapId {}, attemptId {}, batchId {}.", new Object[]{mapId, attemptId, batchId});
                }
                return hasData;
            }
            catch (ZstdException | IOException | LZ4Exception e) {
                logger.error("Failed to fill buffer from chunk. AppShuffleId {}, shuffleId {}, partitionId {}, location {}", new Object[]{this.appShuffleId, this.shuffleId, this.partitionId, Optional.ofNullable(this.currentReader).map(PartitionReader::getLocation).orElse(null), e});
                IOException ioe = e instanceof IOException ? (IOException)e : new IOException(e);
                if (this.exceptionMaker != null && this.shuffleClient.reportShuffleFetchFailure(this.appShuffleId, this.shuffleId, this.taskId)) {
                    ioe = new CelebornIOException(this.exceptionMaker.makeFetchFailureException(this.appShuffleId, this.shuffleId, this.partitionId, e));
                }
                throw ioe;
            }
            catch (Exception e) {
                logger.error("Failed to fill buffer from chunk. AppShuffleId {}, shuffleId {}, partitionId {}, location {}", new Object[]{this.appShuffleId, this.shuffleId, this.partitionId, Optional.ofNullable(this.currentReader).map(PartitionReader::getLocation).orElse(null), e});
                throw e;
            }
        }

        @Override
        public int totalPartitionsToRead() {
            return this.locations.size();
        }

        @Override
        public int partitionsRead() {
            return this.fileIndex;
        }
    }
}

