/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class LongPathTest
extends AbstractTest {
    private static final ClassLoader CLASS_LOADER = LongPathTest.class.getClassLoader();
    private static final File ARC_DIR;
    private static final ArrayList<String> FILE_LIST;

    LongPathTest() {
    }

    public static Stream<Arguments> data() {
        ArrayList<Arguments> params = new ArrayList<Arguments>();
        for (String fileName : ARC_DIR.list((dir, name) -> !name.endsWith(".txt"))) {
            params.add(Arguments.of((Object[])new Object[]{new File(ARC_DIR, fileName)}));
        }
        return params.stream();
    }

    @BeforeAll
    public static void setUpFileList() throws Exception {
        Assertions.assertTrue((boolean)ARC_DIR.exists());
        File listing = new File(ARC_DIR, "files.txt");
        Assertions.assertTrue((boolean)listing.canRead(), (String)"files.txt is readable");
        try (BufferedReader br = new BufferedReader(Files.newBufferedReader(listing.toPath()));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                FILE_LIST.add(line);
            }
        }
    }

    @Override
    protected String getExpectedString(ArchiveEntry entry) {
        TarArchiveEntry tarEntry;
        if (entry instanceof TarArchiveEntry && (tarEntry = (TarArchiveEntry)entry).isSymbolicLink()) {
            return tarEntry.getName() + " -> " + tarEntry.getLinkName();
        }
        return entry.getName();
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    void testArchive(File file) throws Exception {
        ArrayList expected = (ArrayList)FILE_LIST.clone();
        String name = file.getName();
        if ("minotaur.jar".equals(name) || "minotaur-0.jar".equals(name)) {
            expected.add("META-INF/");
            expected.add("META-INF/MANIFEST.MF");
        }
        try (ArchiveInputStream ais = this.factory.createArchiveInputStream((InputStream)new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0])));){
            if (name.endsWith(".tar")) {
                Assertions.assertInstanceOf(TarArchiveInputStream.class, (Object)ais);
            } else if (name.endsWith(".jar") || name.endsWith(".zip")) {
                Assertions.assertInstanceOf(ZipArchiveInputStream.class, (Object)ais);
            } else if (name.endsWith(".cpio")) {
                Assertions.assertInstanceOf(CpioArchiveInputStream.class, (Object)ais);
                for (int i = 0; i < expected.size(); ++i) {
                    String ent = (String)expected.get(i);
                    if (!ent.endsWith("/")) continue;
                    expected.set(i, ent.substring(0, ent.length() - 1));
                }
            } else if (name.endsWith(".ar")) {
                Assertions.assertInstanceOf(ArArchiveInputStream.class, (Object)ais);
                expected.clear();
                for (String ent : FILE_LIST) {
                    if (ent.endsWith("/")) continue;
                    int lastSlash = ent.lastIndexOf(47);
                    if (lastSlash >= 0) {
                        expected.add(ent.substring(lastSlash + 1));
                        continue;
                    }
                    expected.add(ent);
                }
            } else {
                Assertions.fail((String)("Unexpected file type: " + name));
            }
            Assertions.assertDoesNotThrow(() -> this.checkArchiveContent(ais, (List<String>)expected), (String)("Error processing " + file.getName()));
        }
    }

    static {
        FILE_LIST = new ArrayList();
        try {
            ARC_DIR = new File(CLASS_LOADER.getResource("longpath").toURI());
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }
}

