/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationUtils;
import org.apache.commons.configuration2.DatabaseConfiguration;
import org.apache.commons.configuration2.DatabaseConfigurationTestHelper;
import org.apache.commons.configuration2.builder.fluent.DatabaseBuilderParameters;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.event.ConfigurationErrorEvent;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.ErrorListenerTestImpl;
import org.apache.commons.configuration2.event.EventType;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestDatabaseConfiguration {
    private static final String CONFIG_NAME2 = "anotherTestConfig";
    private ErrorListenerTestImpl listener;
    private DatabaseConfigurationTestHelper helper;

    private void checkErrorListener(EventType<? extends ConfigurationErrorEvent> type, EventType<?> opType, String key, Object value) {
        Throwable exception = this.listener.checkEvent(type, opType, key, value);
        Assertions.assertInstanceOf(SQLException.class, (Object)exception);
        this.listener = null;
    }

    @Test
    void containsValueInternal() throws ConfigurationException {
        DatabaseConfiguration config = this.helper.setUpConfig();
        config.addPropertyDirect("test", (Object)"test1");
        Assertions.assertTrue((boolean)config.containsValueInternal((Object)"test1"));
        Assertions.assertFalse((boolean)config.containsValue((Object)"test9999"));
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.helper = new DatabaseConfigurationTestHelper();
        this.helper.setUp();
    }

    private PotentialErrorDatabaseConfiguration setUpConfig() throws ConfigurationException {
        return this.helper.setUpConfig(PotentialErrorDatabaseConfiguration.class);
    }

    private PotentialErrorDatabaseConfiguration setUpErrorConfig() throws ConfigurationException {
        PotentialErrorDatabaseConfiguration config = this.setUpConfig();
        this.setUpErrorListener(config);
        return config;
    }

    private void setUpErrorListener(PotentialErrorDatabaseConfiguration config) {
        config.clearErrorListeners();
        this.listener = new ErrorListenerTestImpl((Object)config);
        config.addEventListener(ConfigurationErrorEvent.ANY, this.listener);
        config.failOnConnect = true;
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.listener != null) {
            this.listener.done();
        }
        this.helper.tearDown();
    }

    @Test
    void testAddNonStringProperty() throws ConfigurationException {
        DatabaseConfiguration config = this.helper.setUpConfig();
        config.addPropertyDirect("boolean", (Object)Boolean.TRUE);
        Assertions.assertTrue((boolean)config.containsKey("boolean"));
    }

    @Test
    void testAddPropertyDirectCommit() throws ConfigurationException {
        this.helper.setAutoCommit(false);
        DatabaseConfiguration config = this.helper.setUpConfig();
        config.addPropertyDirect("key", (Object)"value");
        Assertions.assertTrue((boolean)config.containsKey("key"));
    }

    @Test
    void testAddPropertyDirectMultiple() throws ConfigurationException {
        DatabaseConfiguration config = this.helper.setUpMultiConfig();
        config.addPropertyDirect("key", (Object)"value");
        Assertions.assertTrue((boolean)config.containsKey("key"));
    }

    @Test
    void testAddPropertyDirectSingle() throws ConfigurationException {
        DatabaseConfiguration config = this.helper.setUpConfig();
        config.addPropertyDirect("key", (Object)"value");
        Assertions.assertTrue((boolean)config.containsKey("key"));
    }

    @Test
    void testAddPropertyError() throws ConfigurationException {
        this.setUpErrorConfig().addProperty("key1", "value");
        this.checkErrorListener((EventType<? extends ConfigurationErrorEvent>)ConfigurationErrorEvent.WRITE, ConfigurationEvent.ADD_PROPERTY, "key1", "value");
    }

    @Test
    void testAddWithDelimiter() throws ConfigurationException {
        PotentialErrorDatabaseConfiguration config = this.setUpConfig();
        config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(';'));
        config.addProperty("keyList", "1;2;3");
        Object[] values = config.getStringArray("keyList");
        Assertions.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])values);
    }

    @Test
    void testClearCommit() throws ConfigurationException {
        this.helper.setAutoCommit(false);
        DatabaseConfiguration config = this.helper.setUpConfig();
        config.clear();
        Assertions.assertTrue((boolean)config.isEmpty());
    }

    @Test
    void testClearError() throws ConfigurationException {
        this.setUpErrorConfig().clear();
        this.checkErrorListener((EventType<? extends ConfigurationErrorEvent>)ConfigurationErrorEvent.WRITE, ConfigurationEvent.CLEAR, null, null);
    }

    @Test
    void testClearMultiple() throws ConfigurationException {
        DatabaseConfiguration config = this.helper.setUpMultiConfig();
        config.clear();
        Assertions.assertTrue((boolean)config.isEmpty());
    }

    @Test
    void testClearPropertyCommit() throws ConfigurationException {
        this.helper.setAutoCommit(false);
        DatabaseConfiguration config = this.helper.setUpConfig();
        config.clearProperty("key1");
        Assertions.assertFalse((boolean)config.containsKey("key1"));
    }

    @Test
    void testClearPropertyError() throws ConfigurationException {
        this.setUpErrorConfig().clearProperty("key1");
        this.checkErrorListener((EventType<? extends ConfigurationErrorEvent>)ConfigurationErrorEvent.WRITE, ConfigurationEvent.CLEAR_PROPERTY, "key1", null);
    }

    @Test
    void testClearPropertyMultiple() throws ConfigurationException {
        DatabaseConfiguration config = this.helper.setUpMultiConfig();
        config.clearProperty("key1");
        Assertions.assertFalse((boolean)config.containsKey("key1"));
    }

    @Test
    void testClearPropertyMultipleOtherConfig() throws ConfigurationException {
        DatabaseConfiguration config = this.helper.setUpMultiConfig();
        DatabaseConfiguration config2 = this.helper.setUpMultiConfig(DatabaseConfiguration.class, CONFIG_NAME2);
        config2.addProperty("key1", (Object)"some test");
        config.clearProperty("key1");
        Assertions.assertFalse((boolean)config.containsKey("key1"));
        Assertions.assertTrue((boolean)config2.containsKey("key1"));
    }

    @Test
    void testClearPropertySingle() throws ConfigurationException {
        DatabaseConfiguration config = this.helper.setUpConfig();
        config.clearProperty("key1");
        Assertions.assertFalse((boolean)config.containsKey("key1"));
    }

    @Test
    void testClearSingle() throws ConfigurationException {
        DatabaseConfiguration config = this.helper.setUpConfig();
        config.clear();
        Assertions.assertTrue((boolean)config.isEmpty());
    }

    @Test
    void testClearSubset() throws ConfigurationException {
        PotentialErrorDatabaseConfiguration config = this.setUpConfig();
        Configuration subset = config.subset("key1");
        subset.clear();
        Assertions.assertTrue((boolean)subset.isEmpty());
        Assertions.assertFalse((boolean)config.isEmpty());
    }

    @Test
    void testContainsKeyError() throws ConfigurationException {
        Assertions.assertFalse((boolean)this.setUpErrorConfig().containsKey("key1"));
        this.checkErrorListener((EventType<? extends ConfigurationErrorEvent>)ConfigurationErrorEvent.READ, ConfigurationErrorEvent.READ, "key1", null);
    }

    @Test
    void testContainsKeyMultiple() throws ConfigurationException {
        DatabaseConfiguration config = this.helper.setUpMultiConfig();
        Assertions.assertTrue((boolean)config.containsKey("key1"));
        Assertions.assertTrue((boolean)config.containsKey("key2"));
    }

    @Test
    void testContainsKeySingle() throws ConfigurationException {
        PotentialErrorDatabaseConfiguration config = this.setUpConfig();
        Assertions.assertTrue((boolean)config.containsKey("key1"));
        Assertions.assertTrue((boolean)config.containsKey("key2"));
    }

    @Test
    void testContainsValue() throws ConfigurationException {
        DatabaseConfiguration config = this.helper.setUpConfig();
        config.addPropertyDirect("test", (Object)"test1");
        Assertions.assertTrue((boolean)config.containsValue((Object)"test1"));
        Assertions.assertFalse((boolean)config.containsValue((Object)"test9999"));
    }

    @Test
    void testExtractPropertyValueCLOB() throws ConfigurationException, SQLException {
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Clob clob = (Clob)Mockito.mock(Clob.class);
        String content = "This is the content of the test CLOB!";
        Mockito.when((Object)rs.getObject("value")).thenReturn((Object)clob);
        Mockito.when((Object)clob.length()).thenReturn((Object)"This is the content of the test CLOB!".length());
        Mockito.when((Object)clob.getSubString(1L, "This is the content of the test CLOB!".length())).thenReturn((Object)"This is the content of the test CLOB!");
        DatabaseConfiguration config = this.helper.setUpConfig();
        Assertions.assertEquals((Object)"This is the content of the test CLOB!", (Object)config.extractPropertyValue(rs));
        ((ResultSet)Mockito.verify((Object)rs)).getObject("value");
        ((Clob)Mockito.verify((Object)clob)).length();
        ((Clob)Mockito.verify((Object)clob)).getSubString(1L, "This is the content of the test CLOB!".length());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{rs, clob});
    }

    @Test
    void testExtractPropertyValueCLOBEmpty() throws ConfigurationException, SQLException {
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Clob clob = (Clob)Mockito.mock(Clob.class);
        Mockito.when((Object)rs.getObject("value")).thenReturn((Object)clob);
        Mockito.when((Object)clob.length()).thenReturn((Object)0L);
        DatabaseConfiguration config = this.helper.setUpConfig();
        Assertions.assertEquals((Object)"", (Object)config.extractPropertyValue(rs));
        ((ResultSet)Mockito.verify((Object)rs)).getObject("value");
        ((Clob)Mockito.verify((Object)clob)).length();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{rs, clob});
    }

    @Test
    void testGetKeys() throws ConfigurationException {
        DatabaseBuilderParameters params = (DatabaseBuilderParameters)this.helper.setUpDefaultParameters().setTable("configurationList");
        DatabaseConfiguration config1 = this.helper.createConfiguration(DatabaseConfiguration.class, params);
        Iterator i = config1.getKeys();
        Assertions.assertTrue((boolean)i.hasNext());
        Object key = i.next();
        Assertions.assertEquals((Object)"key3", (Object)key.toString());
        Assertions.assertFalse((boolean)i.hasNext());
    }

    @Test
    void testGetKeysError() throws ConfigurationException {
        Iterator it = this.setUpErrorConfig().getKeys();
        this.checkErrorListener((EventType<? extends ConfigurationErrorEvent>)ConfigurationErrorEvent.READ, ConfigurationErrorEvent.READ, null, null);
        Assertions.assertFalse((boolean)it.hasNext());
    }

    @Test
    void testGetKeysInternalNoDatasource() throws Exception {
        ConfigurationUtils.toString((Configuration)new DatabaseConfiguration());
    }

    @Test
    void testGetKeysMultiple() throws ConfigurationException {
        DatabaseConfiguration config = this.helper.setUpMultiConfig();
        Iterator it = config.getKeys();
        Assertions.assertEquals((Object)"key1", it.next());
        Assertions.assertEquals((Object)"key2", it.next());
    }

    @Test
    void testGetKeysSingle() throws ConfigurationException {
        PotentialErrorDatabaseConfiguration config = this.setUpConfig();
        Iterator it = config.getKeys();
        Assertions.assertEquals((Object)"key1", it.next());
        Assertions.assertEquals((Object)"key2", it.next());
    }

    @Test
    void testGetList() throws ConfigurationException {
        DatabaseBuilderParameters params = (DatabaseBuilderParameters)this.helper.setUpDefaultParameters().setTable("configurationList");
        DatabaseConfiguration config1 = this.helper.createConfiguration(DatabaseConfiguration.class, params);
        List list = config1.getList("key3");
        Assertions.assertEquals((int)3, (int)list.size());
    }

    @Test
    void testGetListWithDelimiter() throws ConfigurationException {
        PotentialErrorDatabaseConfiguration config = this.setUpConfig();
        config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(';'));
        List values = config.getList("keyMulti");
        Assertions.assertEquals(Arrays.asList("a", "b", "c"), (Object)values);
    }

    @Test
    void testGetListWithDelimiterParsingDisabled() throws ConfigurationException {
        PotentialErrorDatabaseConfiguration config = this.setUpConfig();
        Assertions.assertEquals((Object)"a;b;c", (Object)config.getString("keyMulti"));
    }

    @Test
    void testGetPropertyDirectMultiple() throws ConfigurationException {
        DatabaseConfiguration config = this.helper.setUpMultiConfig();
        Assertions.assertEquals((Object)"value1", (Object)config.getProperty("key1"));
        Assertions.assertEquals((Object)"value2", (Object)config.getProperty("key2"));
        Assertions.assertNull((Object)config.getProperty("key3"));
    }

    @Test
    void testGetPropertyDirectSingle() throws ConfigurationException {
        PotentialErrorDatabaseConfiguration config = this.setUpConfig();
        Assertions.assertEquals((Object)"value1", (Object)config.getProperty("key1"));
        Assertions.assertEquals((Object)"value2", (Object)config.getProperty("key2"));
        Assertions.assertNull((Object)config.getProperty("key3"));
    }

    @Test
    void testGetPropertyError() throws ConfigurationException {
        this.setUpErrorConfig().getProperty("key1");
        this.checkErrorListener((EventType<? extends ConfigurationErrorEvent>)ConfigurationErrorEvent.READ, ConfigurationErrorEvent.READ, "key1", null);
    }

    @Test
    void testIsEmptyError() throws ConfigurationException {
        Assertions.assertTrue((boolean)this.setUpErrorConfig().isEmpty());
        this.checkErrorListener((EventType<? extends ConfigurationErrorEvent>)ConfigurationErrorEvent.READ, ConfigurationErrorEvent.READ, null, null);
    }

    @Test
    void testIsEmptyMultiple() throws ConfigurationException {
        DatabaseConfiguration config1 = this.helper.setUpMultiConfig();
        Assertions.assertFalse((boolean)config1.isEmpty());
        DatabaseConfiguration config2 = this.helper.setUpMultiConfig(DatabaseConfiguration.class, "testIsEmpty");
        Assertions.assertTrue((boolean)config2.isEmpty());
    }

    @Test
    void testIsEmptySingle() throws ConfigurationException {
        PotentialErrorDatabaseConfiguration config1 = this.setUpConfig();
        Assertions.assertFalse((boolean)config1.isEmpty());
    }

    @Test
    void testLogErrorListener() throws ConfigurationException {
        DatabaseConfiguration config = this.helper.setUpConfig();
        Assertions.assertEquals((int)1, (int)config.getEventListeners(ConfigurationErrorEvent.ANY).size());
    }

    @Test
    void testSetPropertyWithDelimiter() throws ConfigurationException {
        DatabaseConfiguration config = this.helper.setUpMultiConfig();
        config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(';'));
        config.setProperty("keyList", (Object)"1;2;3");
        Object[] values = config.getStringArray("keyList");
        Assertions.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])values);
    }

    public static class PotentialErrorDatabaseConfiguration
    extends DatabaseConfiguration {
        private boolean failOnConnect;

        public DataSource getDatasource() {
            return this.getDS();
        }

        public DataSource getDataSource() {
            return this.getDS();
        }

        private DataSource getDS() {
            if (this.failOnConnect) {
                DataSource ds = (DataSource)Mockito.mock(DataSource.class);
                Assertions.assertDoesNotThrow(() -> Mockito.when((Object)ds.getConnection()).thenThrow(new Throwable[]{new SQLException("Simulated DB error")}));
                return ds;
            }
            return super.getDataSource();
        }
    }
}

