/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.managed;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Properties;
import javax.transaction.TransactionManager;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.TesterDriver;
import org.apache.commons.dbcp2.managed.LocalXAConnectionFactory;
import org.apache.commons.dbcp2.managed.PoolableManagedConnection;
import org.apache.commons.dbcp2.managed.TransactionRegistry;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestPoolableManagedConnection {
    private TransactionManager transactionManager;
    private TransactionRegistry transactionRegistry;
    private GenericObjectPool<PoolableConnection> pool;
    private Connection conn;
    private PoolableManagedConnection poolableManagedConnection;

    @BeforeEach
    public void setUp() throws Exception {
        this.transactionManager = new TransactionManagerImpl();
        Properties properties = new Properties();
        properties.setProperty("user", "userName");
        properties.setProperty("password", "password");
        DriverConnectionFactory connectionFactory = new DriverConnectionFactory((Driver)new TesterDriver(), "jdbc:apache:commons:testdriver", properties);
        LocalXAConnectionFactory xaConnectionFactory = new LocalXAConnectionFactory(this.transactionManager, (ConnectionFactory)connectionFactory);
        this.transactionRegistry = xaConnectionFactory.getTransactionRegistry();
        PoolableConnectionFactory factory = new PoolableConnectionFactory((ConnectionFactory)xaConnectionFactory, null);
        factory.setValidationQuery("SELECT DUMMY FROM DUAL");
        factory.setDefaultReadOnly(Boolean.TRUE);
        factory.setDefaultAutoCommit(Boolean.TRUE);
        this.pool = new GenericObjectPool((PooledObjectFactory)factory);
        factory.setPool(this.pool);
        this.pool.setMaxTotal(10);
        this.pool.setMaxWait(Duration.ofMillis(100L));
    }

    @AfterEach
    public void tearDown() throws SQLException {
        if (this.conn != null && !this.conn.isClosed()) {
            this.conn.close();
        }
        if (this.pool != null && !this.pool.isClosed()) {
            this.pool.close();
        }
    }

    @Test
    void testManagedConnection() throws Exception {
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive());
        this.conn = (Connection)this.pool.borrowObject();
        Assertions.assertEquals((int)1, (int)this.pool.getNumActive());
        this.poolableManagedConnection = new PoolableManagedConnection(this.transactionRegistry, this.conn, this.pool);
        this.poolableManagedConnection.close();
        Assertions.assertEquals((int)1, (int)this.pool.getNumActive());
        this.conn.close();
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive());
    }

    @Test
    void testPoolableConnection() throws Exception {
        this.conn = (Connection)this.pool.borrowObject();
        Assertions.assertNotNull((Object)this.transactionRegistry.getXAResource(this.conn));
        this.poolableManagedConnection = new PoolableManagedConnection(this.transactionRegistry, this.conn, this.pool);
        this.poolableManagedConnection.close();
        Assertions.assertNotNull((Object)this.transactionRegistry.getXAResource(this.conn));
    }

    @Test
    void testReallyClose() throws Exception {
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive());
        this.conn = (Connection)this.pool.borrowObject();
        Assertions.assertEquals((int)1, (int)this.pool.getNumActive());
        Assertions.assertNotNull((Object)this.transactionRegistry.getXAResource(this.conn));
        this.poolableManagedConnection = new PoolableManagedConnection(this.transactionRegistry, this.conn, this.pool);
        this.poolableManagedConnection.close();
        Assertions.assertNotNull((Object)this.transactionRegistry.getXAResource(this.conn));
        Assertions.assertEquals((int)1, (int)this.pool.getNumActive());
        this.poolableManagedConnection.reallyClose();
        Assertions.assertThrows(SQLException.class, () -> this.transactionRegistry.getXAResource(this.conn), (String)"Transaction registry was supposed to be empty now");
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive());
    }
}

