/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.TempFile;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class FileUtilsCopyDirectoryToDirectoryTest {
    @TempDir
    public File temporaryFolder;

    FileUtilsCopyDirectoryToDirectoryTest() {
    }

    private static void assertExceptionTypeAndMessage(File srcDir, File destDir, Class<? extends Exception> expectedExceptionType, String expectedMessage) {
        try {
            FileUtils.copyDirectoryToDirectory((File)srcDir, (File)destDir);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            Assertions.assertEquals(expectedExceptionType, e.getClass());
            Assertions.assertEquals((Object)expectedMessage, (Object)msg);
            return;
        }
        Assertions.fail();
    }

    private void assertAclEntryList(Path sourcePath, Path destPath) throws IOException {
        Assertions.assertEquals((Object)PathUtils.getAclEntryList((Path)sourcePath), (Object)PathUtils.getAclEntryList((Path)destPath));
    }

    @Test
    void testCopyDirectoryToDirectoryThrowsIllegalArgumentExceptionWithCorrectMessageWhenDstDirIsNotDirectory() throws IOException {
        File srcDir = new File(this.temporaryFolder, "sourceDirectory");
        srcDir.mkdir();
        File destDir = new File(this.temporaryFolder, "notadirectory");
        destDir.createNewFile();
        String expectedMessage = String.format("Parameter 'destinationDir' is not a directory: '%s'", destDir);
        FileUtilsCopyDirectoryToDirectoryTest.assertExceptionTypeAndMessage(srcDir, destDir, IllegalArgumentException.class, expectedMessage);
    }

    @Test
    void testCopyDirectoryToDirectoryThrowsIllegalExceptionWithCorrectMessageWhenSrcDirIsNotDirectory() throws IOException {
        try (TempFile srcDir = TempFile.create("notadirectory", null, new FileAttribute[0]);){
            File destDir = new File(this.temporaryFolder, "destinationDirectory");
            destDir.mkdirs();
            String expectedMessage = String.format("Parameter 'srcDir' is not a directory: '%s'", srcDir);
            FileUtilsCopyDirectoryToDirectoryTest.assertExceptionTypeAndMessage(srcDir.toFile(), destDir, IllegalArgumentException.class, expectedMessage);
        }
    }

    @Test
    void testCopyDirectoryToDirectoryThrowsNullPointerExceptionWithCorrectMessageWhenDstDirIsNull() {
        File srcDir = new File(this.temporaryFolder, "sourceDirectory");
        srcDir.mkdir();
        File destDir = null;
        FileUtilsCopyDirectoryToDirectoryTest.assertExceptionTypeAndMessage(srcDir, destDir, NullPointerException.class, "destinationDir");
    }

    @Test
    void testCopyDirectoryToDirectoryThrowsNullPointerExceptionWithCorrectMessageWhenSrcDirIsNull() {
        File srcDir = null;
        File destinationDirectory = new File(this.temporaryFolder, "destinationDirectory");
        destinationDirectory.mkdir();
        FileUtilsCopyDirectoryToDirectoryTest.assertExceptionTypeAndMessage(srcDir, destinationDirectory, NullPointerException.class, "sourceDir");
    }

    @Test
    void testCopyFileAndCheckAcl() throws IOException {
        try (TempFile sourcePath = TempFile.create("TempOutput", ".bin", new FileAttribute[0]);){
            Path destPath = Paths.get(this.temporaryFolder.getAbsolutePath(), "SomeFile.bin");
            FileUtils.copyFile((File)sourcePath.toFile(), (File)destPath.toFile(), (boolean)true, (CopyOption[])new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES});
            this.assertAclEntryList(sourcePath.get(), destPath);
            FileUtils.copyFile((File)sourcePath.toFile(), (File)destPath.toFile());
            this.assertAclEntryList(sourcePath.get(), destPath);
            FileUtils.copyFile((File)sourcePath.toFile(), (File)destPath.toFile(), (boolean)true, (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
            this.assertAclEntryList(sourcePath.get(), destPath);
            FileUtils.copyFile((File)sourcePath.toFile(), (File)destPath.toFile(), (boolean)true, (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES});
            this.assertAclEntryList(sourcePath.get(), destPath);
        }
    }
}

