/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.ArrayFill;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.function.FailableIntFunction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ArrayFillTest
extends AbstractLangTest {
    ArrayFillTest() {
    }

    @Test
    void testFillBooleanArray() {
        boolean[] array = new boolean[3];
        boolean val = true;
        boolean[] actual = ArrayFill.fill((boolean[])array, (boolean)true);
        Assertions.assertSame((Object)array, (Object)actual);
        for (boolean v : actual) {
            Assertions.assertEquals((Object)true, (Object)v);
        }
    }

    @Test
    void testFillBooleanArrayNull() {
        boolean[] array = null;
        boolean val = true;
        boolean[] actual = ArrayFill.fill(array, (boolean)true);
        Assertions.assertSame(array, (Object)actual);
    }

    @Test
    void testFillByteArray() {
        byte[] array = new byte[3];
        boolean val = true;
        byte[] actual = ArrayFill.fill((byte[])array, (byte)1);
        Assertions.assertSame((Object)array, (Object)actual);
        for (byte v : actual) {
            Assertions.assertEquals((byte)1, (byte)v);
        }
    }

    @Test
    void testFillByteArrayNull() {
        byte[] array = null;
        boolean val = true;
        byte[] actual = ArrayFill.fill(array, (byte)1);
        Assertions.assertSame(array, (Object)actual);
    }

    @Test
    void testFillCharArray() {
        char[] array = new char[3];
        boolean val = true;
        char[] actual = ArrayFill.fill((char[])array, (char)'\u0001');
        Assertions.assertSame((Object)array, (Object)actual);
        for (char v : actual) {
            Assertions.assertEquals((char)'\u0001', (char)v);
        }
    }

    @Test
    void testFillCharArrayNull() {
        char[] array = null;
        boolean val = true;
        char[] actual = ArrayFill.fill(array, (char)'\u0001');
        Assertions.assertSame(array, (Object)actual);
    }

    @Test
    void testFillDoubleArray() {
        double[] array = new double[3];
        double val = 1.0;
        double[] actual = ArrayFill.fill((double[])array, (double)1.0);
        Assertions.assertSame((Object)array, (Object)actual);
        for (double v : actual) {
            Assertions.assertEquals((double)1.0, (double)v);
        }
    }

    @Test
    void testFillDoubleArrayNull() {
        double[] array = null;
        double val = 1.0;
        double[] actual = ArrayFill.fill(array, (double)1.0);
        Assertions.assertSame(array, (Object)actual);
    }

    @Test
    void testFillFloatArray() {
        float[] array = new float[3];
        float val = 1.0f;
        float[] actual = ArrayFill.fill((float[])array, (float)1.0f);
        Assertions.assertSame((Object)array, (Object)actual);
        for (float v : actual) {
            Assertions.assertEquals((float)1.0f, (float)v);
        }
    }

    @Test
    void testFillFloatArrayNull() {
        float[] array = null;
        float val = 1.0f;
        float[] actual = ArrayFill.fill(array, (float)1.0f);
        Assertions.assertSame(array, (Object)actual);
    }

    @Test
    void testFillFunction() throws Exception {
        FailableIntFunction nullIntFunction = null;
        Assertions.assertNull((Object)ArrayFill.fill(null, nullIntFunction));
        Assertions.assertArrayEquals(null, (Object[])ArrayFill.fill(null, nullIntFunction));
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_BOOLEAN_OBJECT_ARRAY, (Object[])ArrayFill.fill((Object[])ArrayUtils.EMPTY_BOOLEAN_OBJECT_ARRAY, nullIntFunction));
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])ArrayFill.fill((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, nullIntFunction));
        Object[] array = new Integer[10];
        Integer[] array2 = (Integer[])ArrayFill.fill((Object[])array, Integer::valueOf);
        Assertions.assertSame((Object)array, (Object)array2);
        for (int i = 0; i < array.length; ++i) {
            Assertions.assertEquals((int)i, (int)((Integer)array[i]));
        }
    }

    @Test
    void testFillIntArray() {
        int[] array = new int[3];
        boolean val = true;
        int[] actual = ArrayFill.fill((int[])array, (int)1);
        Assertions.assertSame((Object)array, (Object)actual);
        for (int v : actual) {
            Assertions.assertEquals((int)1, (int)v);
        }
    }

    @Test
    void testFillIntArrayNull() {
        int[] array = null;
        boolean val = true;
        int[] actual = ArrayFill.fill(array, (int)1);
        Assertions.assertSame(array, (Object)actual);
    }

    @Test
    void testFillLongArray() {
        long[] array = new long[3];
        long val = 1L;
        long[] actual = ArrayFill.fill((long[])array, (long)1L);
        Assertions.assertSame((Object)array, (Object)actual);
        for (long v : actual) {
            Assertions.assertEquals((long)1L, (long)v);
        }
    }

    @Test
    void testFillLongArrayNull() {
        long[] array = null;
        long val = 1L;
        long[] actual = ArrayFill.fill(array, (long)1L);
        Assertions.assertSame(array, (Object)actual);
    }

    @Test
    void testFillObjectArray() {
        Object[] array = new String[3];
        String val = "A";
        String[] actual = (String[])ArrayFill.fill((Object[])array, (Object)"A");
        Assertions.assertSame((Object)array, (Object)actual);
        for (String v : actual) {
            Assertions.assertEquals((Object)"A", (Object)v);
        }
    }

    @Test
    void testFillObjectArrayNull() {
        Object[] array = null;
        Integer val = 1;
        Object[] actual = ArrayFill.fill(array, (Object)val);
        Assertions.assertSame(array, (Object)actual);
    }

    @Test
    void testFillShortArray() {
        short[] array = new short[3];
        boolean val = true;
        short[] actual = ArrayFill.fill((short[])array, (short)1);
        Assertions.assertSame((Object)array, (Object)actual);
        for (short v : actual) {
            Assertions.assertEquals((short)1, (short)v);
        }
    }

    @Test
    void testFillShortArrayNull() {
        short[] array = null;
        boolean val = true;
        short[] actual = ArrayFill.fill(array, (short)1);
        Assertions.assertSame(array, (Object)actual);
    }
}

