/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ToStringBuilderTest
extends AbstractLangTest {
    private static final int ARRAYLIST_INITIAL_CAPACITY = 10;
    private final Integer base = 5;
    private final String baseStr = this.base.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this.base));

    ToStringBuilderTest() {
    }

    public void assertReflectionArray(String expected, Object actual) {
        if (actual == null) {
            return;
        }
        Assertions.assertEquals((Object)expected, (Object)ToStringBuilder.reflectionToString((Object)actual));
        Assertions.assertEquals((Object)expected, (Object)ToStringBuilder.reflectionToString((Object)actual, null));
        Assertions.assertEquals((Object)expected, (Object)ToStringBuilder.reflectionToString((Object)actual, null, (boolean)true));
        Assertions.assertEquals((Object)expected, (Object)ToStringBuilder.reflectionToString((Object)actual, null, (boolean)false));
    }

    @Test
    void test_setUpToClass_invalid() {
        Integer val = 5;
        ReflectionToStringBuilder test = new ReflectionToStringBuilder((Object)val);
        LangAssertions.assertIllegalArgumentException(() -> test.setUpToClass(String.class));
        test.toString();
    }

    @Test
    void test_setUpToClass_valid() {
        Integer val = 5;
        ReflectionToStringBuilder test = new ReflectionToStringBuilder((Object)val);
        test.setUpToClass(Number.class);
        test.toString();
    }

    @Test
    void testAppendAsObjectToString() {
        String objectToAppend1 = "";
        Boolean objectToAppend2 = Boolean.TRUE;
        Object objectToAppend3 = new Object();
        Assertions.assertEquals((Object)(this.baseStr + "[" + this.toBaseString("") + "]"), (Object)new ToStringBuilder((Object)this.base).appendAsObjectToString((Object)"").toString());
        Assertions.assertEquals((Object)(this.baseStr + "[" + this.toBaseString(objectToAppend2) + "]"), (Object)new ToStringBuilder((Object)this.base).appendAsObjectToString((Object)objectToAppend2).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[" + this.toBaseString(objectToAppend3) + "]"), (Object)new ToStringBuilder((Object)this.base).appendAsObjectToString(objectToAppend3).toString());
    }

    @Test
    void testAppendAsObjectToStringNullPointerException() {
        ToStringBuilder builder = new ToStringBuilder((Object)1);
        LangAssertions.assertNullPointerException(() -> builder.appendAsObjectToString(null));
        builder.toString();
    }

    @Test
    void testAppendBooleanArrayWithFieldName() {
        boolean[] array = new boolean[]{true, false, false};
        Assertions.assertEquals((Object)(this.baseStr + "[flags={true,false,false}]"), (Object)new ToStringBuilder((Object)this.base).append("flags", array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[flags=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("flags", (boolean[])null).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{true,false,false}]"), (Object)new ToStringBuilder((Object)this.base).append(null, array).toString());
    }

    @Test
    void testAppendBooleanArrayWithFieldNameAndFullDetail() {
        boolean[] array = new boolean[]{true, false, false};
        Assertions.assertEquals((Object)(this.baseStr + "[flags={true,false,false}]"), (Object)new ToStringBuilder((Object)this.base).append("flags", array, true).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[length=<size=3>]"), (Object)new ToStringBuilder((Object)this.base).append("length", array, false).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[flags=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("flags", (boolean[])null, true).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null, false).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<size=3>]"), (Object)new ToStringBuilder((Object)this.base).append(null, array, false).toString());
    }

    @Test
    void testAppendByteArrayWithFieldName() {
        byte[] array = new byte[]{1, 2, -3, 4};
        Assertions.assertEquals((Object)(this.baseStr + "[values={1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append("values", array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[values=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("values", (boolean[])null).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append(null, array).toString());
    }

    @Test
    void testAppendByteArrayWithFieldNameAndFullDetail() {
        byte[] array = new byte[]{1, 2, -3, 4};
        Assertions.assertEquals((Object)(this.baseStr + "[values={1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append("values", array, true).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[length=<size=4>]"), (Object)new ToStringBuilder((Object)this.base).append("length", array, false).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[values=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("values", (boolean[])null, true).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null, false).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<size=4>]"), (Object)new ToStringBuilder((Object)this.base).append(null, array, false).toString());
    }

    @Test
    void testAppendCharArrayWithFieldName() {
        char[] array = new char[]{'A', '2', '_', 'D'};
        Assertions.assertEquals((Object)(this.baseStr + "[chars={A,2,_,D}]"), (Object)new ToStringBuilder((Object)this.base).append("chars", array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[letters={A,2,_,D}]"), (Object)new ToStringBuilder((Object)this.base).append("letters", array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[flags=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("flags", (boolean[])null).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{A,2,_,D}]"), (Object)new ToStringBuilder((Object)this.base).append(null, array).toString());
    }

    @Test
    void testAppendCharArrayWithFieldNameAndFullDetail() {
        char[] array = new char[]{'A', '2', '_', 'D'};
        Assertions.assertEquals((Object)(this.baseStr + "[chars={A,2,_,D}]"), (Object)new ToStringBuilder((Object)this.base).append("chars", array, true).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[letters=<size=4>]"), (Object)new ToStringBuilder((Object)this.base).append("letters", array, false).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[flags=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("flags", (boolean[])null, true).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null, false).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<size=4>]"), (Object)new ToStringBuilder((Object)this.base).append(null, array, false).toString());
    }

    @Test
    void testAppendDoubleArrayWithFieldName() {
        double[] array = new double[]{1.0, 2.9876, -3.00001, 4.3};
        Assertions.assertEquals((Object)(this.baseStr + "[values={1.0,2.9876,-3.00001,4.3}]"), (Object)new ToStringBuilder((Object)this.base).append("values", array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[values=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("values", (boolean[])null).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{1.0,2.9876,-3.00001,4.3}]"), (Object)new ToStringBuilder((Object)this.base).append(null, array).toString());
    }

    @Test
    void testAppendDoubleArrayWithFieldNameAndFullDetail() {
        double[] array = new double[]{1.0, 2.9876, -3.00001, 4.3};
        Assertions.assertEquals((Object)(this.baseStr + "[values={1.0,2.9876,-3.00001,4.3}]"), (Object)new ToStringBuilder((Object)this.base).append("values", array, true).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[length=<size=4>]"), (Object)new ToStringBuilder((Object)this.base).append("length", array, false).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[values=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("values", (boolean[])null, true).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null, false).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<size=4>]"), (Object)new ToStringBuilder((Object)this.base).append(null, array, false).toString());
    }

    @Test
    void testAppendFloatArrayWithFieldName() {
        float[] array = new float[]{1.0f, 2.9876f, -3.00001f, 4.3f};
        Assertions.assertEquals((Object)(this.baseStr + "[values={1.0,2.9876,-3.00001,4.3}]"), (Object)new ToStringBuilder((Object)this.base).append("values", array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[values=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("values", (boolean[])null).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{1.0,2.9876,-3.00001,4.3}]"), (Object)new ToStringBuilder((Object)this.base).append(null, array).toString());
    }

    @Test
    void testAppendFloatArrayWithFieldNameAndFullDetail() {
        float[] array = new float[]{1.0f, 2.9876f, -3.00001f, 4.3f};
        Assertions.assertEquals((Object)(this.baseStr + "[values={1.0,2.9876,-3.00001,4.3}]"), (Object)new ToStringBuilder((Object)this.base).append("values", array, true).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[length=<size=4>]"), (Object)new ToStringBuilder((Object)this.base).append("length", array, false).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[values=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("values", (boolean[])null, true).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null, false).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<size=4>]"), (Object)new ToStringBuilder((Object)this.base).append(null, array, false).toString());
    }

    @Test
    void testAppendIntArrayWithFieldName() {
        int[] array = new int[]{1, 2, -3, 4};
        Assertions.assertEquals((Object)(this.baseStr + "[values={1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append("values", array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[values=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("values", (boolean[])null).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append(null, array).toString());
    }

    @Test
    void testAppendIntArrayWithFieldNameAndFullDetail() {
        int[] array = new int[]{1, 2, -3, 4};
        Assertions.assertEquals((Object)(this.baseStr + "[values={1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append("values", array, true).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[length=<size=4>]"), (Object)new ToStringBuilder((Object)this.base).append("length", array, false).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[values=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("values", (boolean[])null, true).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null, false).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<size=4>]"), (Object)new ToStringBuilder((Object)this.base).append(null, array, false).toString());
    }

    @Test
    void testAppendLongArrayWithFieldName() {
        long[] array = new long[]{1L, 2L, -3L, 4L};
        Assertions.assertEquals((Object)(this.baseStr + "[values={1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append("values", array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[values=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("values", (boolean[])null).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append(null, array).toString());
    }

    @Test
    void testAppendLongArrayWithFieldNameAndFullDetail() {
        long[] array = new long[]{1L, 2L, -3L, 4L};
        Assertions.assertEquals((Object)(this.baseStr + "[values={1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append("values", array, true).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[length=<size=4>]"), (Object)new ToStringBuilder((Object)this.base).append("length", array, false).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[values=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("values", (boolean[])null, true).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null, false).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<size=4>]"), (Object)new ToStringBuilder((Object)this.base).append(null, array, false).toString());
    }

    @Test
    void testAppendObjectArrayWithFieldName() {
        Object[] array = new Object[]{null, this.base, new int[]{3, 6}};
        Assertions.assertEquals((Object)(this.baseStr + "[values={<null>,5,{3,6}}]"), (Object)new ToStringBuilder((Object)this.base).append("values", array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[values=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("values", (boolean[])null).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{<null>,5,{3,6}}]"), (Object)new ToStringBuilder((Object)this.base).append(null, array).toString());
    }

    @Test
    void testAppendObjectArrayWithFieldNameAndFullDetail() {
        Object[] array = new Object[]{null, this.base, new int[]{3, 6}};
        Assertions.assertEquals((Object)(this.baseStr + "[values={<null>,5,{3,6}}]"), (Object)new ToStringBuilder((Object)this.base).append("values", array, true).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[length=<size=3>]"), (Object)new ToStringBuilder((Object)this.base).append("length", array, false).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[values=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("values", (boolean[])null, true).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null, false).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<size=3>]"), (Object)new ToStringBuilder((Object)this.base).append(null, array, false).toString());
    }

    @Test
    void testAppendShortArrayWithFieldName() {
        short[] array = new short[]{1, 2, -3, 4};
        Assertions.assertEquals((Object)(this.baseStr + "[values={1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append("values", array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[values=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("values", (boolean[])null).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append(null, array).toString());
    }

    @Test
    void testAppendShortArrayWithFieldNameAndFullDetail() {
        short[] array = new short[]{1, 2, -3, 4};
        Assertions.assertEquals((Object)(this.baseStr + "[values={1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append("values", array, true).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[length=<size=4>]"), (Object)new ToStringBuilder((Object)this.base).append("length", array, false).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[values=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("values", (boolean[])null, true).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null, (boolean[])null, false).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<size=4>]"), (Object)new ToStringBuilder((Object)this.base).append(null, array, false).toString());
    }

    @Test
    void testAppendSuper() {
        Assertions.assertEquals((Object)(this.baseStr + "[]"), (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[]").toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[<null>]").toString());
        Assertions.assertEquals((Object)(this.baseStr + "[a=hello]"), (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[]").append("a", (Object)"hello").toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>,a=hello]"), (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[<null>]").append("a", (Object)"hello").toString());
        Assertions.assertEquals((Object)(this.baseStr + "[a=hello]"), (Object)new ToStringBuilder((Object)this.base).appendSuper(null).append("a", (Object)"hello").toString());
    }

    @Test
    void testAppendToString() {
        Assertions.assertEquals((Object)(this.baseStr + "[]"), (Object)new ToStringBuilder((Object)this.base).appendToString("Integer@8888[]").toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).appendToString("Integer@8888[<null>]").toString());
        Assertions.assertEquals((Object)(this.baseStr + "[a=hello]"), (Object)new ToStringBuilder((Object)this.base).appendToString("Integer@8888[]").append("a", (Object)"hello").toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>,a=hello]"), (Object)new ToStringBuilder((Object)this.base).appendToString("Integer@8888[<null>]").append("a", (Object)"hello").toString());
        Assertions.assertEquals((Object)(this.baseStr + "[a=hello]"), (Object)new ToStringBuilder((Object)this.base).appendToString(null).append("a", (Object)"hello").toString());
    }

    @Test
    void testAppendToStringUsingMultiLineStyle() {
        MultiLineTestObject obj = new MultiLineTestObject();
        ToStringBuilder testBuilder = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendToString(obj.toString());
        Assertions.assertEquals((int)-1, (int)testBuilder.toString().indexOf("testInt=31337"));
    }

    @Test
    void testBlank() {
        Assertions.assertEquals((Object)(this.baseStr + "[]"), (Object)new ToStringBuilder((Object)this.base).toString());
    }

    @Test
    void testBoolean() {
        Assertions.assertEquals((Object)(this.baseStr + "[true]"), (Object)new ToStringBuilder((Object)this.base).append(true).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[a=true]"), (Object)new ToStringBuilder((Object)this.base).append("a", true).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[a=true,b=false]"), (Object)new ToStringBuilder((Object)this.base).append("a", true).append("b", false).toString());
    }

    @Test
    void testBooleanArray() {
        boolean[] array = new boolean[]{true, false, false};
        Assertions.assertEquals((Object)(this.baseStr + "[{true,false,false}]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{true,false,false}]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    void testBooleanArrayArray() {
        boolean[][] array = new boolean[][]{{true, false}, null, {false}};
        Assertions.assertEquals((Object)(this.baseStr + "[{{true,false},<null>,{false}}]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{{true,false},<null>,{false}}]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    void testByte() {
        Assertions.assertEquals((Object)(this.baseStr + "[3]"), (Object)new ToStringBuilder((Object)this.base).append((byte)3).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[a=3]"), (Object)new ToStringBuilder((Object)this.base).append("a", (byte)3).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[a=3,b=4]"), (Object)new ToStringBuilder((Object)this.base).append("a", (byte)3).append("b", (byte)4).toString());
    }

    @Test
    void testByteArray() {
        byte[] array = new byte[]{1, 2, -3, 4};
        Assertions.assertEquals((Object)(this.baseStr + "[{1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    void testByteArrayArray() {
        byte[][] array = new byte[][]{{1, 2}, null, {5}};
        Assertions.assertEquals((Object)(this.baseStr + "[{{1,2},<null>,{5}}]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{{1,2},<null>,{5}}]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    void testChar() {
        Assertions.assertEquals((Object)(this.baseStr + "[A]"), (Object)new ToStringBuilder((Object)this.base).append('A').toString());
        Assertions.assertEquals((Object)(this.baseStr + "[a=A]"), (Object)new ToStringBuilder((Object)this.base).append("a", 'A').toString());
        Assertions.assertEquals((Object)(this.baseStr + "[a=A,b=B]"), (Object)new ToStringBuilder((Object)this.base).append("a", 'A').append("b", 'B').toString());
    }

    @Test
    void testCharArray() {
        char[] array = new char[]{'A', '2', '_', 'D'};
        Assertions.assertEquals((Object)(this.baseStr + "[{A,2,_,D}]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{A,2,_,D}]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    void testCharArrayArray() {
        char[][] array = new char[][]{{'A', 'B'}, null, {'p'}};
        Assertions.assertEquals((Object)(this.baseStr + "[{{A,B},<null>,{p}}]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{{A,B},<null>,{p}}]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    void testConstructorEx1() {
        Assertions.assertEquals((Object)"<null>", (Object)new ToStringBuilder(null).toString());
    }

    @Test
    void testConstructorEx2() {
        Assertions.assertEquals((Object)"<null>", (Object)new ToStringBuilder(null, null).toString());
        new ToStringBuilder((Object)this.base, null).toString();
    }

    @Test
    void testConstructorEx3() {
        Assertions.assertEquals((Object)"<null>", (Object)new ToStringBuilder(null, null, null).toString());
        new ToStringBuilder((Object)this.base, null, null).toString();
        new ToStringBuilder((Object)this.base, ToStringStyle.DEFAULT_STYLE, null).toString();
    }

    @Test
    void testConstructToStringBuilder() {
        ToStringBuilder stringBuilder1 = new ToStringBuilder((Object)this.base, null, null);
        ToStringBuilder stringBuilder2 = new ToStringBuilder((Object)this.base, ToStringStyle.DEFAULT_STYLE, new StringBuffer(1024));
        Assertions.assertEquals((Object)ToStringStyle.DEFAULT_STYLE, (Object)stringBuilder1.getStyle());
        Assertions.assertNotNull((Object)stringBuilder1.getStringBuffer());
        Assertions.assertNotNull((Object)stringBuilder1.toString());
        Assertions.assertEquals((Object)ToStringStyle.DEFAULT_STYLE, (Object)stringBuilder2.getStyle());
        Assertions.assertNotNull((Object)stringBuilder2.getStringBuffer());
        Assertions.assertNotNull((Object)stringBuilder2.toString());
    }

    @Test
    void testDouble() {
        Assertions.assertEquals((Object)(this.baseStr + "[3.2]"), (Object)new ToStringBuilder((Object)this.base).append(3.2).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[a=3.2]"), (Object)new ToStringBuilder((Object)this.base).append("a", 3.2).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[a=3.2,b=4.3]"), (Object)new ToStringBuilder((Object)this.base).append("a", 3.2).append("b", 4.3).toString());
    }

    @Test
    void testDoubleArray() {
        double[] array = new double[]{1.0, 2.9876, -3.00001, 4.3};
        Assertions.assertEquals((Object)(this.baseStr + "[{1.0,2.9876,-3.00001,4.3}]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{1.0,2.9876,-3.00001,4.3}]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    void testDoubleArrayArray() {
        double[][] array = new double[][]{{1.0, 2.29686}, null, {Double.NaN}};
        Assertions.assertEquals((Object)(this.baseStr + "[{{1.0,2.29686},<null>,{NaN}}]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{{1.0,2.29686},<null>,{NaN}}]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    void testFloat() {
        Assertions.assertEquals((Object)(this.baseStr + "[3.2]"), (Object)new ToStringBuilder((Object)this.base).append(3.2f).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[a=3.2]"), (Object)new ToStringBuilder((Object)this.base).append("a", 3.2f).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[a=3.2,b=4.3]"), (Object)new ToStringBuilder((Object)this.base).append("a", 3.2f).append("b", 4.3f).toString());
    }

    @Test
    void testFloatArray() {
        float[] array = new float[]{1.0f, 2.9876f, -3.00001f, 4.3f};
        Assertions.assertEquals((Object)(this.baseStr + "[{1.0,2.9876,-3.00001,4.3}]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{1.0,2.9876,-3.00001,4.3}]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    void testFloatArrayArray() {
        float[][] array = new float[][]{{1.0f, 2.29686f}, null, {Float.NaN}};
        Assertions.assertEquals((Object)(this.baseStr + "[{{1.0,2.29686},<null>,{NaN}}]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{{1.0,2.29686},<null>,{NaN}}]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    void testGetSetDefault() {
        try {
            ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.NO_FIELD_NAMES_STYLE);
            Assertions.assertSame((Object)ToStringStyle.NO_FIELD_NAMES_STYLE, (Object)ToStringBuilder.getDefaultStyle());
        }
        finally {
            ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.DEFAULT_STYLE);
        }
    }

    @Test
    void testInheritedReflectionStatics() {
        InheritedReflectionStaticFieldsFixture instance1 = new InheritedReflectionStaticFieldsFixture();
        Assertions.assertEquals((Object)(this.toBaseString(instance1) + "[staticInt2=67890,staticString2=staticString2]"), (Object)ReflectionToStringBuilder.toString((Object)instance1, null, (boolean)false, (boolean)true, InheritedReflectionStaticFieldsFixture.class));
        Assertions.assertEquals((Object)(this.toBaseString(instance1) + "[staticInt2=67890,staticString2=staticString2,staticInt=12345,staticString=staticString]"), (Object)ReflectionToStringBuilder.toString((Object)instance1, null, (boolean)false, (boolean)true, SimpleReflectionStaticFieldsFixture.class));
        Assertions.assertEquals((Object)(this.toBaseString(instance1) + "[staticInt2=67890,staticString2=staticString2,staticInt=12345,staticString=staticString]"), (Object)this.toStringWithStatics(instance1, null, SimpleReflectionStaticFieldsFixture.class));
        Assertions.assertEquals((Object)(this.toBaseString(instance1) + "[staticInt2=67890,staticString2=staticString2,staticInt=12345,staticString=staticString]"), (Object)this.toStringWithStatics(instance1, null, SimpleReflectionStaticFieldsFixture.class));
    }

    @Test
    void testInnerClassReflection() {
        Outer outer = new Outer();
        Assertions.assertEquals((Object)(this.toBaseString(outer) + "[inner=" + this.toBaseString(outer.inner) + "[]]"), (Object)outer.toString());
    }

    @Test
    void testInt() {
        Assertions.assertEquals((Object)(this.baseStr + "[3]"), (Object)new ToStringBuilder((Object)this.base).append(3).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[a=3]"), (Object)new ToStringBuilder((Object)this.base).append("a", 3).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[a=3,b=4]"), (Object)new ToStringBuilder((Object)this.base).append("a", 3).append("b", 4).toString());
    }

    @Test
    void testIntArray() {
        int[] array = new int[]{1, 2, -3, 4};
        Assertions.assertEquals((Object)(this.baseStr + "[{1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    void testIntArrayArray() {
        int[][] array = new int[][]{{1, 2}, null, {5}};
        Assertions.assertEquals((Object)(this.baseStr + "[{{1,2},<null>,{5}}]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{{1,2},<null>,{5}}]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    void testLong() {
        Assertions.assertEquals((Object)(this.baseStr + "[3]"), (Object)new ToStringBuilder((Object)this.base).append(3L).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[a=3]"), (Object)new ToStringBuilder((Object)this.base).append("a", 3L).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[a=3,b=4]"), (Object)new ToStringBuilder((Object)this.base).append("a", 3L).append("b", 4L).toString());
    }

    @Test
    void testLongArray() {
        long[] array = new long[]{1L, 2L, -3L, 4L};
        Assertions.assertEquals((Object)(this.baseStr + "[{1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    void testLongArrayArray() {
        long[][] array = new long[][]{{1L, 2L}, null, {5L}};
        Assertions.assertEquals((Object)(this.baseStr + "[{{1,2},<null>,{5}}]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{{1,2},<null>,{5}}]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    void testObject() {
        Integer i3 = 3;
        Integer i4 = 4;
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[3]"), (Object)new ToStringBuilder((Object)this.base).append((Object)i3).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[a=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("a", null).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[a=3]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[a=3,b=4]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3).append("b", (Object)i4).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[a=<Integer>]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3, false).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[a=<size=0>]"), (Object)new ToStringBuilder((Object)this.base).append("a", new ArrayList(), false).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[a=[]]"), (Object)new ToStringBuilder((Object)this.base).append("a", new ArrayList(), true).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[a=<size=0>]"), (Object)new ToStringBuilder((Object)this.base).append("a", new HashMap(), false).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[a={}]"), (Object)new ToStringBuilder((Object)this.base).append("a", new HashMap(), true).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[a=<size=0>]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], false).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[a={}]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], true).toString());
    }

    @Test
    void testObjectArray() {
        Object[] array = new Object[]{null, this.base, new int[]{3, 6}};
        Assertions.assertEquals((Object)(this.baseStr + "[{<null>,5,{3,6}}]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{<null>,5,{3,6}}]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    void testObjectBuild() {
        Integer i3 = 3;
        Integer i4 = 4;
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(null).build());
        Assertions.assertEquals((Object)(this.baseStr + "[3]"), (Object)new ToStringBuilder((Object)this.base).append((Object)i3).build());
        Assertions.assertEquals((Object)(this.baseStr + "[a=<null>]"), (Object)new ToStringBuilder((Object)this.base).append("a", null).build());
        Assertions.assertEquals((Object)(this.baseStr + "[a=3]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3).build());
        Assertions.assertEquals((Object)(this.baseStr + "[a=3,b=4]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3).append("b", (Object)i4).build());
        Assertions.assertEquals((Object)(this.baseStr + "[a=<Integer>]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3, false).build());
        Assertions.assertEquals((Object)(this.baseStr + "[a=<size=0>]"), (Object)new ToStringBuilder((Object)this.base).append("a", new ArrayList(), false).build());
        Assertions.assertEquals((Object)(this.baseStr + "[a=[]]"), (Object)new ToStringBuilder((Object)this.base).append("a", new ArrayList(), true).build());
        Assertions.assertEquals((Object)(this.baseStr + "[a=<size=0>]"), (Object)new ToStringBuilder((Object)this.base).append("a", new HashMap(), false).build());
        Assertions.assertEquals((Object)(this.baseStr + "[a={}]"), (Object)new ToStringBuilder((Object)this.base).append("a", new HashMap(), true).build());
        Assertions.assertEquals((Object)(this.baseStr + "[a=<size=0>]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], false).build());
        Assertions.assertEquals((Object)(this.baseStr + "[a={}]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], true).build());
    }

    @Test
    void testObjectCycle() {
        ObjectCycle a = new ObjectCycle();
        ObjectCycle b = new ObjectCycle();
        a.obj = b;
        b.obj = a;
        String expected = this.toBaseString(a) + "[" + this.toBaseString(b) + "[" + this.toBaseString(a) + "]]";
        Assertions.assertEquals((Object)expected, (Object)a.toString());
    }

    @Test
    void testReflectionArrayAndObjectCycle() {
        Object[] objects = new Object[1];
        SimpleReflectionTestFixture simple = new SimpleReflectionTestFixture(objects);
        objects[0] = simple;
        Assertions.assertEquals((Object)(this.toBaseString(objects) + "[{" + this.toBaseString(simple) + "[o=" + this.toBaseString(objects) + "]}]"), (Object)ToStringBuilder.reflectionToString((Object)objects));
        Assertions.assertEquals((Object)(this.toBaseString(simple) + "[o={" + this.toBaseString(simple) + "}]"), (Object)ToStringBuilder.reflectionToString((Object)simple));
    }

    @Test
    void testReflectionArrayArrayCycle() {
        Object[][] objects;
        objects[0][0] = objects = new Object[2][2];
        objects[0][1] = objects;
        objects[1][0] = objects;
        objects[1][1] = objects;
        String basicToString = this.toBaseString(objects);
        Assertions.assertEquals((Object)(basicToString + "[{{" + basicToString + "," + basicToString + "},{" + basicToString + "," + basicToString + "}}]"), (Object)ToStringBuilder.reflectionToString((Object)objects));
    }

    @Test
    void testReflectionArrayCycle() {
        Object[] objects;
        objects[0] = objects = new Object[1];
        Assertions.assertEquals((Object)(this.toBaseString(objects) + "[{" + this.toBaseString(objects) + "}]"), (Object)ToStringBuilder.reflectionToString((Object)objects));
    }

    @Test
    void testReflectionArrayCycleLevel2() {
        Object[] objectsLevel2 = new Object[1];
        Object[] objects = new Object[]{objectsLevel2};
        objectsLevel2[0] = objects;
        Assertions.assertEquals((Object)(this.toBaseString(objects) + "[{{" + this.toBaseString(objects) + "}}]"), (Object)ToStringBuilder.reflectionToString((Object)objects));
        Assertions.assertEquals((Object)(this.toBaseString(objectsLevel2) + "[{{" + this.toBaseString(objectsLevel2) + "}}]"), (Object)ToStringBuilder.reflectionToString((Object)objectsLevel2));
    }

    @Test
    void testReflectionBoolean() {
        Boolean b = Boolean.TRUE;
        Assertions.assertEquals((Object)(this.toBaseString(b) + "[value=true]"), (Object)ToStringBuilder.reflectionToString((Object)b));
        b = Boolean.FALSE;
        Assertions.assertEquals((Object)(this.toBaseString(b) + "[value=false]"), (Object)ToStringBuilder.reflectionToString((Object)b));
    }

    @Test
    void testReflectionBooleanArray() {
        boolean[] array = new boolean[]{true, false, false};
        String baseString = this.toBaseString(array);
        Assertions.assertEquals((Object)(baseString + "[{true,false,false}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    void testReflectionBooleanArrayArray() {
        boolean[][] array = new boolean[][]{{true, false}, null, {false}};
        String baseString = this.toBaseString(array);
        Assertions.assertEquals((Object)(baseString + "[{{true,false},<null>,{false}}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        Assertions.assertEquals((Object)(baseString + "[{{true,false},<null>,{false}}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    void testReflectionByteArray() {
        byte[] array = new byte[]{1, 2, -3, 4};
        String baseString = this.toBaseString(array);
        Assertions.assertEquals((Object)(baseString + "[{1,2,-3,4}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    void testReflectionByteArrayArray() {
        byte[][] array = new byte[][]{{1, 2}, null, {5}};
        String baseString = this.toBaseString(array);
        Assertions.assertEquals((Object)(baseString + "[{{1,2},<null>,{5}}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    void testReflectionCharacter() {
        Character c = Character.valueOf('A');
        Assertions.assertEquals((Object)(this.toBaseString(c) + "[value=A]"), (Object)ToStringBuilder.reflectionToString((Object)c));
    }

    @Test
    void testReflectionCharArray() {
        char[] array = new char[]{'A', '2', '_', 'D'};
        String baseString = this.toBaseString(array);
        Assertions.assertEquals((Object)(baseString + "[{A,2,_,D}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    void testReflectionCharArrayArray() {
        char[][] array = new char[][]{{'A', 'B'}, null, {'p'}};
        String baseString = this.toBaseString(array);
        Assertions.assertEquals((Object)(baseString + "[{{A,B},<null>,{p}}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    void testReflectionDoubleArray() {
        double[] array = new double[]{1.0, 2.9876, -3.00001, 4.3};
        String baseString = this.toBaseString(array);
        Assertions.assertEquals((Object)(baseString + "[{1.0,2.9876,-3.00001,4.3}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    void testReflectionDoubleArrayArray() {
        double[][] array = new double[][]{{1.0, 2.29686}, null, {Double.NaN}};
        String baseString = this.toBaseString(array);
        Assertions.assertEquals((Object)(baseString + "[{{1.0,2.29686},<null>,{NaN}}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    void testReflectionFloatArray() {
        float[] array = new float[]{1.0f, 2.9876f, -3.00001f, 4.3f};
        String baseString = this.toBaseString(array);
        Assertions.assertEquals((Object)(baseString + "[{1.0,2.9876,-3.00001,4.3}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    void testReflectionFloatArrayArray() {
        float[][] array = new float[][]{{1.0f, 2.29686f}, null, {Float.NaN}};
        String baseString = this.toBaseString(array);
        Assertions.assertEquals((Object)(baseString + "[{{1.0,2.29686},<null>,{NaN}}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    void testReflectionHierarchy() {
        ReflectionTestFixtureA baseA = new ReflectionTestFixtureA();
        String baseString = this.toBaseString(baseA);
        Assertions.assertEquals((Object)(baseString + "[a=a]"), (Object)ToStringBuilder.reflectionToString((Object)baseA));
        Assertions.assertEquals((Object)(baseString + "[a=a]"), (Object)ToStringBuilder.reflectionToString((Object)baseA, null));
        Assertions.assertEquals((Object)(baseString + "[a=a]"), (Object)ToStringBuilder.reflectionToString((Object)baseA, null, (boolean)false));
        Assertions.assertEquals((Object)(baseString + "[a=a,transientA=t]"), (Object)ToStringBuilder.reflectionToString((Object)baseA, null, (boolean)true));
        Assertions.assertEquals((Object)(baseString + "[a=a]"), (Object)ToStringBuilder.reflectionToString((Object)baseA, null, (boolean)false, null));
        Assertions.assertEquals((Object)(baseString + "[a=a]"), (Object)ToStringBuilder.reflectionToString((Object)baseA, null, (boolean)false, Object.class));
        Assertions.assertEquals((Object)(baseString + "[a=a]"), (Object)ToStringBuilder.reflectionToString((Object)baseA, null, (boolean)false, ReflectionTestFixtureA.class));
        ReflectionTestFixtureB baseB = new ReflectionTestFixtureB();
        baseString = this.toBaseString(baseB);
        Assertions.assertEquals((Object)(baseString + "[b=b,a=a]"), (Object)ToStringBuilder.reflectionToString((Object)baseB));
        Assertions.assertEquals((Object)(baseString + "[b=b,a=a]"), (Object)ToStringBuilder.reflectionToString((Object)baseB));
        Assertions.assertEquals((Object)(baseString + "[b=b,a=a]"), (Object)ToStringBuilder.reflectionToString((Object)baseB, null));
        Assertions.assertEquals((Object)(baseString + "[b=b,a=a]"), (Object)ToStringBuilder.reflectionToString((Object)baseB, null, (boolean)false));
        Assertions.assertEquals((Object)(baseString + "[b=b,transientB=t,a=a,transientA=t]"), (Object)ToStringBuilder.reflectionToString((Object)baseB, null, (boolean)true));
        Assertions.assertEquals((Object)(baseString + "[b=b,a=a]"), (Object)ToStringBuilder.reflectionToString((Object)baseB, null, (boolean)false, null));
        Assertions.assertEquals((Object)(baseString + "[b=b,a=a]"), (Object)ToStringBuilder.reflectionToString((Object)baseB, null, (boolean)false, Object.class));
        Assertions.assertEquals((Object)(baseString + "[b=b,a=a]"), (Object)ToStringBuilder.reflectionToString((Object)baseB, null, (boolean)false, ReflectionTestFixtureA.class));
        Assertions.assertEquals((Object)(baseString + "[b=b]"), (Object)ToStringBuilder.reflectionToString((Object)baseB, null, (boolean)false, ReflectionTestFixtureB.class));
    }

    @Test
    void testReflectionHierarchyArrayList() {
        String toStringWithoutTransients;
        String expectedWithoutTransients;
        String toStringWithTransients;
        ArrayList list = new ArrayList(10);
        String baseString = this.toBaseString(list);
        String expectedWithTransients = baseString + "[elementData={<null>,<null>,<null>,<null>,<null>,<null>,<null>,<null>,<null>,<null>},size=0,modCount=0]";
        if (!expectedWithTransients.equals(toStringWithTransients = ToStringBuilder.reflectionToString(list, null, (boolean)true))) {
            Assertions.assertEquals((Object)expectedWithTransients, (Object)toStringWithTransients);
        }
        if (!(expectedWithoutTransients = baseString + "[size=0]").equals(toStringWithoutTransients = ToStringBuilder.reflectionToString(list, null, (boolean)false))) {
            Assertions.assertEquals((Object)expectedWithoutTransients, (Object)toStringWithoutTransients);
        }
    }

    @Test
    void testReflectionIntArray() {
        int[] array = new int[]{1, 2, -3, 4};
        String baseString = this.toBaseString(array);
        Assertions.assertEquals((Object)(baseString + "[{1,2,-3,4}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    void testReflectionIntArrayArray() {
        int[][] array = new int[][]{{1, 2}, null, {5}};
        String baseString = this.toBaseString(array);
        Assertions.assertEquals((Object)(baseString + "[{{1,2},<null>,{5}}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    void testReflectionInteger() {
        Assertions.assertEquals((Object)(this.baseStr + "[value=5]"), (Object)ToStringBuilder.reflectionToString((Object)this.base));
    }

    @Test
    void testReflectionLongArray() {
        long[] array = new long[]{1L, 2L, -3L, 4L};
        String baseString = this.toBaseString(array);
        Assertions.assertEquals((Object)(baseString + "[{1,2,-3,4}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    void testReflectionLongArrayArray() {
        long[][] array = new long[][]{{1L, 2L}, null, {5L}};
        String baseString = this.toBaseString(array);
        Assertions.assertEquals((Object)(baseString + "[{{1,2},<null>,{5}}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    void testReflectionNull() {
        Assertions.assertEquals((Object)"<null>", (Object)ReflectionToStringBuilder.toString(null));
    }

    @Test
    void testReflectionObjectArray() {
        Object[] array = new Object[]{null, this.base, new int[]{3, 6}};
        String baseString = this.toBaseString(array);
        Assertions.assertEquals((Object)(baseString + "[{<null>,5,{3,6}}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    void testReflectionObjectCycle() {
        ReflectionTestCycleB b;
        ReflectionTestCycleA a = new ReflectionTestCycleA();
        a.b = b = new ReflectionTestCycleB();
        b.a = a;
        Assertions.assertEquals((Object)(this.toBaseString(a) + "[b=" + this.toBaseString(b) + "[a=" + this.toBaseString(a) + "]]"), (Object)a.toString());
    }

    @Test
    void testReflectionShort2DArray() {
        short[][] array = new short[][]{{1, 2}, null, {5}};
        String baseString = this.toBaseString(array);
        Assertions.assertEquals((Object)(baseString + "[{{1,2},<null>,{5}}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    void testReflectionShortArray() {
        short[] array = new short[]{1, 2, -3, 4};
        String baseString = this.toBaseString(array);
        Assertions.assertEquals((Object)(baseString + "[{1,2,-3,4}]"), (Object)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
    }

    @Test
    void testReflectionStatics() {
        ReflectionStaticFieldsFixture instance1 = new ReflectionStaticFieldsFixture();
        Assertions.assertEquals((Object)(this.toBaseString(instance1) + "[instanceInt=67890,instanceString=instanceString,staticInt=12345,staticString=staticString]"), (Object)ReflectionToStringBuilder.toString((Object)instance1, null, (boolean)false, (boolean)true, ReflectionStaticFieldsFixture.class));
        Assertions.assertEquals((Object)(this.toBaseString(instance1) + "[instanceInt=67890,instanceString=instanceString,staticInt=12345,staticString=staticString,staticTransientInt=54321,staticTransientString=staticTransientString,transientInt=98765,transientString=transientString]"), (Object)ReflectionToStringBuilder.toString((Object)instance1, null, (boolean)true, (boolean)true, ReflectionStaticFieldsFixture.class));
        Assertions.assertEquals((Object)(this.toBaseString(instance1) + "[instanceInt=67890,instanceString=instanceString,staticInt=12345,staticString=staticString]"), (Object)this.toStringWithStatics(instance1, null, ReflectionStaticFieldsFixture.class));
        Assertions.assertEquals((Object)(this.toBaseString(instance1) + "[instanceInt=67890,instanceString=instanceString,staticInt=12345,staticString=staticString]"), (Object)this.toStringWithStatics(instance1, null, ReflectionStaticFieldsFixture.class));
    }

    @Test
    void testSelfInstanceTwoVarsReflectionObjectCycle() {
        SelfInstanceTwoVarsReflectionTestFixture test = new SelfInstanceTwoVarsReflectionTestFixture();
        Assertions.assertEquals((Object)(this.toBaseString(test) + "[otherType=" + test.getOtherType().toString() + ",typeIsSelf=" + this.toBaseString(test) + "]"), (Object)test.toString());
    }

    @Test
    void testSelfInstanceVarReflectionObjectCycle() {
        SelfInstanceVarReflectionTestFixture test = new SelfInstanceVarReflectionTestFixture();
        Assertions.assertEquals((Object)(this.toBaseString(test) + "[typeIsSelf=" + this.toBaseString(test) + "]"), (Object)test.toString());
    }

    @Test
    void testSetDefaultEx() {
        LangAssertions.assertNullPointerException(() -> ToStringBuilder.setDefaultStyle(null));
    }

    @Test
    void testShort() {
        Assertions.assertEquals((Object)(this.baseStr + "[3]"), (Object)new ToStringBuilder((Object)this.base).append((short)3).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[a=3]"), (Object)new ToStringBuilder((Object)this.base).append("a", (short)3).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[a=3,b=4]"), (Object)new ToStringBuilder((Object)this.base).append("a", (short)3).append("b", (short)4).toString());
    }

    @Test
    void testShortArray() {
        short[] array = new short[]{1, 2, -3, 4};
        Assertions.assertEquals((Object)(this.baseStr + "[{1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{1,2,-3,4}]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    void testShortArrayArray() {
        short[][] array = new short[][]{{1, 2}, null, {5}};
        Assertions.assertEquals((Object)(this.baseStr + "[{{1,2},<null>,{5}}]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[{{1,2},<null>,{5}}]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assertions.assertEquals((Object)(this.baseStr + "[<null>]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    void testSimpleReflectionObjectCycle() {
        SimpleReflectionTestFixture simple = new SimpleReflectionTestFixture();
        simple.o = simple;
        Assertions.assertEquals((Object)(this.toBaseString(simple) + "[o=" + this.toBaseString(simple) + "]"), (Object)simple.toString());
    }

    @Test
    void testSimpleReflectionStatics() {
        SimpleReflectionStaticFieldsFixture instance1 = new SimpleReflectionStaticFieldsFixture();
        Assertions.assertEquals((Object)(this.toBaseString(instance1) + "[staticInt=12345,staticString=staticString]"), (Object)ReflectionToStringBuilder.toString((Object)instance1, null, (boolean)false, (boolean)true, SimpleReflectionStaticFieldsFixture.class));
        Assertions.assertEquals((Object)(this.toBaseString(instance1) + "[staticInt=12345,staticString=staticString]"), (Object)ReflectionToStringBuilder.toString((Object)instance1, null, (boolean)true, (boolean)true, SimpleReflectionStaticFieldsFixture.class));
        Assertions.assertEquals((Object)(this.toBaseString(instance1) + "[staticInt=12345,staticString=staticString]"), (Object)this.toStringWithStatics(instance1, null, SimpleReflectionStaticFieldsFixture.class));
        Assertions.assertEquals((Object)(this.toBaseString(instance1) + "[staticInt=12345,staticString=staticString]"), (Object)this.toStringWithStatics(instance1, null, SimpleReflectionStaticFieldsFixture.class));
    }

    private String toBaseString(Object o) {
        return o.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(o));
    }

    public <T> String toStringWithStatics(T object, ToStringStyle style, Class<? super T> reflectUpToClass) {
        return ReflectionToStringBuilder.toString(object, (ToStringStyle)style, (boolean)false, (boolean)true, reflectUpToClass);
    }

    final class MultiLineTestObject {
        Integer i = 31337;

        MultiLineTestObject() {
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("testInt", (Object)this.i).toString();
        }
    }

    final class InheritedReflectionStaticFieldsFixture
    extends SimpleReflectionStaticFieldsFixture {
        static final String staticString2 = "staticString2";
        static final int staticInt2 = 67890;

        InheritedReflectionStaticFieldsFixture() {
        }
    }

    class SimpleReflectionStaticFieldsFixture {
        static final String staticString = "staticString";
        static final int staticInt = 12345;

        SimpleReflectionStaticFieldsFixture() {
        }
    }

    static class Outer {
        Inner inner = new Inner();

        Outer() {
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }

        final class Inner {
            Inner() {
            }

            public String toString() {
                return ToStringBuilder.reflectionToString((Object)this);
            }
        }
    }

    static class ObjectCycle {
        Object obj;

        ObjectCycle() {
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append(this.obj).toString();
        }
    }

    static class SimpleReflectionTestFixture {
        Object o;

        SimpleReflectionTestFixture() {
        }

        SimpleReflectionTestFixture(Object o) {
            this.o = o;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }

    static class ReflectionTestFixtureA {
        private final char a = (char)97;
        private final transient char transientA = (char)116;

        ReflectionTestFixtureA() {
        }
    }

    static class ReflectionTestFixtureB
    extends ReflectionTestFixtureA {
        private final char b = (char)98;
        private final transient char transientB = (char)116;

        ReflectionTestFixtureB() {
        }
    }

    static class ReflectionTestCycleA {
        ReflectionTestCycleB b;

        ReflectionTestCycleA() {
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }

    static class ReflectionTestCycleB {
        ReflectionTestCycleA a;

        ReflectionTestCycleB() {
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }

    final class ReflectionStaticFieldsFixture {
        static final String staticString = "staticString";
        static final int staticInt = 12345;
        static final transient String staticTransientString = "staticTransientString";
        static final transient int staticTransientInt = 54321;
        String instanceString = "instanceString";
        int instanceInt = 67890;
        transient String transientString = "transientString";
        transient int transientInt = 98765;

        ReflectionStaticFieldsFixture() {
        }
    }

    private static final class SelfInstanceTwoVarsReflectionTestFixture {
        private final SelfInstanceTwoVarsReflectionTestFixture typeIsSelf = this;
        private final String otherType = "The Other Type";

        SelfInstanceTwoVarsReflectionTestFixture() {
        }

        public String getOtherType() {
            return this.otherType;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }

    private static final class SelfInstanceVarReflectionTestFixture {
        private final SelfInstanceVarReflectionTestFixture typeIsSelf = this;

        SelfInstanceVarReflectionTestFixture() {
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }
}

