/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.IOException;
import org.apache.commons.validator.AbstractCommonTest;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValueBean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.xml.sax.SAXException;

class ExceptionTest
extends AbstractCommonTest {
    protected static final String FORM_KEY = "exceptionForm";
    protected static final String ACTION = "raiseException";

    ExceptionTest() {
    }

    @BeforeEach
    protected void setUp() throws IOException, SAXException {
        this.loadResources("ExceptionTest-config.xml");
    }

    @Disabled
    void testCheckedException() {
        ValueBean info = new ValueBean();
        info.setValue("CHECKED");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)info);
        try {
            validator.validate();
        }
        catch (ValidatorException expected) {
            Assertions.fail((String)"Checked exceptions are not wrapped in ValidatorException in Validator 1.x.");
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)"CHECKED-EXCEPTION", (Object)e.getMessage());
        }
    }

    @Disabled
    void testRuntimeException() throws ValidatorException {
        ValueBean info = new ValueBean();
        info.setValue("RUNTIME");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)info);
        try {
            validator.validate();
        }
        catch (RuntimeException expected) {
            Assertions.fail((String)"RuntimeExceptions should be treated as validation failures in Validator 1.x.");
        }
    }

    @Test
    void testValidatorException() {
        ValueBean info = new ValueBean();
        info.setValue("VALIDATOR");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)info);
        Exception expected = (Exception)Assertions.assertThrows(ValidatorException.class, () -> ((Validator)validator).validate());
        Assertions.assertEquals((Object)"VALIDATOR-EXCEPTION", (Object)expected.getMessage());
    }
}

