/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.mex;

import java.util.Collection;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.jaxws.JAXWSMethodInvoker;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.MAPAggregator;
import org.apache.cxf.ws.addressing.WSAddressingFeature;
import org.apache.cxf.ws.mex.MEXEndpoint;
import org.apache.cxf.ws.policy.AssertionInfoMap;

public class MEXInInterceptor
extends AbstractPhaseInterceptor<Message> {
    final MEXEndpoint ep;
    Endpoint mexEndpoint;

    public MEXInInterceptor(Server serv) {
        super("pre-protocol");
        this.ep = new MEXEndpoint(serv);
    }

    public void handleMessage(Message message) throws Fault {
        AddressingProperties inProps;
        String action = (String)message.get((Object)"SOAPAction");
        if (action == null && (inProps = (AddressingProperties)message.getContextualProperty("jakarta.xml.ws.addressing.context.inbound")) != null && inProps.getAction() != null) {
            action = inProps.getAction().getValue();
        }
        if ("http://schemas.xmlsoap.org/ws/2004/09/transfer/Get".equals(action) || "http://schemas.xmlsoap.org/ws/2004/09/mex/GetMetadata/Request".equals(action)) {
            message.remove((Object)AssertionInfoMap.class.getName());
            Exchange ex = message.getExchange();
            Endpoint endpoint = this.createEndpoint(message);
            ex.put(Endpoint.class, (Object)endpoint);
            ex.put(Service.class, (Object)endpoint.getService());
            ex.put(Binding.class, (Object)endpoint.getBinding());
            ex.put(BindingOperationInfo.class, (Object)endpoint.getBinding().getBindingInfo().getOperation(new QName("http://mex.ws.cxf.apache.org/", "Get2004")));
            ex.remove(BindingOperationInfo.class);
            message.put((Object)MAPAggregator.ACTION_VERIFIED, (Object)Boolean.TRUE);
            message.getInterceptorChain().add((Collection)endpoint.getInInterceptors());
            message.getInterceptorChain().add((Collection)endpoint.getBinding().getInInterceptors());
        }
    }

    private synchronized Endpoint createEndpoint(Message message) {
        if (this.mexEndpoint == null) {
            MEXJaxWsServerFactoryBean factory = new MEXJaxWsServerFactoryBean(message.getExchange().getBus());
            try {
                Endpoint endpoint = factory.createEndpoint();
                endpoint.getService().setInvoker((Invoker)new JAXWSMethodInvoker((Object)this.ep));
                this.mexEndpoint = endpoint;
            }
            catch (Exception ex) {
                throw new Fault((Throwable)ex);
            }
        }
        return this.mexEndpoint;
    }

    private static class MEXJaxWsServerFactoryBean
    extends JaxWsServerFactoryBean {
        MEXJaxWsServerFactoryBean(Bus b) {
            this.setServiceClass(MEXEndpoint.class);
            this.setServiceName(new QName("http://mex.ws.cxf.apache.org/", "MEXEndpoint"));
            this.setBus(b);
        }

        public Endpoint createEndpoint() throws BusException, EndpointException {
            Endpoint ep = super.createEndpoint();
            new WSAddressingFeature().initialize((InterceptorProvider)ep, this.getBus());
            return ep;
        }
    }
}

