/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public final class Ping
extends PacketImpl {
    private long connectionTTL;

    public Ping(long connectionTTL) {
        super((byte)10);
        this.connectionTTL = connectionTTL;
    }

    public Ping() {
        super((byte)10);
    }

    public long getConnectionTTL() {
        return this.connectionTTL;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeLong(this.connectionTTL);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.connectionTTL = buffer.readLong();
    }

    @Override
    public boolean isRequiresConfirmations() {
        return false;
    }

    @Override
    public int expectedEncodeSize() {
        return 21;
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", connectionTTL=" + this.connectionTTL);
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hashCode(this.connectionTTL);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Ping)) {
            return false;
        }
        Ping other = (Ping)obj;
        return this.connectionTTL == other.connectionTTL;
    }
}

