/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.cxf.wsdl;

import javax.xml.namespace.QName;

import org.apache.cxf.Bus;

public class ExtensionClassCreatorProxyService implements ExtensionClassCreator {
    private final ExtensionClassCreator srv;
    public ExtensionClassCreatorProxyService(Bus bus) {
        this(new ExtensionClassGenerator(bus));
    }
    public ExtensionClassCreatorProxyService(ExtensionClassCreator srv) {
        super();
        this.srv = srv;
    }

    @Override
    public Class<?> createExtensionClass(Class<?> cls, QName qname, ClassLoader loader) {
        return srv.createExtensionClass(cls, qname, loader);
    }

    public class LoadFirst extends ExtensionClassCreatorProxyService {
        public LoadFirst(Bus bus) {
            super(new ExtensionClassLoader(bus));
        }
    }
    public class GenerateJustInTime extends ExtensionClassCreatorProxyService {
        public GenerateJustInTime(Bus bus) {
            super(new ExtensionClassGenerator(bus));
        }
    }
}
