/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml.config;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.xml.ParserPool;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallerFactory;

public final class XMLObjectProviderRegistrySupport {
    private XMLObjectProviderRegistrySupport() {
    }

    @Nullable
    public static ParserPool getParserPool() {
        return ConfigurationService.ensure(XMLObjectProviderRegistry.class).getParserPool();
    }

    public static void setParserPool(@Nullable ParserPool newParserPool) {
        ConfigurationService.ensure(XMLObjectProviderRegistry.class).setParserPool(newParserPool);
    }

    @Nonnull
    public static QName getDefaultProviderQName() {
        return ConfigurationService.ensure(XMLObjectProviderRegistry.class).getDefaultProviderQName();
    }

    public static void registerObjectProvider(@Nonnull QName providerName, @Nonnull XMLObjectBuilder<?> builder, @Nonnull Marshaller marshaller, @Nonnull Unmarshaller unmarshaller) {
        XMLObjectProviderRegistry registry = ConfigurationService.ensure(XMLObjectProviderRegistry.class);
        registry.getBuilderFactory().registerBuilder(providerName, builder);
        registry.getMarshallerFactory().registerMarshaller(providerName, marshaller);
        registry.getUnmarshallerFactory().registerUnmarshaller(providerName, unmarshaller);
    }

    public static void deregisterObjectProvider(@Nonnull QName key) {
        XMLObjectProviderRegistry registry = ConfigurationService.ensure(XMLObjectProviderRegistry.class);
        registry.getBuilderFactory().deregisterBuilder(key);
        registry.getMarshallerFactory().deregisterMarshaller(key);
        registry.getUnmarshallerFactory().deregisterUnmarshaller(key);
    }

    @Nonnull
    public static XMLObjectBuilderFactory getBuilderFactory() {
        return ConfigurationService.ensure(XMLObjectProviderRegistry.class).getBuilderFactory();
    }

    @Nonnull
    public static MarshallerFactory getMarshallerFactory() {
        return ConfigurationService.ensure(XMLObjectProviderRegistry.class).getMarshallerFactory();
    }

    @Nonnull
    public static UnmarshallerFactory getUnmarshallerFactory() {
        return ConfigurationService.ensure(XMLObjectProviderRegistry.class).getUnmarshallerFactory();
    }

    public static void registerIDAttribute(@Nonnull QName attributeName) {
        ConfigurationService.ensure(XMLObjectProviderRegistry.class).registerIDAttribute(attributeName);
    }

    public static void deregisterIDAttribute(@Nonnull QName attributeName) {
        ConfigurationService.ensure(XMLObjectProviderRegistry.class).deregisterIDAttribute(attributeName);
    }

    public static boolean isIDAttribute(@Nonnull QName attributeName) {
        return ConfigurationService.ensure(XMLObjectProviderRegistry.class).isIDAttribute(attributeName);
    }
}

