/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ext.logging;

import java.util.Set;
import org.apache.cxf.Bus;
import org.apache.cxf.annotations.Provider;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.ext.logging.LoggingInInterceptor;
import org.apache.cxf.ext.logging.LoggingOutInterceptor;
import org.apache.cxf.ext.logging.MaskSensitiveHelper;
import org.apache.cxf.ext.logging.event.LogEventSender;
import org.apache.cxf.ext.logging.event.PrettyLoggingFilter;
import org.apache.cxf.ext.logging.slf4j.Slf4jEventSender;
import org.apache.cxf.ext.logging.slf4j.Slf4jVerboseEventSender;
import org.apache.cxf.feature.AbstractPortableFeature;
import org.apache.cxf.feature.DelegatingFeature;
import org.apache.cxf.interceptor.InterceptorProvider;

@NoJSR250Annotations
@Provider(value=Provider.Type.Feature)
public class LoggingFeature
extends DelegatingFeature<Portable> {
    public LoggingFeature() {
        super((AbstractPortableFeature)new Portable());
    }

    public void setLimit(int limit) {
        ((Portable)this.delegate).setLimit(limit);
    }

    public void setInMemThreshold(long inMemThreshold) {
        ((Portable)this.delegate).setInMemThreshold(inMemThreshold);
    }

    public void setSender(LogEventSender sender) {
        ((Portable)this.delegate).setSender(sender);
    }

    public void setInSender(LogEventSender s) {
        ((Portable)this.delegate).setInSender(s);
    }

    public void setOutSender(LogEventSender s) {
        ((Portable)this.delegate).setOutSender(s);
    }

    public void setPrettyLogging(boolean prettyLogging) {
        ((Portable)this.delegate).setPrettyLogging(prettyLogging);
    }

    public void setLogBinary(boolean logBinary) {
        ((Portable)this.delegate).setLogBinary(logBinary);
    }

    public void setLogMultipart(boolean logMultipart) {
        ((Portable)this.delegate).setLogMultipart(logMultipart);
    }

    public void setVerbose(boolean verbose) {
        ((Portable)this.delegate).setVerbose(verbose);
    }

    public void addInBinaryContentMediaTypes(String mediaTypes) {
        ((Portable)this.delegate).addInBinaryContentMediaTypes(mediaTypes);
    }

    public void addOutBinaryContentMediaTypes(String mediaTypes) {
        ((Portable)this.delegate).addOutBinaryContentMediaTypes(mediaTypes);
    }

    public void addBinaryContentMediaTypes(String mediaTypes) {
        ((Portable)this.delegate).addBinaryContentMediaTypes(mediaTypes);
    }

    public void setSensitiveElementNames(Set<String> sensitiveElementNames) {
        ((Portable)this.delegate).setSensitiveElementNames(sensitiveElementNames);
    }

    public void addSensitiveElementNames(Set<String> sensitiveElementNames) {
        ((Portable)this.delegate).addSensitiveElementNames(sensitiveElementNames);
    }

    public void setSensitiveProtocolHeaderNames(Set<String> sensitiveProtocolHeaderNames) {
        ((Portable)this.delegate).setSensitiveProtocolHeaderNames(sensitiveProtocolHeaderNames);
    }

    public void addSensitiveProtocolHeaderNames(Set<String> sensitiveProtocolHeaderNames) {
        ((Portable)this.delegate).addSensitiveProtocolHeaderNames(sensitiveProtocolHeaderNames);
    }

    public void setSensitiveDataHelper(MaskSensitiveHelper maskSensitiveHelper) {
        ((Portable)this.delegate).setSensitiveDataHelper(maskSensitiveHelper);
    }

    public static class Portable
    implements AbstractPortableFeature {
        private LoggingInInterceptor in;
        private LoggingOutInterceptor out;
        private PrettyLoggingFilter inPrettyFilter;
        private PrettyLoggingFilter outPrettyFilter;

        public Portable() {
            Slf4jVerboseEventSender sender = new Slf4jVerboseEventSender();
            this.inPrettyFilter = new PrettyLoggingFilter(sender);
            this.outPrettyFilter = new PrettyLoggingFilter(sender);
            this.in = new LoggingInInterceptor(this.inPrettyFilter);
            this.out = new LoggingOutInterceptor(this.outPrettyFilter);
        }

        public void doInitializeProvider(InterceptorProvider provider, Bus bus) {
            provider.getInInterceptors().add(this.in);
            provider.getInFaultInterceptors().add(this.in);
            provider.getOutInterceptors().add(this.out);
            provider.getOutFaultInterceptors().add(this.out);
        }

        public void setLimit(int limit) {
            this.in.setLimit(limit);
            this.out.setLimit(limit);
        }

        public void setInMemThreshold(long inMemThreshold) {
            this.in.setInMemThreshold(inMemThreshold);
            this.out.setInMemThreshold(inMemThreshold);
        }

        public void setSender(LogEventSender sender) {
            this.inPrettyFilter.setNext(sender);
            this.outPrettyFilter.setNext(sender);
        }

        public void setInSender(LogEventSender s) {
            this.inPrettyFilter.setNext(s);
        }

        public void setOutSender(LogEventSender s) {
            this.outPrettyFilter.setNext(s);
        }

        public void setPrettyLogging(boolean prettyLogging) {
            this.inPrettyFilter.setPrettyLogging(prettyLogging);
            this.outPrettyFilter.setPrettyLogging(prettyLogging);
        }

        public void setLogBinary(boolean logBinary) {
            this.in.setLogBinary(logBinary);
            this.out.setLogBinary(logBinary);
        }

        public void setLogMultipart(boolean logMultipart) {
            this.in.setLogMultipart(logMultipart);
            this.out.setLogMultipart(logMultipart);
        }

        public void setVerbose(boolean verbose) {
            this.setSender(verbose ? new Slf4jVerboseEventSender() : new Slf4jEventSender());
        }

        public void addInBinaryContentMediaTypes(String mediaTypes) {
            this.in.addBinaryContentMediaTypes(mediaTypes);
        }

        public void addOutBinaryContentMediaTypes(String mediaTypes) {
            this.out.addBinaryContentMediaTypes(mediaTypes);
        }

        public void addBinaryContentMediaTypes(String mediaTypes) {
            this.addInBinaryContentMediaTypes(mediaTypes);
            this.addOutBinaryContentMediaTypes(mediaTypes);
        }

        public void setSensitiveElementNames(Set<String> sensitiveElementNames) {
            this.in.setSensitiveElementNames(sensitiveElementNames);
            this.out.setSensitiveElementNames(sensitiveElementNames);
        }

        public void addSensitiveElementNames(Set<String> sensitiveElementNames) {
            this.in.addSensitiveElementNames(sensitiveElementNames);
            this.out.addSensitiveElementNames(sensitiveElementNames);
        }

        public void setSensitiveProtocolHeaderNames(Set<String> sensitiveProtocolHeaderNames) {
            this.in.setSensitiveProtocolHeaderNames(sensitiveProtocolHeaderNames);
            this.out.setSensitiveProtocolHeaderNames(sensitiveProtocolHeaderNames);
        }

        public void addSensitiveProtocolHeaderNames(Set<String> sensitiveProtocolHeaderNames) {
            this.in.addSensitiveProtocolHeaderNames(sensitiveProtocolHeaderNames);
            this.out.addSensitiveProtocolHeaderNames(sensitiveProtocolHeaderNames);
        }

        public void setSensitiveDataHelper(MaskSensitiveHelper maskSensitiveHelper) {
            this.in.setSensitiveDataHelper(maskSensitiveHelper);
            this.out.setSensitiveDataHelper(maskSensitiveHelper);
        }
    }
}

