/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.profile.logic;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.context.EventContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.CurrentOrPreviousEventLookup;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.common.messaging.context.SAMLEndpointContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.slf4j.Logger;

public class DefaultLocalErrorPredicate
implements Predicate<ProfileRequestContext> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultLocalErrorPredicate.class);
    @Nonnull
    private Function<ProfileRequestContext, SAMLBindingContext> bindingContextLookupStrategy = new ChildContextLookup(SAMLBindingContext.class).compose((Function)new OutboundMessageContextLookup());
    @Nonnull
    private Function<ProfileRequestContext, SAMLEndpointContext> endpointContextLookupStrategy = new ChildContextLookup(SAMLEndpointContext.class).compose((Function)new ChildContextLookup(SAMLPeerEntityContext.class)).compose(new OutboundMessageContextLookup());
    @Nonnull
    private Function<ProfileRequestContext, EventContext> eventContextLookupStrategy = new CurrentOrPreviousEventLookup();
    @Nonnull
    private Set<String> localEvents = CollectionSupport.emptySet();

    public void setBindingContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLBindingContext> strategy) {
        this.bindingContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLBindingContext lookup strategy cannot be null");
    }

    public void setEndpointContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLEndpointContext> strategy) {
        this.endpointContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLEndpointContext lookup strategy cannot be null");
    }

    public void setEventContextLookupStrategy(@Nonnull Function<ProfileRequestContext, EventContext> strategy) {
        this.eventContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EventContext lookup strategy cannot be null");
    }

    public void setLocalEvents(@Nullable Collection<String> events) {
        this.localEvents = new HashSet<String>(StringSupport.normalizeStringCollection(events));
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext input) {
        Object eObject;
        Boolean isPassive;
        Endpoint endpoint;
        if (input == null) {
            return true;
        }
        SAMLBindingContext bindingCtx = this.bindingContextLookupStrategy.apply(input);
        if (bindingCtx == null || bindingCtx.getBindingUri() == null) {
            this.log.debug("No SAMLBindingContext or binding URI available, error must be handled locally");
            return true;
        }
        SAMLEndpointContext endpointCtx = this.endpointContextLookupStrategy.apply(input);
        Endpoint endpoint2 = endpoint = endpointCtx != null ? endpointCtx.getEndpoint() : null;
        if (endpoint == null || endpoint.getLocation() == null && endpoint.getResponseLocation() == null) {
            this.log.debug("No SAMLEndpointContext or endpoint location available, error must be handled locally");
            return true;
        }
        AuthnRequest authnRequest = (AuthnRequest)new MessageLookup(AuthnRequest.class).apply(new InboundMessageContextLookup().apply(input));
        if (authnRequest != null && (isPassive = authnRequest.isPassive()) != null && isPassive.booleanValue()) {
            this.log.debug("Request was a SAML 2 AuthnRequest with IsPassive set, handling error with response");
            return false;
        }
        EventContext eventCtx = this.eventContextLookupStrategy.apply(input);
        Object object = eObject = eventCtx != null ? eventCtx.getEvent() : null;
        if (eObject == null) {
            this.log.debug("No event found, assuming error handled with response");
            return false;
        }
        String event = eObject.toString();
        if (this.localEvents.contains(event)) {
            this.log.debug("Error event {} will be handled locally", (Object)event);
            return true;
        }
        this.log.debug("Error event {} will be handled with response", (Object)event);
        return false;
    }
}

