/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.lc.type;

import java.util.Iterator;
import org.mozilla.javascript.lc.type.ParameterizedTypeInfo;
import org.mozilla.javascript.lc.type.TypeInfo;
import org.mozilla.javascript.lc.type.VariableTypeInfo;
import org.mozilla.javascript.lc.type.impl.ClassNameFormatContext;

public interface TypeFormatContext {
    public static final TypeFormatContext DEFAULT = Class::getName;
    public static final TypeFormatContext SIMPLE = Class::getSimpleName;
    public static final TypeFormatContext CLASS_NAME = new ClassNameFormatContext();

    public String getClassName(Class<?> var1);

    default public void append(StringBuilder builder, TypeInfo type) {
        this.append(builder, type, true);
    }

    default public void append(StringBuilder builder, TypeInfo type, boolean declaring) {
        if (type == TypeInfo.NONE) {
            builder.append(this.getFormattedNone());
        } else if (type.isArray()) {
            this.appendArray(builder, type);
        } else if (type instanceof VariableTypeInfo) {
            this.appendVariable(builder, (VariableTypeInfo)type, declaring);
        } else if (type instanceof ParameterizedTypeInfo) {
            this.appendParameterized(builder, (ParameterizedTypeInfo)type);
        } else {
            builder.append(type.toString(this));
        }
    }

    default public void appendArray(StringBuilder builder, TypeInfo type) {
        this.append(builder, type.getComponentType(), false);
        builder.append('[').append(']');
    }

    default public void appendParameterized(StringBuilder builder, ParameterizedTypeInfo type) {
        this.append(builder, type.rawType(), false);
        Iterator<TypeInfo> iterator = type.params().iterator();
        if (iterator.hasNext()) {
            builder.append('<');
            this.append(builder, iterator.next(), false);
            while (iterator.hasNext()) {
                builder.append(',');
                builder.append(' ');
                this.append(builder, iterator.next(), false);
            }
            builder.append('>');
        }
    }

    default public void appendVariable(StringBuilder builder, VariableTypeInfo type, boolean declaring) {
        TypeInfo mainBound;
        builder.append(type.name());
        if (declaring && !(mainBound = type.mainBound()).isObjectExact()) {
            builder.append(" extends ");
            this.append(builder, mainBound, false);
        }
    }

    default public String getFormattedNone() {
        return "?";
    }
}

