/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.replay;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.filter.impl.FilterImpl;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.journal.impl.JournalReaderCallback;
import org.apache.activemq.artemis.core.persistence.impl.journal.LargeServerMessageImpl;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.LargeMessagePersister;
import org.apache.activemq.artemis.core.replication.ReplicatedJournal;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.impl.RoutingContextImpl;
import org.apache.activemq.artemis.spi.core.protocol.MessagePersister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplayManager {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ActiveMQServer server;
    private JournalImpl journal;
    private final File retentionFolder;

    public static SimpleDateFormat newRetentionSimpleDateFormat() {
        return new SimpleDateFormat("yyyyMMddHHmmss");
    }

    public ReplayManager(ActiveMQServer server) {
        this.server = server;
        this.retentionFolder = server.getConfiguration().getJournalRetentionLocation();
    }

    public void replay(Date start, Date end, String sourceAddress, String targetAddressParameter, String filterStr) throws Exception {
        logger.debug("Replay start::sourceAddress={}", (Object)sourceAddress);
        Objects.requireNonNull(sourceAddress, "sourceAddress");
        if (targetAddressParameter == null || targetAddressParameter.trim().isEmpty()) {
            targetAddressParameter = sourceAddress;
        }
        String targetAddress = targetAddressParameter;
        if (this.journal == null) {
            Journal storageManageJournal = this.server.getStorageManager().getMessageJournal();
            if (storageManageJournal instanceof JournalImpl) {
                JournalImpl impl;
                this.journal = impl = (JournalImpl)storageManageJournal;
            } else if (storageManageJournal instanceof ReplicatedJournal) {
                ReplicatedJournal replicatedJournal = (ReplicatedJournal)storageManageJournal;
                this.journal = (JournalImpl)replicatedJournal.getLocalJournal();
            } else {
                throw new IllegalStateException("could not local a valid journal to use with the ReplayManager");
            }
        }
        final Filter filter = filterStr != null ? FilterImpl.createFilter(filterStr) : null;
        this.journal.forceBackup(1, TimeUnit.MINUTES);
        NIOSequentialFileFactory messagesFF = new NIOSequentialFileFactory(this.retentionFolder, null, 1);
        JournalImpl messagesJournal = new JournalImpl(this.server.getConfiguration().getJournalFileSize(), this.server.getConfiguration().getJournalMinFiles(), this.server.getConfiguration().getJournalPoolFiles(), 0, 0, (SequentialFileFactory)messagesFF, "activemq-data", "amq", 1);
        List files = messagesJournal.orderFiles();
        final RoutingContextImpl context = new RoutingContextImpl(null);
        final HashMap largeMessageLocations = new HashMap();
        for (final JournalFile file : files) {
            if (start != null || end != null) {
                String fileName = file.getFile().getFileName();
                long fileEpochTime = this.journal.getDatePortionMillis(fileName);
                if (logger.isDebugEnabled()) {
                    String datePortion = this.journal.getDatePortion(fileName);
                    logger.debug("Evaluating replay for file {}, datePortion={}\n\tInterval evaluated: start({}) --- file({}) --- end({})\n\tepoch times: start({}) --- file({}) + end({})", new Object[]{fileName, datePortion, start, new Date(fileEpochTime), end, start.getTime(), fileEpochTime, end.getTime()});
                }
                if (start != null && fileEpochTime < start.getTime()) {
                    logger.debug("File {} being skipped on start comparison", (Object)fileName);
                    continue;
                }
                if (end != null && fileEpochTime > end.getTime()) {
                    logger.debug("File {} being skipped on end comparison", (Object)fileName);
                    continue;
                }
            }
            logger.debug("Reading retention file {}", (Object)file);
            JournalImpl.readJournalFile((SequentialFileFactory)messagesFF, (JournalFile)file, (JournalReaderCallback)new JournalReaderCallback(){
                final /* synthetic */ SequentialFileFactory val$messagesFF;
                final /* synthetic */ String val$sourceAddress;
                final /* synthetic */ String val$targetAddress;
                final /* synthetic */ ReplayManager this$0;
                {
                    this.val$messagesFF = sequentialFileFactory;
                    this.val$sourceAddress = string;
                    this.val$targetAddress = string2;
                    this.this$0 = this$0;
                }

                public void onReadEventRecord(RecordInfo info) throws Exception {
                    switch (info.getUserRecordType()) {
                        case 49: {
                            LinkedHashSet<JournalFile> files = (LinkedHashSet<JournalFile>)largeMessageLocations.get(info.id);
                            if (files == null) {
                                files = new LinkedHashSet<JournalFile>();
                                largeMessageLocations.put(info.id, files);
                            }
                            files.add(file);
                            break;
                        }
                        default: {
                            this.onReadAddRecord(info);
                        }
                    }
                }

                public void onReadAddRecord(RecordInfo info) throws Exception {
                    if (info.getUserRecordType() == 30) {
                        ActiveMQBuffer buffer = ActiveMQBuffers.wrappedBuffer((byte[])info.data);
                        LargeServerMessageImpl message = new LargeServerMessageImpl(this.this$0.server.getStorageManager());
                        LargeMessagePersister.getInstance().decode(buffer, message, null);
                        this.this$0.route(filter, context, this.val$messagesFF, message.toMessage(), this.val$sourceAddress, this.val$targetAddress, largeMessageLocations);
                    } else if (info.getUserRecordType() == 45) {
                        ActiveMQBuffer buffer = ActiveMQBuffers.wrappedBuffer((byte[])info.data);
                        Message message = MessagePersister.getInstance().decode(buffer, null, null, this.this$0.server.getStorageManager());
                        this.this$0.route(filter, context, this.val$messagesFF, message, this.val$sourceAddress, this.val$targetAddress, largeMessageLocations);
                    }
                }

                public void onReadUpdateRecord(RecordInfo info) throws Exception {
                    this.onReadAddRecord(info);
                }

                public void onReadAddRecordTX(long transactionID, RecordInfo info) throws Exception {
                    this.onReadAddRecord(info);
                }

                public void onReadUpdateRecordTX(long transactionID, RecordInfo info) throws Exception {
                    this.onReadUpdateRecord(info);
                }
            }, null, (boolean)false, null);
        }
        logger.debug("Replay done::sourceAddress={}", (Object)sourceAddress);
    }

    private boolean messageMatch(Filter filter, Message message, String sourceAddress, String targetAddress) {
        if (message.getAddress() != null && message.getAddress().equals(sourceAddress)) {
            if (filter != null && !filter.match(message)) {
                return false;
            }
            if (targetAddress != null && !targetAddress.equals(sourceAddress)) {
                message.setAddress(targetAddress);
                message.reencode();
            }
            return true;
        }
        return false;
    }

    private void route(Filter filter, RoutingContext context, SequentialFileFactory messagesFF, Message message, String sourceAddress, String targetAddress, Map<Long, Set<JournalFile>> filesMap) throws Exception {
        if (this.messageMatch(filter, message, sourceAddress, targetAddress)) {
            long originalMessageID = message.getMessageID();
            message.setMessageID(this.server.getStorageManager().generateID());
            if (message.isLargeMessage()) {
                this.readLargeMessageBody(messagesFF, message, filesMap, originalMessageID);
            }
            if (targetAddress != null && !sourceAddress.equals(targetAddress)) {
                message.setAddress(targetAddress);
                message.reencode();
            }
            this.server.getPostOffice().route(message, context, false, false, null);
            context.clear();
        } else if (message.isLargeMessage()) {
            filesMap.remove(message.getMessageID());
        }
    }

    private void readLargeMessageBody(SequentialFileFactory messagesFF, Message message, Map<Long, Set<JournalFile>> filesMap, final long originalMessageID) throws Exception {
        final long newMessageID = message.getMessageID();
        final SequentialFile largeMessageFile = this.server.getStorageManager().createFileForLargeMessage(newMessageID, true);
        largeMessageFile.open();
        Set<JournalFile> files = filesMap.get(originalMessageID);
        if (files != null) {
            for (JournalFile file : files) {
                JournalImpl.readJournalFile((SequentialFileFactory)messagesFF, (JournalFile)file, (JournalReaderCallback)new JournalReaderCallback(){
                    final /* synthetic */ ReplayManager this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void onReadEventRecord(RecordInfo info) throws Exception {
                        if (info.userRecordType == 49 && info.id == originalMessageID) {
                            this.this$0.server.getStorageManager().addBytesToLargeMessage(largeMessageFile, newMessageID, info.data);
                        }
                    }
                });
            }
        }
        largeMessageFile.close();
    }
}

