/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.util;

import com.terracottatech.frs.util.AATreeSet;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CompressedLongSet
extends AbstractSet<Long> {
    protected volatile transient int modCount;
    protected final AATreeSet<BitSet> ranges = new AATreeSet();
    protected int size = 0;

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
        ++this.modCount;
        this.ranges.clear();
    }

    @Override
    public boolean addAll(Collection<? extends Long> c) {
        if (c instanceof CompressedLongSet) {
            CompressedLongSet other = (CompressedLongSet)c;
            int oldSize = this.size;
            Iterator<BitSet> myRanges = this.ranges.iterator();
            Iterator<BitSet> otherRanges = other.ranges.iterator();
            ArrayList<BitSet> toAdd = new ArrayList<BitSet>();
            BitSet currentMine = null;
            while (otherRanges.hasNext()) {
                if (currentMine == null) {
                    if (myRanges.hasNext()) {
                        currentMine = myRanges.next();
                    } else {
                        this.copyAndAddAll(otherRanges);
                        break;
                    }
                }
                BitSet nextOther = otherRanges.next();
                while (currentMine.start < nextOther.start && myRanges.hasNext()) {
                    currentMine = myRanges.next();
                }
                if (currentMine.start == nextOther.start) {
                    long sizeBefore = currentMine.size();
                    currentMine.addAll(nextOther);
                    this.size = (int)((long)this.size + (currentMine.size() - sizeBefore));
                    continue;
                }
                toAdd.add(nextOther);
                if (currentMine.start >= nextOther.start || myRanges.hasNext()) continue;
                this.copyAndAddAll(otherRanges);
            }
            this.copyAndAddAll(toAdd.iterator());
            return oldSize < this.size;
        }
        return super.addAll(c);
    }

    private void copyAndAddAll(Iterator<BitSet> i) {
        while (i.hasNext()) {
            BitSet copied = new BitSet(i.next());
            this.size = (int)((long)this.size + copied.size());
            boolean added = this.ranges.add(copied);
            if (!added) {
                throw new AssertionError((Object)("cloned : " + copied + " is not added to this set : " + this));
            }
        }
    }

    @Override
    public boolean add(Long l) {
        if (l == null) {
            throw new NullPointerException();
        }
        long start = CompressedLongSet.calculateStart(l);
        int nextRangeMaskBit = l < 0L ? (int)(64L - -l.longValue() % 64L) : (int)(l % 64L);
        BitSet prev = this.ranges.find(new BitSet(start, 0L));
        if (prev != null) {
            boolean isAdded = prev.add(l);
            if (isAdded) {
                ++this.size;
                ++this.modCount;
            }
            return isAdded;
        }
        long nextRange = 1L << nextRangeMaskBit;
        BitSet newRange = new BitSet(start, nextRange);
        boolean isAdded = this.ranges.add(newRange);
        if (isAdded) {
            ++this.size;
            ++this.modCount;
        }
        return isAdded;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Long) {
            long l = (Long)o;
            long start = CompressedLongSet.calculateStart(l);
            BitSet current = this.ranges.find(new BitSet(start, 0L));
            if (current == null) {
                return false;
            }
            if (current.remove(l)) {
                if (current.isEmpty()) {
                    this.ranges.remove(current);
                }
                --this.size;
                ++this.modCount;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Long) {
            long l = (Long)o;
            long start = CompressedLongSet.calculateStart(l);
            BitSet r = this.ranges.find(new BitSet(start, 0L));
            return r != null && this.isPresent(l, r);
        }
        return false;
    }

    private boolean isPresent(long lid, BitSet r) {
        long maskBit = 1L << (int)(lid - r.start);
        return (r.nextLongs & maskBit) != 0L;
    }

    @Override
    public Iterator<Long> iterator() {
        return new CompressedLongSetIterator();
    }

    private static long calculateStart(long lid) {
        if (lid < 0L) {
            return -64L + (lid + 1L) / 64L * 64L;
        }
        return lid - lid % 64L;
    }

    private static class BitSet
    extends AATreeSet.AbstractTreeNode<BitSet>
    implements Comparable<BitSet> {
        private long start;
        private long nextLongs = 0L;
        public static final int RANGE_SIZE = 64;

        public BitSet(long start, long nextRanges) {
            this.start = start;
            this.nextLongs = nextRanges;
        }

        public BitSet(BitSet copyThis) {
            this(copyThis.start, copyThis.nextLongs);
        }

        public void addAll(BitSet other) {
            if (this.start != other.start) {
                throw new AssertionError((Object)("Ranges : Start is not the same. mine : " + this.start + " other : " + other.start));
            }
            this.nextLongs |= other.nextLongs;
        }

        public String toString() {
            return "Range(" + this.start + "," + Long.toBinaryString(this.nextLongs) + ")";
        }

        public boolean isEmpty() {
            return this.nextLongs == 0L;
        }

        public long size() {
            return Long.bitCount(this.nextLongs);
        }

        public boolean remove(long lid) {
            if (lid < this.start || lid >= this.start + 64L) {
                throw new AssertionError((Object)("Ranges : Illegal value passed to remove : " + this + " remove called for : " + lid));
            }
            long maskBits = 1L << (int)(lid - this.start);
            this.nextLongs ^= (maskBits &= this.nextLongs);
            return maskBits != 0L;
        }

        public boolean add(long lid) {
            if (lid < this.start || lid >= this.start + 64L) {
                throw new AssertionError((Object)("Ranges : Illegal value passed to add : " + this + " add called for : " + lid));
            }
            long maskBits = 1L << (int)(lid - this.start);
            if ((this.nextLongs & maskBits) == 0L) {
                this.nextLongs |= maskBits;
                return true;
            }
            return false;
        }

        @Override
        public int compareTo(BitSet o) {
            if (this.start < o.start) {
                return -1;
            }
            if (this.start == o.start) {
                return 0;
            }
            return 1;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BitSet)) {
                return false;
            }
            BitSet o = (BitSet)obj;
            return this.start == o.start && this.nextLongs == o.nextLongs;
        }

        public int hashCode() {
            return (int)(this.start * 31L + this.nextLongs);
        }

        @Override
        public void swapPayload(AATreeSet.Node<BitSet> other) {
            if (!(other instanceof BitSet)) {
                throw new AssertionError((Object)("AATree can't contain both Ranges and other types : " + this + " other : " + other));
            }
            BitSet r = (BitSet)other;
            long temp = this.start;
            this.start = r.start;
            r.start = temp;
            temp = this.nextLongs;
            this.nextLongs = r.nextLongs;
            r.nextLongs = temp;
        }

        @Override
        public BitSet getPayload() {
            return this;
        }

        public long first() {
            if (this.nextLongs == 0L) {
                throw new NoSuchElementException();
            }
            return this.start + (long)Long.numberOfTrailingZeros(this.nextLongs);
        }

        public long last() {
            if (this.nextLongs == 0L) {
                throw new NoSuchElementException();
            }
            return this.start + 64L - 1L - (long)Long.numberOfLeadingZeros(this.nextLongs);
        }
    }

    private class CompressedLongSetIterator
    implements Iterator<Long> {
        private Iterator<BitSet> nodes;
        private BitSet current;
        private BitSet next;
        private Long lastReturned;
        private int idx;
        private int expectedModCount;

        CompressedLongSetIterator() {
            this.nodes = CompressedLongSet.this.ranges.iterator();
            this.expectedModCount = CompressedLongSet.this.modCount;
            this.idx = 0;
            if (this.nodes.hasNext()) {
                this.current = this.nodes.next();
            }
            this.next = this.nodes.hasNext() ? this.nodes.next() : null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null || this.current != null && !this.isPointingToLast();
        }

        private boolean isPointingToLast() {
            return this.current.last() < this.current.start + (long)this.idx;
        }

        @Override
        public Long next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            if (this.expectedModCount != CompressedLongSet.this.modCount) {
                throw new ConcurrentModificationException();
            }
            this.moveToNextIndex();
            long l = this.current.start + (long)this.idx;
            ++this.idx;
            this.lastReturned = l;
            return this.lastReturned;
        }

        private void moveToNextIndex() {
            if (this.current == null) {
                this.idx = 0;
                return;
            }
            long maskBit = 1L << this.idx;
            while ((this.current.nextLongs & maskBit) == 0L && this.idx < 64) {
                ++this.idx;
                maskBit = 1L << this.idx;
            }
            if (this.idx >= 64) {
                this.moveToNextGroup();
            }
        }

        private void moveToNextGroup() {
            this.idx = 0;
            if (this.next != null) {
                this.current = this.next;
                this.moveToNextIndex();
                this.next = this.nodes.hasNext() ? this.nodes.next() : null;
            } else {
                this.current = null;
            }
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (this.expectedModCount != CompressedLongSet.this.modCount) {
                throw new ConcurrentModificationException();
            }
            long l = this.lastReturned;
            long lastElement = this.current.last();
            this.current.remove(this.lastReturned);
            --CompressedLongSet.this.size;
            ++CompressedLongSet.this.modCount;
            if (!this.current.isEmpty()) {
                if (lastElement == this.lastReturned) {
                    this.current = this.next;
                    this.next = this.nodes.hasNext() ? this.nodes.next() : null;
                    this.idx = 0;
                }
            } else {
                CompressedLongSet.this.ranges.remove(this.current);
                this.nodes = CompressedLongSet.this.ranges.tailSet(new BitSet(CompressedLongSet.calculateStart(l), 0L)).iterator();
                this.idx = 0;
                this.current = this.nodes.hasNext() ? this.nodes.next() : null;
                BitSet bitSet = this.next = this.nodes.hasNext() ? this.nodes.next() : null;
            }
            if (this.current != null) {
                this.moveToNextIndex();
            } else {
                this.idx = 0;
            }
            this.expectedModCount = CompressedLongSet.this.modCount;
            this.lastReturned = null;
        }
    }
}

