/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.SerializableCallable;

public class LambdaFunction
extends BaseFunction {
    private static final long serialVersionUID = -8388132362854748293L;
    protected final SerializableCallable target;
    private final String name;
    private final int length;

    public LambdaFunction(Scriptable scope, String name, int length, SerializableCallable target, boolean defaultPrototype) {
        this.target = target;
        this.name = name;
        this.length = length;
        ScriptRuntime.setFunctionProtoAndParent((BaseFunction)this, Context.getCurrentContext(), scope);
        if (defaultPrototype) {
            this.setupDefaultPrototype(scope);
        }
    }

    public LambdaFunction(Scriptable scope, String name, int length, SerializableCallable target) {
        this(scope, name, length, target, true);
    }

    public LambdaFunction(Scriptable scope, String name, int length, Object prototype, SerializableCallable target) {
        this.target = target;
        this.name = name;
        this.length = length;
        ScriptRuntime.setFunctionProtoAndParent((BaseFunction)this, Context.getCurrentContext(), scope);
        this.setPrototypeProperty(prototype);
    }

    public LambdaFunction(Scriptable scope, int length, SerializableCallable target) {
        this.target = target;
        this.length = length;
        this.name = "";
        ScriptRuntime.setFunctionProtoAndParent((BaseFunction)this, Context.getCurrentContext(), scope);
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return this.target.call(cx, this.getDeclarationScope(), thisObj, args);
    }

    @Override
    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        throw ScriptRuntime.typeErrorById("msg.no.new", this.getFunctionName());
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getArity() {
        return this.length;
    }

    @Override
    public String getFunctionName() {
        return this.name;
    }

    Callable getTarget() {
        return this.target;
    }
}

