/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.layers.runtime1;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.daffodil.api.layers.Layer;
import org.apache.daffodil.io.BoundaryMarkInsertingJavaOutputStream;
import org.apache.daffodil.io.BoundaryMarkLimitingInputStream;
import org.apache.daffodil.io.BoundaryMarkLimitingInputStream$;
import org.apache.daffodil.runtime1.layers.ScalaLayerHelper;

public final class BoundaryMarkLayer
extends Layer
implements ScalaLayerHelper {
    private String boundaryMark;
    private Charset charset;
    private final int maxBoundaryMarkLength = Short.MAX_VALUE;

    public BoundaryMarkLayer() {
        super("boundaryMark", "urn:org.apache.daffodil.layers.boundaryMark");
        this.setProcessingErrorException(IllegalCharsetNameException.class);
        this.setProcessingErrorException(UnsupportedCharsetException.class);
    }

    public void setLayerVariableParameters(String boundaryMark, String layerEncoding) {
        this.boundaryMark = boundaryMark;
        if (boundaryMark.isEmpty()) {
            throw this.procError("The boundaryMark variable value may not be empty string.");
        }
        if (boundaryMark.length() > this.maxBoundaryMarkLength) {
            throw this.procError("The boundaryMark string length may not be greater than the limit: " + this.maxBoundaryMarkLength);
        }
        this.charset = Charset.forName(layerEncoding);
    }

    @Override
    public InputStream wrapLayerInput(InputStream jis) {
        return new BoundaryMarkLimitingInputStream(jis, this.boundaryMark, this.charset, BoundaryMarkLimitingInputStream$.MODULE$.$lessinit$greater$default$4());
    }

    @Override
    public OutputStream wrapLayerOutput(OutputStream jos) {
        return new BoundaryMarkInsertingJavaOutputStream(jos, this.boundaryMark, this.charset);
    }
}

