/*
 * Decompiled with CFR 0.152.
 */
package os;

import java.io.Serializable;
import java.util.concurrent.LinkedBlockingQueue;
import os.ProcessLike;
import os.ProcessPipeline$;
import os.SubProcess;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class ProcessPipeline
implements ProcessLike {
    private final Seq processes;
    private final boolean pipefail;
    private final Option brokenPipeHandler;

    public ProcessPipeline(Seq<SubProcess> processes, boolean pipefail, Option<LinkedBlockingQueue<Object>> brokenPipeQueue) {
        this.processes = processes;
        this.pipefail = pipefail;
        this.brokenPipeHandler = brokenPipeQueue.map((Function1 & Serializable)queue -> new Thread(new Runnable((LinkedBlockingQueue)queue, this){
            public final LinkedBlockingQueue os$ProcessPipeline$$anon$1$$queue$1;
            private final /* synthetic */ ProcessPipeline $outer;
            {
                this.os$ProcessPipeline$$anon$1$$queue$1 = queue$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                boolean pipelineRunning = true;
                while (pipelineRunning) {
                    int brokenPipeIndex = BoxesRunTime.unboxToInt(this.os$ProcessPipeline$$anon$1$$queue$1.take());
                    if (brokenPipeIndex == this.$outer.processes().length()) {
                        pipelineRunning = false;
                        continue;
                    }
                    ((SubProcess)this.$outer.processes().apply(brokenPipeIndex)).destroyForcibly();
                }
                new Thread(new Runnable(this){
                    private final /* synthetic */ $anon$1 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public void run() {
                        while (!this.$outer.os$ProcessPipeline$_$_$$anon$$$outer().waitFor(this.$outer.os$ProcessPipeline$_$_$$anon$$$outer().waitFor$default$1())) {
                        }
                        this.$outer.os$ProcessPipeline$$anon$1$$queue$1.put(BoxesRunTime.boxToInteger((int)this.$outer.os$ProcessPipeline$_$_$$anon$$$outer().processes().length()));
                    }
                }, new StringBuilder(29).append(this.$outer.commandString()).append(" pipeline termination handler").toString()).start();
            }

            public final /* synthetic */ ProcessPipeline os$ProcessPipeline$_$_$$anon$$$outer() {
                return this.$outer;
            }
        }, new StringBuilder(20).append(this.commandString()).append(" broken pipe handler").toString()));
    }

    public Seq<SubProcess> processes() {
        return this.processes;
    }

    public String commandString() {
        return ((IterableOnceOps)this.processes().map((Function1 & Serializable)_$3 -> _$3.wrapped().toString())).mkString(" | ");
    }

    public Option<Thread> brokenPipeHandler() {
        return this.brokenPipeHandler;
    }

    @Override
    public int exitCode() {
        if (this.pipefail) {
            return BoxesRunTime.unboxToInt((Object)((IterableOps)((IterableOps)this.processes().map((Function1 & Serializable)_$4 -> _$4.exitCode())).filter((Function1)(JFunction1.mcZI.sp & Serializable)_$5 -> _$5 != 0)).headOption().getOrElse(ProcessPipeline::exitCode$$anonfun$3));
        }
        return ((SubProcess)this.processes().last()).exitCode();
    }

    @Override
    public boolean isAlive() {
        return this.processes().exists((Function1 & Serializable)_$6 -> _$6.isAlive());
    }

    @Override
    public void destroy() {
        this.processes().foreach((Function1)(JProcedure1 & Serializable)_$7 -> _$7.destroy());
    }

    @Override
    public void destroyForcibly() {
        this.processes().foreach((Function1)(JProcedure1 & Serializable)_$8 -> _$8.destroyForcibly());
    }

    @Override
    public void close() {
        this.processes().foreach((Function1)(JProcedure1 & Serializable)_$9 -> _$9.close());
    }

    @Override
    public boolean waitFor(long timeout) {
        if (timeout == -1L) {
            return this.processes().forall((Function1 & Serializable)_$10 -> _$10.waitFor(_$10.waitFor$default$1()));
        }
        long timeNow = System.currentTimeMillis();
        return ProcessPipeline.waitForRec$1(timeout, timeNow, this.processes());
    }

    @Override
    public long waitFor$default$1() {
        return -1L;
    }

    @Override
    public boolean join(long timeout, long timeoutGracePeriod) {
        if (timeout == -1L) {
            return this.processes().forall((Function1 & Serializable)_$11 -> _$11.join(_$11.join$default$1(), _$11.join$default$2()));
        }
        return ProcessLike.join$(this, timeout, timeoutGracePeriod);
    }

    @Override
    public long join$default$1() {
        return -1L;
    }

    @Override
    public long join$default$2() {
        return 100L;
    }

    @Override
    public void joinPumperThreadsHook() {
        this.processes().foreach((Function1)(JProcedure1 & Serializable)_$12 -> _$12.joinPumperThreadsHook());
    }

    private static final int exitCode$$anonfun$3() {
        return 0;
    }

    private static final boolean waitForRec$1(long timeout$1, long startedAt, Seq processesLeft) {
        Seq seq;
        block3: {
            while (true) {
                seq = processesLeft;
                Nil$ nil$ = package$.MODULE$.Nil();
                Seq seq2 = seq;
                if (!(nil$ != null ? !nil$.equals(seq2) : seq2 != null)) {
                    return true;
                }
                if (!(seq instanceof .colon.colon)) break block3;
                .colon.colon colon2 = (.colon.colon)seq;
                List list2 = colon2.next$access$1();
                SubProcess head = (SubProcess)colon2.head();
                List tail = list2;
                long elapsed = System.currentTimeMillis() - startedAt;
                long timeoutLeft = timeout$1 - elapsed;
                if (timeoutLeft < 0L) {
                    return false;
                }
                if (!head.waitFor(timeoutLeft)) break;
                processesLeft = tail;
            }
            return false;
        }
        throw new MatchError((Object)seq);
    }
}

