/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.counters;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.msq.counters.QueryCounter;
import org.apache.druid.msq.counters.QueryCounterSnapshot;

public class SegmentGenerationProgressCounter
implements QueryCounter {
    @GuardedBy(value="this")
    private long rowsProcessed = 0L;
    @GuardedBy(value="this")
    private long rowsPersisted = 0L;
    @GuardedBy(value="this")
    private long rowsMerged = 0L;
    @GuardedBy(value="this")
    private long rowsPushed = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementRowsProcessed(long rowsProcessed) {
        SegmentGenerationProgressCounter segmentGenerationProgressCounter = this;
        synchronized (segmentGenerationProgressCounter) {
            this.rowsProcessed += rowsProcessed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementRowsPersisted(long rowsPersisted) {
        SegmentGenerationProgressCounter segmentGenerationProgressCounter = this;
        synchronized (segmentGenerationProgressCounter) {
            this.rowsPersisted += rowsPersisted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementRowsMerged(long rowsMerged) {
        SegmentGenerationProgressCounter segmentGenerationProgressCounter = this;
        synchronized (segmentGenerationProgressCounter) {
            this.rowsMerged += rowsMerged;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementRowsPushed(long rowsPushed) {
        SegmentGenerationProgressCounter segmentGenerationProgressCounter = this;
        synchronized (segmentGenerationProgressCounter) {
            this.rowsPushed += rowsPushed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public QueryCounterSnapshot snapshot() {
        SegmentGenerationProgressCounter segmentGenerationProgressCounter = this;
        synchronized (segmentGenerationProgressCounter) {
            return new Snapshot(this.rowsProcessed, this.rowsPersisted, this.rowsMerged, this.rowsPushed);
        }
    }

    @JsonTypeName(value="segmentGenerationProgress")
    public static class Snapshot
    implements QueryCounterSnapshot {
        private final long rowsProcessed;
        private final long rowsPersisted;
        private final long rowsMerged;
        private final long rowsPushed;

        @JsonCreator
        public Snapshot(@JsonProperty(value="rowsProcessed") long rowsProcessed, @JsonProperty(value="rowsPersisted") long rowsPersisted, @JsonProperty(value="rowsMerged") long rowsMerged, @JsonProperty(value="rowsPushed") long rowsPushed) {
            this.rowsProcessed = rowsProcessed;
            this.rowsPersisted = rowsPersisted;
            this.rowsMerged = rowsMerged;
            this.rowsPushed = rowsPushed;
        }

        @JsonProperty(value="rowsProcessed")
        public long getRowsProcessed() {
            return this.rowsProcessed;
        }

        @JsonProperty(value="rowsPersisted")
        public long getRowsPersisted() {
            return this.rowsPersisted;
        }

        @JsonProperty(value="rowsMerged")
        public long getRowsMerged() {
            return this.rowsMerged;
        }

        @JsonProperty(value="rowsPushed")
        public long getRowsPushed() {
            return this.rowsPushed;
        }

        public String toString() {
            return "Snapshot{rowsProcessed=" + this.rowsProcessed + ", rowsPersisted=" + this.rowsPersisted + ", rowsMerged=" + this.rowsMerged + ", rowsPushed=" + this.rowsPushed + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Snapshot snapshot = (Snapshot)o;
            return this.rowsProcessed == snapshot.rowsProcessed && this.rowsPersisted == snapshot.rowsPersisted && this.rowsMerged == snapshot.rowsMerged && this.rowsPushed == snapshot.rowsPushed;
        }

        public int hashCode() {
            return Objects.hash(this.rowsProcessed, this.rowsPersisted, this.rowsMerged, this.rowsPushed);
        }
    }
}

