/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.apache.druid.client.ImmutableSegmentLoadInfo;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.discovery.DataServerClient;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.counters.ChannelCounters;
import org.apache.druid.msq.exec.DataServerQueryResult;
import org.apache.druid.msq.exec.SegmentSource;
import org.apache.druid.msq.input.table.DataServerRequestDescriptor;
import org.apache.druid.msq.input.table.DataServerSelector;
import org.apache.druid.msq.input.table.RichSegmentDescriptor;
import org.apache.druid.msq.util.MultiStageQueryContext;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Queries;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryToolChestWarehouse;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.aggregation.MetricManipulatorFns;
import org.apache.druid.query.context.DefaultResponseContext;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.rpc.RpcException;
import org.apache.druid.rpc.ServiceClientFactory;
import org.apache.druid.rpc.ServiceLocation;
import org.apache.druid.server.coordination.DruidServerMetadata;

public class DataServerQueryHandler {
    private static final Logger log = new Logger(DataServerQueryHandler.class);
    private static final int DEFAULT_NUM_TRIES = 3;
    private static final int PER_SERVER_QUERY_NUM_TRIES = 5;
    private final String dataSource;
    private final ChannelCounters channelCounters;
    private final ServiceClientFactory serviceClientFactory;
    private final CoordinatorClient coordinatorClient;
    private final ObjectMapper objectMapper;
    private final QueryToolChestWarehouse warehouse;
    private final ScheduledExecutorService queryCancellationExecutor;
    private final DataServerRequestDescriptor dataServerRequestDescriptor;

    public DataServerQueryHandler(String dataSource, ChannelCounters channelCounters, ServiceClientFactory serviceClientFactory, CoordinatorClient coordinatorClient, ObjectMapper objectMapper, QueryToolChestWarehouse warehouse, ScheduledExecutorService queryCancellationExecutor, DataServerRequestDescriptor dataServerRequestDescriptor) {
        this.dataSource = dataSource;
        this.channelCounters = channelCounters;
        this.serviceClientFactory = serviceClientFactory;
        this.coordinatorClient = coordinatorClient;
        this.objectMapper = objectMapper;
        this.warehouse = warehouse;
        this.queryCancellationExecutor = queryCancellationExecutor;
        this.dataServerRequestDescriptor = dataServerRequestDescriptor;
    }

    @VisibleForTesting
    DataServerClient makeDataServerClient(ServiceLocation serviceLocation) {
        return new DataServerClient(this.serviceClientFactory, serviceLocation, this.objectMapper, this.queryCancellationExecutor);
    }

    public <RowType, QueryType> DataServerQueryResult<RowType> fetchRowsFromDataServer(Query<QueryType> query, java.util.function.Function<Sequence<QueryType>, Sequence<RowType>> mappingFunction, Closer closer) {
        Query preparedQuery = query.withDataSource((DataSource)new TableDataSource(this.dataSource));
        ArrayList yielders = new ArrayList();
        ArrayList<RichSegmentDescriptor> handedOffSegments = new ArrayList<RichSegmentDescriptor>();
        Object pendingRequests = ImmutableList.of((Object)this.dataServerRequestDescriptor);
        int maxRetries = preparedQuery.context().getNumRetriesOnMissingSegments(3);
        int retryCount = 0;
        while (!pendingRequests.isEmpty()) {
            DefaultResponseContext responseContext = new DefaultResponseContext();
            HashSet<RichSegmentDescriptor> processedSegments = new HashSet<RichSegmentDescriptor>();
            Iterator iterator = pendingRequests.iterator();
            while (iterator.hasNext()) {
                DataServerRequestDescriptor descriptor = (DataServerRequestDescriptor)iterator.next();
                log.info("Querying server [%s] for segments[%s]", new Object[]{descriptor.getServerMetadata(), descriptor.getSegments()});
                processedSegments.addAll(descriptor.getSegments());
                Yielder<RowType> yielder = this.fetchRowsFromDataServerInternal(descriptor, (ResponseContext)responseContext, closer, preparedQuery, mappingFunction);
                if (yielder == null || yielder.isDone()) continue;
                yielders.add(yielder);
            }
            List<SegmentDescriptor> missingSegments = DataServerQueryHandler.getMissingSegments((ResponseContext)responseContext);
            if (missingSegments.isEmpty()) break;
            List<SegmentDescriptor> handedOffSegmentDescriptors = this.checkSegmentHandoff(missingSegments);
            HashSet<RichSegmentDescriptor> missingRichSegmentDescriptors = new HashSet<RichSegmentDescriptor>();
            for (RichSegmentDescriptor richSegmentDescriptor : processedSegments) {
                SegmentDescriptor segmentDescriptor = DataServerQueryHandler.toSegmentDescriptorWithFullInterval(richSegmentDescriptor);
                if (!missingSegments.contains(segmentDescriptor)) continue;
                if (handedOffSegmentDescriptors.contains(segmentDescriptor)) {
                    handedOffSegments.add(richSegmentDescriptor);
                    continue;
                }
                missingRichSegmentDescriptors.add(richSegmentDescriptor);
            }
            pendingRequests = this.createNextPendingRequests(missingRichSegmentDescriptors, MultiStageQueryContext.getSegmentSources(query.context()), DataServerSelector.RANDOM);
            if (pendingRequests.isEmpty() || ++retryCount <= maxRetries) continue;
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.RUNTIME_FAILURE).build("Unable to fetch results from dataservers in [%d] retries.", new Object[]{retryCount});
        }
        return new DataServerQueryResult(yielders, handedOffSegments, this.dataSource);
    }

    private <QueryType, RowType> Yielder<RowType> fetchRowsFromDataServerInternal(DataServerRequestDescriptor requestDescriptor, ResponseContext responseContext, Closer closer, Query<QueryType> query, java.util.function.Function<Sequence<QueryType>, Sequence<RowType>> mappingFunction) {
        ServiceLocation serviceLocation = ServiceLocation.fromDruidServerMetadata((DruidServerMetadata)requestDescriptor.getServerMetadata());
        DataServerClient dataServerClient = this.makeDataServerClient(serviceLocation);
        QueryToolChest toolChest = this.warehouse.getToolChest(query);
        Function preComputeManipulatorFn = toolChest.makePreComputeManipulatorFn(query, MetricManipulatorFns.deserializing());
        JavaType queryResultType = toolChest.getBaseResultType();
        List segmentDescriptors = requestDescriptor.getSegments().stream().map(DataServerQueryHandler::toSegmentDescriptorWithFullInterval).collect(Collectors.toList());
        try {
            return (Yielder)RetryUtils.retry(() -> this.lambda$fetchRowsFromDataServerInternal$0(closer, dataServerClient, query, requestDescriptor, responseContext, queryResultType, (java.util.function.Function)preComputeManipulatorFn, mappingFunction), throwable -> !(throwable instanceof QueryInterruptedException) || !(throwable.getCause() instanceof InterruptedException), (int)5);
        }
        catch (QueryInterruptedException e) {
            if (e.getCause() instanceof RpcException) {
                responseContext.addMissingSegments(segmentDescriptors);
                return Yielders.each((Sequence)Sequences.empty());
            }
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.RUNTIME_FAILURE).build((Throwable)e, "Exception while fetching rows for query from dataservers[%s]", new Object[]{serviceLocation});
        }
        catch (Exception e) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.RUNTIME_FAILURE).build((Throwable)e, "Exception while fetching rows for query from dataservers[%s]", new Object[]{serviceLocation});
        }
    }

    private <RowType, QueryType> Yielder<RowType> createYielder(Sequence<QueryType> sequence, java.util.function.Function<Sequence<QueryType>, Sequence<RowType>> mappingFunction) {
        return Yielders.each((Sequence)mappingFunction.apply(sequence).map(row -> {
            this.channelCounters.incrementRowCount();
            return row;
        }));
    }

    private List<DataServerRequestDescriptor> createNextPendingRequests(Set<RichSegmentDescriptor> richSegmentDescriptors, SegmentSource includeSegmentSource, DataServerSelector dataServerSelector) {
        HashMap<DruidServerMetadata, Set> serverVsSegmentsMap = new HashMap<DruidServerMetadata, Set>();
        Iterable immutableSegmentLoadInfos = this.coordinatorClient.fetchServerViewSegments(this.dataSource, richSegmentDescriptors.stream().map(RichSegmentDescriptor::getFullInterval).collect(Collectors.toList()));
        HashMap segmentVsServerMap = new HashMap();
        immutableSegmentLoadInfos.forEach(immutableSegmentLoadInfo -> segmentVsServerMap.put(immutableSegmentLoadInfo.getSegment().toDescriptor(), immutableSegmentLoadInfo));
        for (RichSegmentDescriptor richSegmentDescriptor : richSegmentDescriptors) {
            SegmentDescriptor segmentDescriptorWithFullInterval = DataServerQueryHandler.toSegmentDescriptorWithFullInterval(richSegmentDescriptor);
            if (!segmentVsServerMap.containsKey(segmentDescriptorWithFullInterval)) {
                throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.RUNTIME_FAILURE).build("Could not find a server for segment[%s]", new Object[]{richSegmentDescriptor});
            }
            ImmutableSegmentLoadInfo segmentLoadInfo = (ImmutableSegmentLoadInfo)segmentVsServerMap.get(segmentDescriptorWithFullInterval);
            if (!segmentLoadInfo.getSegment().toDescriptor().equals((Object)segmentDescriptorWithFullInterval)) continue;
            Set servers = segmentLoadInfo.getServers().stream().filter(druidServerMetadata -> includeSegmentSource.getUsedServerTypes().contains(druidServerMetadata.getType())).collect(Collectors.toSet());
            if (servers.isEmpty()) {
                throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.RUNTIME_FAILURE).build("Could not find a server matching includeSegmentSource[%s] for segment[%s]. Only found servers [%s]", new Object[]{includeSegmentSource, richSegmentDescriptor, servers});
            }
            DruidServerMetadata druidServerMetadata2 = dataServerSelector.getSelectServerFunction().apply(servers);
            serverVsSegmentsMap.computeIfAbsent(druidServerMetadata2, ignored -> new HashSet());
            SegmentDescriptor descriptor = segmentLoadInfo.getSegment().toDescriptor();
            ((Set)serverVsSegmentsMap.get(druidServerMetadata2)).add(new RichSegmentDescriptor(richSegmentDescriptor.getFullInterval(), richSegmentDescriptor.getInterval(), descriptor.getVersion(), descriptor.getPartitionNumber()));
        }
        ArrayList<DataServerRequestDescriptor> requestDescriptors = new ArrayList<DataServerRequestDescriptor>();
        for (Map.Entry druidServerMetadataSetEntry : serverVsSegmentsMap.entrySet()) {
            DataServerRequestDescriptor dataServerRequest = new DataServerRequestDescriptor((DruidServerMetadata)druidServerMetadataSetEntry.getKey(), (List<RichSegmentDescriptor>)ImmutableList.copyOf((Collection)((Collection)druidServerMetadataSetEntry.getValue())));
            requestDescriptors.add(dataServerRequest);
        }
        return requestDescriptors;
    }

    private static List<SegmentDescriptor> getMissingSegments(ResponseContext responseContext) {
        List missingSegments = responseContext.getMissingSegments();
        if (missingSegments == null) {
            return ImmutableList.of();
        }
        return missingSegments;
    }

    private List<SegmentDescriptor> checkSegmentHandoff(List<SegmentDescriptor> segmentDescriptors) {
        try {
            ArrayList<SegmentDescriptor> handedOffSegments = new ArrayList<SegmentDescriptor>();
            for (SegmentDescriptor segmentDescriptor : segmentDescriptors) {
                Boolean wasHandedOff = (Boolean)FutureUtils.get((ListenableFuture)this.coordinatorClient.isHandoffComplete(this.dataSource, segmentDescriptor), (boolean)true);
                if (!Boolean.TRUE.equals(wasHandedOff)) continue;
                handedOffSegments.add(segmentDescriptor);
            }
            return handedOffSegments;
        }
        catch (Exception e) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.RUNTIME_FAILURE).build((Throwable)e, "Could not contact coordinator", new Object[0]);
        }
    }

    static SegmentDescriptor toSegmentDescriptorWithFullInterval(RichSegmentDescriptor richSegmentDescriptor) {
        return new SegmentDescriptor(richSegmentDescriptor.getFullInterval(), richSegmentDescriptor.getVersion(), richSegmentDescriptor.getPartitionNumber());
    }

    private /* synthetic */ Yielder lambda$fetchRowsFromDataServerInternal$0(Closer closer, DataServerClient dataServerClient, Query query, DataServerRequestDescriptor requestDescriptor, ResponseContext responseContext, JavaType queryResultType, java.util.function.Function preComputeManipulatorFn, java.util.function.Function mappingFunction) throws Exception {
        return (Yielder)closer.register(this.createYielder(dataServerClient.run(Queries.withSpecificSegments((Query)query, requestDescriptor.getSegments().stream().map(DataServerQueryHandler::toSegmentDescriptorWithFullInterval).collect(Collectors.toList())), responseContext, queryResultType, closer).map(preComputeManipulatorFn), mappingFunction));
    }
}

