/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.error.DruidException;
import org.apache.druid.msq.exec.ProcessingBuffers;
import org.apache.druid.msq.kernel.StageDefinition;

public class ProcessingBuffersSet {
    public static final ProcessingBuffersSet EMPTY = new ProcessingBuffersSet(Collections.emptyList());
    private final BlockingQueue<ProcessingBuffers> pool;

    public ProcessingBuffersSet(Collection<ProcessingBuffers> buffers) {
        this.pool = new ArrayBlockingQueue<ProcessingBuffers>(buffers.isEmpty() ? 1 : buffers.size());
        this.pool.addAll(buffers);
    }

    public static <T extends Collection<ByteBuffer>> ProcessingBuffersSet fromCollection(Collection<T> processingBuffers) {
        return new ProcessingBuffersSet(processingBuffers.stream().map(ProcessingBuffers::fromCollection).collect(Collectors.toList()));
    }

    @Nullable
    public ResourceHolder<ProcessingBuffers> acquireForStage(StageDefinition stageDef) {
        if (!stageDef.getProcessorFactory().usesProcessingBuffers()) {
            return null;
        }
        final ProcessingBuffers buffers = (ProcessingBuffers)this.pool.poll();
        if (buffers == null) {
            throw DruidException.defensive((String)"Processing buffers not available", (Object[])new Object[0]);
        }
        return new ResourceHolder<ProcessingBuffers>(){

            public ProcessingBuffers get() {
                return buffers;
            }

            public void close() {
                ProcessingBuffersSet.this.pool.add(buffers);
            }
        };
    }
}

