/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.druid.frame.processor.OutputChannel;
import org.apache.druid.frame.processor.OutputChannelFactory;
import org.apache.druid.frame.processor.PartitionedOutputChannel;
import org.apache.druid.msq.counters.ChannelCounters;
import org.apache.druid.msq.indexing.CountingWritableFrameChannel;

public class CountingOutputChannelFactory
implements OutputChannelFactory {
    private final OutputChannelFactory baseFactory;
    private final ChannelCounters channelCounters;

    public CountingOutputChannelFactory(OutputChannelFactory baseFactory, ChannelCounters channelCounters) {
        this.baseFactory = (OutputChannelFactory)Preconditions.checkNotNull((Object)baseFactory, (Object)"baseFactory");
        this.channelCounters = (ChannelCounters)Preconditions.checkNotNull((Object)channelCounters, (Object)"channelCounter");
    }

    public OutputChannel openChannel(int partitionNumber) throws IOException {
        OutputChannel baseChannel = this.baseFactory.openChannel(partitionNumber);
        return baseChannel.mapWritableChannel(baseWritableChannel -> new CountingWritableFrameChannel(baseChannel.getWritableChannel(), this.channelCounters, partitionNumber));
    }

    public PartitionedOutputChannel openPartitionedChannel(String name, boolean deleteAfterRead) throws IOException {
        PartitionedOutputChannel baseChannel = this.baseFactory.openPartitionedChannel(name, deleteAfterRead);
        return baseChannel.mapWritableChannel(baseWritableChannel -> new CountingWritableFrameChannel(baseChannel.getWritableChannel(), this.channelCounters, null));
    }

    public OutputChannel openNilChannel(int partitionNumber) {
        return this.baseFactory.openNilChannel(partitionNumber);
    }
}

