/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.druid.client.indexing.ClientCompactionRunnerInfo;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.partitions.DimensionRangePartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexer.partitions.SecondaryPartitionType;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.CompactionRunner;
import org.apache.druid.indexing.common.task.CompactionTask;
import org.apache.druid.indexing.common.task.CurrentSubTaskHolder;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.AllGranularity;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.msq.indexing.MSQControllerTask;
import org.apache.druid.msq.indexing.MSQSpec;
import org.apache.druid.msq.indexing.MSQTuningConfig;
import org.apache.druid.msq.indexing.destination.DataSourceMSQDestination;
import org.apache.druid.msq.util.MultiStageQueryContext;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Order;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.post.ExpressionPostAggregator;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.indexing.CombinedDataSchema;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.server.coordinator.CompactionConfigValidationResult;
import org.apache.druid.sql.calcite.planner.ColumnMapping;
import org.apache.druid.sql.calcite.planner.ColumnMappings;
import org.joda.time.Interval;

public class MSQCompactionRunner
implements CompactionRunner {
    private static final Logger log = new Logger(MSQCompactionRunner.class);
    public static final String TYPE = "msq";
    private static final Granularity DEFAULT_SEGMENT_GRANULARITY = Granularities.ALL;
    private final ObjectMapper jsonMapper;
    private final ExprMacroTable exprMacroTable;
    private final Injector injector;
    public static final String TIME_VIRTUAL_COLUMN = "__vTime";
    public static final String ARRAY_VIRTUAL_COLUMN_PREFIX = "__vArray_";
    @JsonIgnore
    private final CurrentSubTaskHolder currentSubTaskHolder = new CurrentSubTaskHolder((taskObject, config) -> {
        MSQControllerTask msqControllerTask = (MSQControllerTask)((Object)((Object)taskObject));
        msqControllerTask.stopGracefully((TaskConfig)config);
    });

    @JsonCreator
    public MSQCompactionRunner(@JacksonInject ObjectMapper jsonMapper, @JacksonInject ExprMacroTable exprMacroTable, @JacksonInject Injector injector) {
        this.jsonMapper = jsonMapper;
        this.exprMacroTable = exprMacroTable;
        this.injector = injector;
    }

    public CompactionConfigValidationResult validateCompactionTask(CompactionTask compactionTask, Map<Interval, DataSchema> intervalToDataSchemaMap) {
        if (intervalToDataSchemaMap.size() > 1) {
            return CompactionConfigValidationResult.failure((String)"MSQ: Disjoint compaction intervals[%s] not supported", (Object[])new Object[]{intervalToDataSchemaMap.keySet()});
        }
        ArrayList<CompactionConfigValidationResult> validationResults = new ArrayList<CompactionConfigValidationResult>();
        DataSchema dataSchema = (DataSchema)Iterables.getOnlyElement(intervalToDataSchemaMap.values());
        if (compactionTask.getTuningConfig() != null) {
            validationResults.add(ClientCompactionRunnerInfo.validatePartitionsSpecForMSQ((PartitionsSpec)compactionTask.getTuningConfig().getPartitionsSpec(), (List)dataSchema.getDimensionsSpec().getDimensions()));
            validationResults.add(this.validatePartitionDimensionsAreNotMultiValued(compactionTask.getTuningConfig().getPartitionsSpec(), dataSchema.getDimensionsSpec(), dataSchema instanceof CombinedDataSchema ? ((CombinedDataSchema)dataSchema).getMultiValuedDimensions() : null));
        }
        if (compactionTask.getGranularitySpec() != null) {
            validationResults.add(ClientCompactionRunnerInfo.validateRollupForMSQ((AggregatorFactory[])compactionTask.getMetricsSpec(), (Boolean)compactionTask.getGranularitySpec().isRollup()));
        }
        validationResults.add(ClientCompactionRunnerInfo.validateMaxNumTasksForMSQ((Map)compactionTask.getContext()));
        validationResults.add(ClientCompactionRunnerInfo.validateMetricsSpecForMSQ((AggregatorFactory[])compactionTask.getMetricsSpec()));
        return validationResults.stream().filter(result -> !result.isValid()).findFirst().orElse(CompactionConfigValidationResult.success());
    }

    private CompactionConfigValidationResult validatePartitionDimensionsAreNotMultiValued(PartitionsSpec partitionsSpec, DimensionsSpec dimensionsSpec, Set<String> multiValuedDimensions) {
        List dimensionSchemas = dimensionsSpec.getDimensionNames();
        if (partitionsSpec instanceof DimensionRangePartitionsSpec && dimensionSchemas != null && multiValuedDimensions != null && !multiValuedDimensions.isEmpty()) {
            Optional<String> multiValuedDimension = ((DimensionRangePartitionsSpec)partitionsSpec).getPartitionDimensions().stream().filter(multiValuedDimensions::contains).findAny();
            if (multiValuedDimension.isPresent()) {
                return CompactionConfigValidationResult.failure((String)"MSQ: Multi-valued string partition dimension[%s] not supported with 'range' partition spec", (Object[])new Object[]{multiValuedDimension.get()});
            }
        }
        return CompactionConfigValidationResult.success();
    }

    public CurrentSubTaskHolder getCurrentSubTaskHolder() {
        return this.currentSubTaskHolder;
    }

    public TaskStatus runCompactionTasks(CompactionTask compactionTask, Map<Interval, DataSchema> intervalDataSchemas, TaskToolbox taskToolbox) throws Exception {
        List<MSQControllerTask> msqControllerTasks = this.createMsqControllerTasks(compactionTask, intervalDataSchemas);
        if (msqControllerTasks.isEmpty()) {
            String msg = StringUtils.format((String)"Can't find segments from inputSpec[%s], nothing to do.", (Object[])new Object[]{compactionTask.getIoConfig().getInputSpec()});
            return TaskStatus.failure((String)compactionTask.getId(), (String)msg);
        }
        return MSQCompactionRunner.runSubtasks(msqControllerTasks, taskToolbox, this.currentSubTaskHolder, compactionTask.getId());
    }

    public List<MSQControllerTask> createMsqControllerTasks(CompactionTask compactionTask, Map<Interval, DataSchema> intervalDataSchemas) throws JsonProcessingException {
        ArrayList<MSQControllerTask> msqControllerTasks = new ArrayList<MSQControllerTask>();
        for (Map.Entry<Interval, DataSchema> intervalDataSchema : intervalDataSchemas.entrySet()) {
            Interval interval = intervalDataSchema.getKey();
            DataSchema dataSchema = intervalDataSchema.getValue();
            Map<String, VirtualColumn> inputColToVirtualCol = this.getVirtualColumns(dataSchema, interval);
            Query<?> query = MSQCompactionRunner.isGroupBy(dataSchema) ? this.buildGroupByQuery(compactionTask, interval, dataSchema, inputColToVirtualCol) : MSQCompactionRunner.buildScanQuery(compactionTask, interval, dataSchema, inputColToVirtualCol);
            QueryContext compactionTaskContext = new QueryContext(compactionTask.getContext());
            MSQSpec msqSpec = MSQSpec.builder().query(query).columnMappings(MSQCompactionRunner.getColumnMappings(dataSchema)).destination(MSQCompactionRunner.buildMSQDestination(compactionTask, dataSchema)).assignmentStrategy(MultiStageQueryContext.getAssignmentStrategy(compactionTaskContext)).tuningConfig(MSQCompactionRunner.buildMSQTuningConfig(compactionTask, compactionTaskContext)).build();
            Map<String, Object> msqControllerTaskContext = this.createMSQTaskContext(compactionTask, dataSchema);
            MSQControllerTask controllerTask = new MSQControllerTask(compactionTask.getId(), msqSpec.withOverriddenContext(msqControllerTaskContext), null, msqControllerTaskContext, null, null, null, msqControllerTaskContext, this.injector);
            msqControllerTasks.add(controllerTask);
        }
        return msqControllerTasks;
    }

    private static DataSourceMSQDestination buildMSQDestination(CompactionTask compactionTask, DataSchema dataSchema) {
        Interval replaceInterval = compactionTask.getIoConfig().getInputSpec().findInterval(compactionTask.getDataSource());
        return new DataSourceMSQDestination(dataSchema.getDataSource(), dataSchema.getGranularitySpec().getSegmentGranularity(), null, (List<Interval>)ImmutableList.of((Object)replaceInterval), dataSchema.getDimensionsSpec().getDimensions().stream().collect(Collectors.toMap(DimensionSchema::getName, Function.identity())), dataSchema.getProjections(), null);
    }

    private static MSQTuningConfig buildMSQTuningConfig(CompactionTask compactionTask, QueryContext compactionTaskContext) {
        int maxNumTasks = MultiStageQueryContext.getMaxNumTasks(compactionTaskContext);
        int maxNumWorkers = maxNumTasks - 1;
        int maxRowsInMemory = MultiStageQueryContext.getRowsInMemory(compactionTaskContext);
        Integer maxNumSegments = MultiStageQueryContext.getMaxNumSegments(compactionTaskContext);
        Integer rowsPerSegment = MSQCompactionRunner.getRowsPerSegment(compactionTask);
        return new MSQTuningConfig(maxNumWorkers, maxRowsInMemory, rowsPerSegment, maxNumSegments, compactionTask.getTuningConfig() != null ? compactionTask.getTuningConfig().getIndexSpec() : null);
    }

    private static Integer getRowsPerSegment(CompactionTask compactionTask) {
        if (compactionTask.getTuningConfig() != null && compactionTask.getTuningConfig().getPartitionsSpec() != null) {
            return compactionTask.getTuningConfig().getPartitionsSpec().getMaxRowsPerSegment();
        }
        return 5000000;
    }

    private static RowSignature getRowSignature(DataSchema dataSchema) {
        RowSignature.Builder rowSignatureBuilder = RowSignature.builder();
        if (dataSchema.getDimensionsSpec().isForceSegmentSortByTime()) {
            rowSignatureBuilder.add(dataSchema.getTimestampSpec().getTimestampColumn(), ColumnType.LONG);
        }
        if (!MSQCompactionRunner.isQueryGranularityEmptyOrNone(dataSchema)) {
            rowSignatureBuilder.add(TIME_VIRTUAL_COLUMN, ColumnType.LONG);
        }
        for (DimensionSchema dimensionSchema : dataSchema.getDimensionsSpec().getDimensions()) {
            rowSignatureBuilder.add(dimensionSchema.getName(), dimensionSchema.getColumnType());
        }
        for (AggregatorFactory aggregatorFactory : dataSchema.getAggregators()) {
            rowSignatureBuilder.add(aggregatorFactory.getName(), aggregatorFactory.getIntermediateType());
        }
        return rowSignatureBuilder.build();
    }

    private static List<DimensionSpec> getAggregateDimensions(DataSchema dataSchema, Map<String, VirtualColumn> inputColToVirtualCol) {
        ArrayList<DimensionSpec> dimensionSpecs = new ArrayList<DimensionSpec>();
        if (MSQCompactionRunner.isQueryGranularityEmptyOrNone(dataSchema)) {
            dimensionSpecs.add((DimensionSpec)new DefaultDimensionSpec("__time", TIME_VIRTUAL_COLUMN, ColumnType.LONG));
        } else {
            dimensionSpecs.add((DimensionSpec)new DefaultDimensionSpec(TIME_VIRTUAL_COLUMN, TIME_VIRTUAL_COLUMN, ColumnType.LONG));
        }
        dimensionSpecs.addAll(dataSchema.getDimensionsSpec().getDimensions().stream().map(dim -> {
            String dimension = dim.getName();
            ColumnType colType = dim.getColumnType();
            if (inputColToVirtualCol.containsKey(dim.getName())) {
                VirtualColumn virtualColumn = (VirtualColumn)inputColToVirtualCol.get(dimension);
                dimension = virtualColumn.getOutputName();
                if (virtualColumn instanceof ExpressionVirtualColumn) {
                    colType = ((ExpressionVirtualColumn)virtualColumn).getOutputType();
                }
            }
            return new DefaultDimensionSpec(dimension, dimension, colType);
        }).collect(Collectors.toList()));
        return dimensionSpecs;
    }

    private static ColumnMappings getColumnMappings(DataSchema dataSchema) {
        ArrayList<ColumnMapping> columnMappings = new ArrayList<ColumnMapping>();
        String timeColumn = MSQCompactionRunner.isGroupBy(dataSchema) || !MSQCompactionRunner.isQueryGranularityEmptyOrNone(dataSchema) ? TIME_VIRTUAL_COLUMN : "__time";
        ColumnMapping timeColumnMapping = new ColumnMapping(timeColumn, "__time");
        if (dataSchema.getDimensionsSpec().isForceSegmentSortByTime()) {
            columnMappings.add(timeColumnMapping);
        }
        columnMappings.addAll(dataSchema.getDimensionsSpec().getDimensions().stream().map(dim -> dim.getName().equals("__time") ? timeColumnMapping : new ColumnMapping(dim.getName(), dim.getName())).collect(Collectors.toList()));
        columnMappings.addAll(Arrays.stream(dataSchema.getAggregators()).map(agg -> new ColumnMapping(agg.getName(), agg.getName())).collect(Collectors.toList()));
        return new ColumnMappings(columnMappings);
    }

    private static List<OrderByColumnSpec> getOrderBySpec(PartitionsSpec partitionSpec) {
        if (partitionSpec.getType() == SecondaryPartitionType.RANGE) {
            List dimensions = ((DimensionRangePartitionsSpec)partitionSpec).getPartitionDimensions();
            return dimensions.stream().map(dim -> new OrderByColumnSpec(dim, OrderByColumnSpec.Direction.ASCENDING)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static Map<String, Object> buildQueryContext(Map<String, Object> taskContext, DataSchema dataSchema) {
        if (dataSchema.getDimensionsSpec().isForceSegmentSortByTime()) {
            return taskContext;
        }
        HashMap<String, Object> queryContext = new HashMap<String, Object>(taskContext);
        queryContext.put("forceSegmentSortByTime", false);
        return queryContext;
    }

    private static Query<?> buildScanQuery(CompactionTask compactionTask, Interval interval, DataSchema dataSchema, Map<String, VirtualColumn> inputColToVirtualCol) {
        RowSignature rowSignature = MSQCompactionRunner.getRowSignature(dataSchema);
        VirtualColumns virtualColumns = VirtualColumns.create(new ArrayList<VirtualColumn>(inputColToVirtualCol.values()));
        Druids.ScanQueryBuilder scanQueryBuilder = new Druids.ScanQueryBuilder().dataSource(dataSchema.getDataSource()).columns(rowSignature.getColumnNames()).virtualColumns(virtualColumns).columnTypes(rowSignature.getColumnTypes()).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(interval))).filters(dataSchema.getTransformSpec().getFilter()).context(MSQCompactionRunner.buildQueryContext(compactionTask.getContext(), dataSchema));
        if (compactionTask.getTuningConfig() != null && compactionTask.getTuningConfig().getPartitionsSpec() != null) {
            List<OrderByColumnSpec> orderByColumnSpecs = MSQCompactionRunner.getOrderBySpec(compactionTask.getTuningConfig().getPartitionsSpec());
            scanQueryBuilder.orderBy(orderByColumnSpecs.stream().map(orderByColumnSpec -> new OrderBy(orderByColumnSpec.getDimension(), Order.fromString((String)orderByColumnSpec.getDirection().toString()))).collect(Collectors.toList()));
        }
        return scanQueryBuilder.build();
    }

    private static boolean isGroupBy(DataSchema dataSchema) {
        if (dataSchema.getGranularitySpec() != null) {
            return dataSchema.getGranularitySpec().isRollup();
        }
        return dataSchema.getAggregators().length > 0;
    }

    private static boolean isQueryGranularityEmptyOrNone(DataSchema dataSchema) {
        return dataSchema.getGranularitySpec() == null || dataSchema.getGranularitySpec().getQueryGranularity() == null || Objects.equals(dataSchema.getGranularitySpec().getQueryGranularity(), Granularities.NONE);
    }

    private Map<String, VirtualColumn> getVirtualColumns(DataSchema dataSchema, Interval interval) {
        HashMap<String, VirtualColumn> inputColToVirtualCol = new HashMap<String, VirtualColumn>();
        if (!MSQCompactionRunner.isQueryGranularityEmptyOrNone(dataSchema)) {
            String timeVirtualColumnExpr;
            if (dataSchema.getGranularitySpec().getQueryGranularity().equals(Granularities.ALL)) {
                timeVirtualColumnExpr = StringUtils.format((String)"timestamp_parse('%s')", (Object[])new Object[]{interval.getStart()});
            } else {
                PeriodGranularity periodQueryGranularity = (PeriodGranularity)dataSchema.getGranularitySpec().getQueryGranularity();
                timeVirtualColumnExpr = StringUtils.format((String)"timestamp_floor(\"%s\", '%s')", (Object[])new Object[]{"__time", periodQueryGranularity.getPeriod().toString()});
            }
            inputColToVirtualCol.put("__time", (VirtualColumn)new ExpressionVirtualColumn(TIME_VIRTUAL_COLUMN, timeVirtualColumnExpr, ColumnType.LONG, this.exprMacroTable));
        }
        if (MSQCompactionRunner.isGroupBy(dataSchema)) {
            Set multiValuedColumns = dataSchema.getDimensionsSpec().getDimensions().stream().filter(dim -> dim.getColumnType().equals((Object)ColumnType.STRING)).map(DimensionSchema::getName).collect(Collectors.toSet());
            if (dataSchema instanceof CombinedDataSchema && ((CombinedDataSchema)dataSchema).getMultiValuedDimensions() != null) {
                Set multiValuedColumnsFromSchema = ((CombinedDataSchema)dataSchema).getMultiValuedDimensions();
                multiValuedColumns = multiValuedColumns.stream().filter(multiValuedColumnsFromSchema::contains).collect(Collectors.toSet());
            }
            for (String dim2 : multiValuedColumns) {
                String virtualColumnExpr = StringUtils.format((String)"mv_to_array(\"%s\")", (Object[])new Object[]{dim2});
                inputColToVirtualCol.put(dim2, (VirtualColumn)new ExpressionVirtualColumn(ARRAY_VIRTUAL_COLUMN_PREFIX + dim2, virtualColumnExpr, ColumnType.STRING_ARRAY, this.exprMacroTable));
            }
        }
        return inputColToVirtualCol;
    }

    private Query<?> buildGroupByQuery(CompactionTask compactionTask, Interval interval, DataSchema dataSchema, Map<String, VirtualColumn> inputColToVirtualCol) {
        DimFilter dimFilter = dataSchema.getTransformSpec().getFilter();
        VirtualColumns virtualColumns = VirtualColumns.create(new ArrayList<VirtualColumn>(inputColToVirtualCol.values()));
        List postAggregators = inputColToVirtualCol.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("__time")).map(entry -> new ExpressionPostAggregator((String)entry.getKey(), StringUtils.format((String)"array_to_mv(\"%s\")", (Object[])new Object[]{((VirtualColumn)entry.getValue()).getOutputName()}), null, ColumnType.STRING, this.exprMacroTable)).collect(Collectors.toList());
        GroupByQuery.Builder builder = new GroupByQuery.Builder().setDataSource((DataSource)new TableDataSource(compactionTask.getDataSource())).setVirtualColumns(virtualColumns).setDimFilter(dimFilter).setGranularity((Granularity)new AllGranularity()).setDimensions(MSQCompactionRunner.getAggregateDimensions(dataSchema, inputColToVirtualCol)).setAggregatorSpecs(Arrays.asList(dataSchema.getAggregators())).setPostAggregatorSpecs(postAggregators).setContext(MSQCompactionRunner.buildQueryContext(compactionTask.getContext(), dataSchema)).setInterval(interval);
        if (compactionTask.getTuningConfig() != null && compactionTask.getTuningConfig().getPartitionsSpec() != null) {
            MSQCompactionRunner.getOrderBySpec(compactionTask.getTuningConfig().getPartitionsSpec()).forEach(arg_0 -> ((GroupByQuery.Builder)builder).addOrderByColumn(arg_0));
        }
        return builder.build();
    }

    private String serializeGranularity(Granularity granularity, ObjectMapper jsonMapper) throws JsonProcessingException {
        if (granularity != null) {
            return granularity.equals(Granularities.ALL) ? "ALL" : jsonMapper.writeValueAsString((Object)granularity);
        }
        return null;
    }

    private Map<String, Object> createMSQTaskContext(CompactionTask compactionTask, DataSchema dataSchema) throws JsonProcessingException {
        HashMap<String, Object> context = new HashMap<String, Object>(compactionTask.getContext());
        context.put("sqlInsertSegmentGranularity", this.serializeGranularity(dataSchema.getGranularitySpec() != null ? dataSchema.getGranularitySpec().getSegmentGranularity() : DEFAULT_SEGMENT_GRANULARITY, this.jsonMapper));
        if (!MSQCompactionRunner.isQueryGranularityEmptyOrNone(dataSchema)) {
            context.put("sqlInsertQueryGranularity", this.serializeGranularity(dataSchema.getGranularitySpec().getQueryGranularity(), this.jsonMapper));
        }
        context.putIfAbsent("finalizeAggregations", false);
        context.putIfAbsent("finalize", false);
        context.putIfAbsent("groupByEnableMultiValueUnnesting", false);
        context.put("arrayIngestMode", "array");
        return context;
    }

    private static TaskStatus runSubtasks(List<MSQControllerTask> tasks, TaskToolbox toolbox, CurrentSubTaskHolder currentSubTaskHolder, String compactionTaskId) throws JsonProcessingException {
        int totalNumSpecs = tasks.size();
        log.info("Generated [%d] MSQControllerTask specs", new Object[]{totalNumSpecs});
        int failCnt = 0;
        for (MSQControllerTask eachTask : tasks) {
            String json = toolbox.getJsonMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)eachTask);
            if (!currentSubTaskHolder.setTask((Object)eachTask)) {
                String errMsg = "Task was asked to stop. Finish as failed.";
                log.info(errMsg, new Object[0]);
                return TaskStatus.failure((String)compactionTaskId, (String)errMsg);
            }
            try {
                if (eachTask.isReady(toolbox.getTaskActionClient())) {
                    log.info("Running MSQControllerTask: " + json, new Object[0]);
                    TaskStatus eachResult = eachTask.run(toolbox);
                    if (eachResult.isSuccess()) continue;
                    ++failCnt;
                    log.warn("Failed to run MSQControllerTask: [%s].\nTrying the next MSQControllerTask.", new Object[]{json});
                    continue;
                }
                ++failCnt;
                log.warn("MSQControllerTask is not ready: [%s].\nTrying the next MSQControllerTask.", new Object[]{json});
            }
            catch (Exception e) {
                ++failCnt;
                log.warn((Throwable)e, "Failed to run MSQControllerTask: [%s].\nTrying the next MSQControllerTask.", new Object[]{json});
            }
        }
        String msg = StringUtils.format((String)"Ran [%d] MSQControllerTasks, [%d] succeeded, [%d] failed", (Object[])new Object[]{totalNumSpecs, totalNumSpecs - failCnt, failCnt});
        log.info(msg, new Object[0]);
        return failCnt == 0 ? TaskStatus.success((String)compactionTaskId) : TaskStatus.failure((String)compactionTaskId, (String)msg);
    }
}

