/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Injector;
import com.google.inject.Key;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.client.indexing.ClientTaskQuery;
import org.apache.druid.guice.annotations.EscalatedGlobal;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.actions.TimeChunkLockTryAcquireAction;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.AbstractTask;
import org.apache.druid.indexing.common.task.IndexTaskUtils;
import org.apache.druid.indexing.common.task.PendingSegmentAllocatingTask;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.msq.exec.Controller;
import org.apache.druid.msq.exec.ControllerImpl;
import org.apache.druid.msq.exec.MSQTasks;
import org.apache.druid.msq.exec.ResultsContext;
import org.apache.druid.msq.indexing.IndexerControllerContext;
import org.apache.druid.msq.indexing.MSQSpec;
import org.apache.druid.msq.indexing.TaskReportQueryListener;
import org.apache.druid.msq.indexing.destination.DataSourceMSQDestination;
import org.apache.druid.msq.indexing.destination.DurableStorageMSQDestination;
import org.apache.druid.msq.indexing.destination.ExportMSQDestination;
import org.apache.druid.msq.indexing.destination.MSQDestination;
import org.apache.druid.msq.indexing.destination.TaskReportMSQDestination;
import org.apache.druid.msq.util.MultiStageQueryContext;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.rpc.ServiceClientFactory;
import org.apache.druid.rpc.ServiceRetryPolicy;
import org.apache.druid.rpc.StandardRetryPolicy;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.server.coordination.BroadcastDatasourceLoadingSpec;
import org.apache.druid.server.lookup.cache.LookupLoadingSpec;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.calcite.run.SqlResults;
import org.joda.time.Interval;

@JsonTypeName(value="query_controller")
public class MSQControllerTask
extends AbstractTask
implements ClientTaskQuery,
PendingSegmentAllocatingTask {
    public static final String TYPE = "query_controller";
    public static final String DUMMY_DATASOURCE_FOR_SELECT = "__query_select";
    public static final String DUMMY_DATASOURCE_FOR_EXPORT = "__query_export";
    private static final Logger log = new Logger(MSQControllerTask.class);
    private final MSQSpec querySpec;
    @Nullable
    private final String sqlQuery;
    @Nullable
    private final Map<String, Object> sqlQueryContext;
    @Nullable
    private final SqlResults.Context sqlResultsContext;
    @Nullable
    private final List<SqlTypeName> sqlTypeNames;
    @Nullable
    private final List<ColumnType> nativeTypeNames;
    @JacksonInject
    private Injector injector;
    private volatile Controller controller;

    @JsonCreator
    public MSQControllerTask(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="spec") MSQSpec querySpec, @JsonProperty(value="sqlQuery") @Nullable String sqlQuery, @JsonProperty(value="sqlQueryContext") @Nullable Map<String, Object> sqlQueryContext, @JsonProperty(value="sqlResultsContext") @Nullable SqlResults.Context sqlResultsContext, @JsonProperty(value="sqlTypeNames") @Nullable List<SqlTypeName> sqlTypeNames, @JsonProperty(value="nativeTypeNames") @Nullable List<ColumnType> nativeTypeNames, @JsonProperty(value="context") @Nullable Map<String, Object> context) {
        super(id != null ? id : MSQTasks.controllerTaskId(null), id, null, MSQControllerTask.getDataSourceForTaskMetadata(querySpec), context);
        this.querySpec = querySpec;
        this.sqlQuery = sqlQuery;
        this.sqlQueryContext = sqlQueryContext;
        this.sqlResultsContext = sqlResultsContext;
        this.sqlTypeNames = sqlTypeNames;
        this.nativeTypeNames = nativeTypeNames;
        this.addToContext("forceTimeChunkLock", true);
    }

    public MSQControllerTask(@Nullable String id, MSQSpec querySpec, @Nullable String sqlQuery, @Nullable Map<String, Object> sqlQueryContext, @Nullable SqlResults.Context sqlResultsContext, @Nullable List<SqlTypeName> sqlTypeNames, @Nullable List<ColumnType> nativeTypeNames, @Nullable Map<String, Object> context, Injector injector) {
        this(id, querySpec, sqlQuery, sqlQueryContext, sqlResultsContext, sqlTypeNames, nativeTypeNames, context);
        this.injector = injector;
    }

    public String getType() {
        return TYPE;
    }

    @Nonnull
    @JsonIgnore
    public Set<ResourceAction> getInputSourceResources() {
        return ImmutableSet.of();
    }

    public String getTaskAllocatorId() {
        return this.getId();
    }

    @JsonProperty(value="spec")
    public MSQSpec getQuerySpec() {
        return this.querySpec;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<SqlTypeName> getSqlTypeNames() {
        return this.sqlTypeNames;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<ColumnType> getNativeTypeNames() {
        return this.nativeTypeNames;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String getSqlQuery() {
        return this.sqlQuery;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<String, Object> getSqlQueryContext() {
        return this.sqlQueryContext;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SqlResults.Context getSqlResultsContext() {
        return this.sqlResultsContext;
    }

    public boolean isReady(TaskActionClient taskActionClient) throws Exception {
        if (MSQControllerTask.isIngestion(this.querySpec) && ((DataSourceMSQDestination)this.querySpec.getDestination()).isReplaceTimeChunks()) {
            TaskLockType taskLockType = this.getTaskLockType();
            List<Interval> intervals = ((DataSourceMSQDestination)this.querySpec.getDestination()).getReplaceTimeChunks();
            log.debug("Task[%s] trying to acquire[%s] locks for intervals[%s] to become ready", new Object[]{this.getId(), taskLockType, intervals});
            for (Interval interval : intervals) {
                TaskLock taskLock = (TaskLock)taskActionClient.submit((TaskAction)new TimeChunkLockTryAcquireAction(taskLockType, interval));
                if (taskLock == null) {
                    return false;
                }
                taskLock.assertNotRevoked();
            }
        }
        return true;
    }

    public TaskStatus runTask(TaskToolbox toolbox) throws Exception {
        ServiceClientFactory clientFactory = (ServiceClientFactory)this.injector.getInstance(Key.get(ServiceClientFactory.class, EscalatedGlobal.class));
        OverlordClient overlordClient = ((OverlordClient)this.injector.getInstance(OverlordClient.class)).withRetryPolicy((ServiceRetryPolicy)StandardRetryPolicy.unlimited());
        ServiceMetricEvent.Builder metricBuilder = new ServiceMetricEvent.Builder();
        IndexTaskUtils.setTaskDimensions((ServiceMetricEvent.Builder)metricBuilder, (AbstractTask)this);
        IndexerControllerContext context = new IndexerControllerContext(this.getTaskLockType(), this.getDataSource(), this.getQuerySpec().getContext(), this.getContext(), metricBuilder, toolbox, this.injector, clientFactory, overlordClient);
        this.controller = new ControllerImpl(this.getId(), this.querySpec, new ResultsContext(this.getSqlTypeNames(), this.getSqlResultsContext()), context);
        TaskReportQueryListener queryListener = new TaskReportQueryListener(this.querySpec.getDestination(), () -> toolbox.getTaskReportFileWriter().openReportOutputStream(this.getId()), toolbox.getJsonMapper(), this.getId(), this.getContext());
        this.controller.run(queryListener);
        return queryListener.getStatusReport().toTaskStatus(this.getId());
    }

    public void stopGracefully(TaskConfig taskConfig) {
        if (this.controller != null) {
            this.controller.stop();
        }
    }

    public int getPriority() {
        return (Integer)this.getContextValue("priority", 50);
    }

    @Nullable
    public TaskLockType getTaskLockType() {
        if (MSQControllerTask.isIngestion(this.querySpec)) {
            return MultiStageQueryContext.validateAndGetTaskLockType(QueryContext.of((Map)QueryContexts.override((Map)this.getContext(), (Map)this.querySpec.getContext().asMap())), ((DataSourceMSQDestination)this.querySpec.getDestination()).isReplaceTimeChunks());
        }
        return null;
    }

    private static String getDataSourceForTaskMetadata(MSQSpec querySpec) {
        MSQDestination destination = querySpec.getDestination();
        if (destination instanceof DataSourceMSQDestination) {
            return ((DataSourceMSQDestination)destination).getDataSource();
        }
        if (destination instanceof ExportMSQDestination) {
            return DUMMY_DATASOURCE_FOR_EXPORT;
        }
        return DUMMY_DATASOURCE_FOR_SELECT;
    }

    public Optional<Resource> getDestinationResource() {
        return this.querySpec.getDestination().getDestinationResource();
    }

    public static boolean isIngestion(MSQSpec querySpec) {
        return MSQControllerTask.isIngestion(querySpec.getDestination());
    }

    public static boolean isIngestion(MSQDestination destination) {
        return destination instanceof DataSourceMSQDestination;
    }

    public static boolean isExport(MSQDestination destination) {
        return destination instanceof ExportMSQDestination;
    }

    public static boolean writeFinalStageResultsToDurableStorage(MSQDestination destination) {
        return destination instanceof DurableStorageMSQDestination;
    }

    public static boolean writeFinalResultsToTaskReport(MSQDestination destination) {
        return destination instanceof TaskReportMSQDestination;
    }

    public static boolean isReplaceInputDataSourceTask(Query<?> query, MSQDestination destination) {
        if (MSQControllerTask.isIngestion(destination)) {
            String targetDataSource = ((DataSourceMSQDestination)destination).getDataSource();
            Set sourceTableNames = query.getDataSource().getTableNames();
            return sourceTableNames.contains(targetDataSource);
        }
        return false;
    }

    public LookupLoadingSpec getLookupLoadingSpec() {
        return LookupLoadingSpec.NONE;
    }

    public BroadcastDatasourceLoadingSpec getBroadcastDatasourceLoadingSpec() {
        return BroadcastDatasourceLoadingSpec.NONE;
    }
}

