/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Objects;
import org.apache.druid.msq.indexing.error.BaseMSQFault;

@JsonTypeName(value="TooManyRowsWithSameKey")
public class TooManyRowsWithSameKeyFault
extends BaseMSQFault {
    static final String CODE = "TooManyRowsWithSameKey";
    private final List<Object> key;
    private final long numBytes;
    private final long maxBytes;

    @JsonCreator
    public TooManyRowsWithSameKeyFault(@JsonProperty(value="key") List<Object> key, @JsonProperty(value="numBytes") long numBytes, @JsonProperty(value="maxBytes") long maxBytes) {
        super(CODE, "Too many rows with the same key[%s] on both sides of sort-merge join (bytes buffered[%,d], limit[%,d]). Try adjusting your query such that there are fewer rows with this key on at least one side of the join.", key, numBytes, maxBytes);
        this.key = key;
        this.numBytes = numBytes;
        this.maxBytes = maxBytes;
    }

    @JsonProperty
    public List<Object> getKey() {
        return this.key;
    }

    @JsonProperty
    public long getNumBytes() {
        return this.numBytes;
    }

    @JsonProperty
    public long getMaxBytes() {
        return this.maxBytes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TooManyRowsWithSameKeyFault that = (TooManyRowsWithSameKeyFault)o;
        return this.numBytes == that.numBytes && this.maxBytes == that.maxBytes && Objects.equals(this.key, that.key);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.key, this.numBytes, this.maxBytes);
    }
}

