/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.statistics;

import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.msq.statistics.PartialKeyStatisticsInformation;

public class CompleteKeyStatisticsInformation {
    private final SortedMap<Long, Set<Integer>> timeSegmentVsWorkerMap;
    private boolean multipleValues;
    private double bytesRetained;
    private boolean complete;

    public CompleteKeyStatisticsInformation(SortedMap<Long, Set<Integer>> timeChunks, boolean multipleValues, double bytesRetained) {
        this.timeSegmentVsWorkerMap = timeChunks;
        this.multipleValues = multipleValues;
        this.bytesRetained = bytesRetained;
    }

    public void mergePartialInformation(int workerNumber, PartialKeyStatisticsInformation partialKeyStatisticsInformation) {
        if (this.complete) {
            throw new ISE("Key stats for all workers have been received. This method should not be called.", new Object[0]);
        }
        for (Long timeSegment : partialKeyStatisticsInformation.getTimeSegments()) {
            this.timeSegmentVsWorkerMap.computeIfAbsent(timeSegment, key -> new HashSet()).add(workerNumber);
        }
        this.multipleValues = this.multipleValues || partialKeyStatisticsInformation.hasMultipleValues();
        this.bytesRetained += this.bytesRetained;
    }

    public SortedMap<Long, Set<Integer>> getTimeSegmentVsWorkerMap() {
        if (!this.complete) {
            throw new ISE("Key stats for all the workers have not been received. This method cant be called yet.", new Object[0]);
        }
        return this.timeSegmentVsWorkerMap;
    }

    public boolean hasMultipleValues() {
        return this.multipleValues;
    }

    public double getBytesRetained() {
        return this.bytesRetained;
    }

    public void complete() {
        this.complete = true;
    }

    public boolean isComplete() {
        return this.complete;
    }
}

