/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.s3;

import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import org.apache.druid.storage.s3.ServerSideEncryption;

class S3ServerSideEncryption
implements ServerSideEncryption {
    S3ServerSideEncryption() {
    }

    @Override
    public PutObjectRequest decorate(PutObjectRequest request) {
        ObjectMetadata objectMetadata = request.getMetadata() == null ? new ObjectMetadata() : request.getMetadata().clone();
        objectMetadata.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
        return request.withMetadata(objectMetadata);
    }

    @Override
    public CopyObjectRequest decorate(CopyObjectRequest request) {
        ObjectMetadata objectMetadata = request.getNewObjectMetadata() == null ? new ObjectMetadata() : request.getNewObjectMetadata().clone();
        objectMetadata.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
        return request.withNewObjectMetadata(objectMetadata);
    }
}

