/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.histogram;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.HistogramAggregatorFactory;
import org.apache.druid.query.aggregation.ObjectAggregateCombiner;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogram;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogramAggregator;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogramBufferAggregator;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogramFoldingAggregatorFactory;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogramVectorAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

@JsonTypeName(value="approxHistogram")
public class ApproximateHistogramAggregatorFactory
extends AggregatorFactory {
    public static final ColumnType TYPE = ColumnType.ofComplex((String)"approximateHistogram");
    protected final String name;
    protected final String fieldName;
    protected final int resolution;
    protected final int numBuckets;
    protected final float lowerLimit;
    protected final float upperLimit;
    protected final boolean finalizeAsBase64Binary;

    @JsonCreator
    public ApproximateHistogramAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="resolution") Integer resolution, @JsonProperty(value="numBuckets") Integer numBuckets, @JsonProperty(value="lowerLimit") Float lowerLimit, @JsonProperty(value="upperLimit") Float upperLimit, @JsonProperty(value="finalizeAsBase64Binary") @Nullable Boolean finalizeAsBase64Binary) {
        this.name = name;
        this.fieldName = fieldName;
        this.resolution = resolution == null ? 50 : resolution;
        this.numBuckets = numBuckets == null ? 7 : numBuckets;
        this.lowerLimit = lowerLimit == null ? Float.NEGATIVE_INFINITY : lowerLimit.floatValue();
        this.upperLimit = upperLimit == null ? Float.POSITIVE_INFINITY : upperLimit.floatValue();
        this.finalizeAsBase64Binary = finalizeAsBase64Binary == null ? false : finalizeAsBase64Binary;
        Preconditions.checkArgument((this.resolution > 0 ? 1 : 0) != 0, (Object)"resolution must be greater than 1");
        Preconditions.checkArgument((this.numBuckets > 0 ? 1 : 0) != 0, (Object)"numBuckets must be greater than 1");
        Preconditions.checkArgument((this.upperLimit > this.lowerLimit ? 1 : 0) != 0, (Object)"upperLimit must be greater than lowerLimit");
    }

    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        return new ApproximateHistogramAggregator((BaseFloatColumnValueSelector)metricFactory.makeColumnValueSelector(this.fieldName), this.resolution, this.lowerLimit, this.upperLimit);
    }

    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        return new ApproximateHistogramBufferAggregator((BaseFloatColumnValueSelector)metricFactory.makeColumnValueSelector(this.fieldName), this.resolution);
    }

    public VectorAggregator factorizeVector(VectorColumnSelectorFactory metricVectorFactory) {
        return new ApproximateHistogramVectorAggregator(metricVectorFactory.makeValueSelector(this.fieldName), this.resolution);
    }

    public boolean canVectorize(ColumnInspector columnInspector) {
        ColumnCapabilities capabilities = columnInspector.getColumnCapabilities(this.fieldName);
        return capabilities != null && capabilities.isNumeric();
    }

    public Comparator getComparator() {
        return ApproximateHistogramAggregator.COMPARATOR;
    }

    public Object combine(Object lhs, Object rhs) {
        return ApproximateHistogramAggregator.combineHistograms(lhs, rhs);
    }

    public AggregateCombiner makeAggregateCombiner() {
        return new ObjectAggregateCombiner<ApproximateHistogram>(){
            private final ApproximateHistogram combined = new ApproximateHistogram();

            public void reset(ColumnValueSelector selector) {
                ApproximateHistogram first = (ApproximateHistogram)selector.getObject();
                this.combined.copy(first);
            }

            public void fold(ColumnValueSelector selector) {
                ApproximateHistogram other = (ApproximateHistogram)selector.getObject();
                this.combined.foldFast(other);
            }

            public Class<ApproximateHistogram> classOfObject() {
                return ApproximateHistogram.class;
            }

            @Nullable
            public ApproximateHistogram getObject() {
                return this.combined;
            }
        };
    }

    public AggregatorFactory getCombiningFactory() {
        return new ApproximateHistogramFoldingAggregatorFactory(this.name, this.name, this.resolution, this.numBuckets, Float.valueOf(this.lowerLimit), Float.valueOf(this.upperLimit), this.finalizeAsBase64Binary);
    }

    public AggregatorFactory getMergingFactory(AggregatorFactory other) throws AggregatorFactoryNotMergeableException {
        if (other.getName().equals(this.getName()) && other instanceof ApproximateHistogramAggregatorFactory) {
            ApproximateHistogramAggregatorFactory castedOther = (ApproximateHistogramAggregatorFactory)other;
            return new ApproximateHistogramFoldingAggregatorFactory(this.name, this.name, Math.max(this.resolution, castedOther.resolution), this.numBuckets, Float.valueOf(Math.min(this.lowerLimit, castedOther.lowerLimit)), Float.valueOf(Math.max(this.upperLimit, castedOther.upperLimit)), this.finalizeAsBase64Binary);
        }
        throw new AggregatorFactoryNotMergeableException((AggregatorFactory)this, other);
    }

    public Object deserialize(Object object) {
        if (object instanceof byte[]) {
            ApproximateHistogram ah = ApproximateHistogram.fromBytes((byte[])object);
            ah.setLowerLimit(this.lowerLimit);
            ah.setUpperLimit(this.upperLimit);
            return ah;
        }
        if (object instanceof ByteBuffer) {
            ApproximateHistogram ah = ApproximateHistogram.fromBytes((ByteBuffer)object);
            ah.setLowerLimit(this.lowerLimit);
            ah.setUpperLimit(this.upperLimit);
            return ah;
        }
        if (object instanceof String) {
            byte[] bytes = StringUtils.decodeBase64((byte[])StringUtils.toUtf8((String)((String)object)));
            ApproximateHistogram ah = ApproximateHistogram.fromBytes(bytes);
            ah.setLowerLimit(this.lowerLimit);
            ah.setUpperLimit(this.upperLimit);
            return ah;
        }
        return object;
    }

    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        if (this.finalizeAsBase64Binary) {
            return object;
        }
        return object == null ? null : ((ApproximateHistogram)object).toHistogram(this.numBuckets);
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public int getResolution() {
        return this.resolution;
    }

    @JsonProperty
    public float getLowerLimit() {
        return this.lowerLimit;
    }

    @JsonProperty
    public float getUpperLimit() {
        return this.upperLimit;
    }

    @JsonProperty
    public int getNumBuckets() {
        return this.numBuckets;
    }

    public List<String> requiredFields() {
        return Collections.singletonList(this.fieldName);
    }

    public byte[] getCacheKey() {
        CacheKeyBuilder builder = new CacheKeyBuilder(18).appendString(this.fieldName).appendInt(this.resolution).appendInt(this.numBuckets).appendFloat(this.lowerLimit).appendFloat(this.upperLimit).appendBoolean(this.finalizeAsBase64Binary);
        return builder.build();
    }

    public ColumnType getIntermediateType() {
        return TYPE;
    }

    public ColumnType getResultType() {
        return this.finalizeAsBase64Binary ? TYPE : HistogramAggregatorFactory.TYPE;
    }

    public int getMaxIntermediateSize() {
        return new ApproximateHistogram(this.resolution).getMaxStorageSize();
    }

    public AggregatorFactory withName(String newName) {
        return new ApproximateHistogramAggregatorFactory(newName, this.getFieldName(), this.getResolution(), this.getNumBuckets(), Float.valueOf(this.getLowerLimit()), Float.valueOf(this.getUpperLimit()), this.finalizeAsBase64Binary);
    }

    public String toString() {
        return "ApproximateHistogramAggregatorFactory{name='" + this.name + "', fieldName='" + this.fieldName + "', resolution=" + this.resolution + ", numBuckets=" + this.numBuckets + ", lowerLimit=" + this.lowerLimit + ", upperLimit=" + this.upperLimit + ", finalizeAsBase64Binary=" + this.finalizeAsBase64Binary + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ApproximateHistogramAggregatorFactory that = (ApproximateHistogramAggregatorFactory)((Object)o);
        return this.resolution == that.resolution && this.numBuckets == that.numBuckets && Float.compare(that.lowerLimit, this.lowerLimit) == 0 && Float.compare(that.upperLimit, this.upperLimit) == 0 && this.finalizeAsBase64Binary == that.finalizeAsBase64Binary && Objects.equals(this.name, that.name) && Objects.equals(this.fieldName, that.fieldName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fieldName, this.resolution, this.numBuckets, Float.valueOf(this.lowerLimit), Float.valueOf(this.upperLimit), this.finalizeAsBase64Binary);
    }
}

