/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.read.columnar;

import com.google.common.primitives.Ints;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.read.FrameReaderUtils;
import org.apache.druid.frame.read.columnar.ColumnPlus;
import org.apache.druid.frame.read.columnar.FrameColumnReader;
import org.apache.druid.frame.read.columnar.FrameColumnReaderUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.ColumnAccessorBasedColumn;
import org.apache.druid.query.rowsandcols.column.accessor.ObjectColumnAccessorBase;
import org.apache.druid.segment.BaseSingleValueDimensionSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.DimensionSelectorUtils;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.RangeIndexedInts;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorObjectSelector;

public class StringFrameColumnReader
implements FrameColumnReader {
    private final int columnNumber;

    StringFrameColumnReader(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    @Override
    public Column readRACColumn(Frame frame) {
        Memory memory = frame.region(this.columnNumber);
        this.validate(memory);
        if (StringFrameColumnReader.isMultiValue(memory)) {
            throw InvalidInput.exception("Encountered a multi value column. Window processing does not support MVDs. Consider using UNNEST or MV_TO_ARRAY.", new Object[0]);
        }
        long positionOfLengths = StringFrameColumnReader.getStartOfStringLengthSection(frame.numRows(), false);
        long positionOfPayloads = StringFrameColumnReader.getStartOfStringDataSection(memory, frame.numRows(), false);
        StringFrameColumn frameCol = new StringFrameColumn(frame, false, memory, positionOfLengths, positionOfPayloads);
        return new ColumnAccessorBasedColumn(frameCol);
    }

    @Override
    public ColumnPlus readColumn(Frame frame) {
        Memory memory = frame.region(this.columnNumber);
        this.validate(memory);
        boolean multiValue = StringFrameColumnReader.isMultiValue(memory);
        long startOfStringLengthSection = StringFrameColumnReader.getStartOfStringLengthSection(frame.numRows(), multiValue);
        long startOfStringDataSection = StringFrameColumnReader.getStartOfStringDataSection(memory, frame.numRows(), multiValue);
        StringFrameColumn baseColumn = new StringFrameColumn(frame, multiValue, memory, startOfStringLengthSection, startOfStringDataSection);
        return new ColumnPlus(baseColumn, new ColumnCapabilitiesImpl().setType(ColumnType.STRING).setHasMultipleValues(multiValue).setDictionaryEncoded(false), frame.numRows());
    }

    private void validate(Memory region) {
        if (region.getCapacity() < 2L) {
            throw DruidException.defensive("Column[%s] is not big enough for a header", this.columnNumber);
        }
        byte typeCode = region.getByte(0L);
        if (typeCode != 4) {
            throw DruidException.defensive("Column[%s] does not have the correct type code; expected[%s], got[%s]", this.columnNumber, (byte)4, typeCode);
        }
    }

    private static boolean isMultiValue(Memory memory) {
        return memory.getByte(1L) == 1;
    }

    private static long getStartOfCumulativeLengthSection() {
        return 2L;
    }

    private static long getStartOfStringLengthSection(int numRows, boolean multiValue) {
        if (multiValue) {
            return 2L + 4L * (long)numRows;
        }
        return 2L;
    }

    private static long getStartOfStringDataSection(Memory memory, int numRows, boolean multiValue) {
        int totalNumValues = multiValue ? FrameColumnReaderUtils.getAdjustedCumulativeRowLength(memory, StringFrameColumnReader.getStartOfCumulativeLengthSection(), numRows - 1) : numRows;
        return StringFrameColumnReader.getStartOfStringLengthSection(numRows, multiValue) + 4L * (long)totalNumValues;
    }

    private static class StringFrameColumn
    extends ObjectColumnAccessorBase
    implements DictionaryEncodedColumn<String> {
        private final Frame frame;
        private final Memory memory;
        private final long startOfStringLengthSection;
        private final long startOfStringDataSection;
        private final boolean multiValue;

        private StringFrameColumn(Frame frame, boolean multiValue, Memory memory, long startOfStringLengthSection, long startOfStringDataSection) {
            this.frame = frame;
            this.multiValue = multiValue;
            this.memory = memory;
            this.startOfStringLengthSection = startOfStringLengthSection;
            this.startOfStringDataSection = startOfStringDataSection;
        }

        @Override
        public boolean hasMultipleValues() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getSingleValueRow(int rowNum) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IndexedInts getMultiValueRow(int rowNum) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public String lookupName(int id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int lookupId(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getCardinality() {
            return -1;
        }

        @Override
        public DimensionSelector makeDimensionSelector(final ReadableOffset offset, final @Nullable ExtractionFn extractionFn) {
            if (this.multiValue) {
                class MultiValueSelector
                implements DimensionSelector {
                    private int currentRow = -1;
                    private List<ByteBuffer> currentValues = null;
                    private final RangeIndexedInts indexedInts = new RangeIndexedInts();

                    MultiValueSelector() {
                    }

                    @Override
                    public int getValueCardinality() {
                        return -1;
                    }

                    @Override
                    @Nullable
                    public String lookupName(int id) {
                        this.populate();
                        ByteBuffer buf = this.currentValues.get(id);
                        String s = buf == null ? null : StringUtils.fromUtf8(buf.duplicate());
                        return extractionFn == null ? s : extractionFn.apply(s);
                    }

                    @Override
                    @Nullable
                    public ByteBuffer lookupNameUtf8(int id) {
                        assert (this.supportsLookupNameUtf8());
                        this.populate();
                        return this.currentValues.get(id);
                    }

                    @Override
                    public boolean supportsLookupNameUtf8() {
                        return extractionFn == null;
                    }

                    @Override
                    public boolean nameLookupPossibleInAdvance() {
                        return false;
                    }

                    @Override
                    @Nullable
                    public IdLookup idLookup() {
                        return null;
                    }

                    @Override
                    public IndexedInts getRow() {
                        this.populate();
                        return this.indexedInts;
                    }

                    @Override
                    public ValueMatcher makeValueMatcher(@Nullable String value) {
                        return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, value);
                    }

                    @Override
                    public ValueMatcher makeValueMatcher(DruidPredicateFactory predicateFactory) {
                        return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, predicateFactory);
                    }

                    @Override
                    @Nullable
                    public Object getObject() {
                        return StringFrameColumn.this.getRowAsObject(StringFrameColumn.this.frame.physicalRow(offset.getOffset()), true);
                    }

                    @Override
                    public Class<?> classOfObject() {
                        return String.class;
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    }

                    private void populate() {
                        int row = offset.getOffset();
                        if (row != this.currentRow) {
                            this.currentValues = StringFrameColumn.this.getRowAsListUtf8(StringFrameColumn.this.frame.physicalRow(row));
                            this.indexedInts.setSize(this.currentValues.size());
                            this.currentRow = row;
                        }
                    }
                }
                return new MultiValueSelector();
            }
            class SingleValueSelector
            extends BaseSingleValueDimensionSelector {
                SingleValueSelector() {
                }

                @Override
                @Nullable
                protected String getValue() {
                    String s = StringFrameColumn.this.getString(StringFrameColumn.this.frame.physicalRow(offset.getOffset()));
                    return extractionFn == null ? s : extractionFn.apply(s);
                }

                @Override
                @Nullable
                public ByteBuffer lookupNameUtf8(int id) {
                    assert (this.supportsLookupNameUtf8());
                    return StringFrameColumn.this.getStringUtf8(StringFrameColumn.this.frame.physicalRow(offset.getOffset()));
                }

                @Override
                public boolean supportsLookupNameUtf8() {
                    return extractionFn == null;
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                }
            }
            return new SingleValueSelector();
        }

        @Override
        public SingleValueDimensionVectorSelector makeSingleValueDimensionVectorSelector(ReadableVectorOffset offset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public MultiValueDimensionVectorSelector makeMultiValueDimensionVectorSelector(ReadableVectorOffset vectorOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public VectorObjectSelector makeVectorObjectSelector(final ReadableVectorOffset offset) {
            class StringFrameVectorObjectSelector
            implements VectorObjectSelector {
                private final Object[] vector;
                private int id;

                StringFrameVectorObjectSelector() {
                    this.vector = new Object[offset.getMaxVectorSize()];
                    this.id = -1;
                }

                @Override
                public Object[] getObjectVector() {
                    this.computeVectorIfNeeded();
                    return this.vector;
                }

                @Override
                public int getMaxVectorSize() {
                    return offset.getMaxVectorSize();
                }

                @Override
                public int getCurrentVectorSize() {
                    return offset.getCurrentVectorSize();
                }

                private void computeVectorIfNeeded() {
                    if (this.id == offset.getId()) {
                        return;
                    }
                    if (offset.isContiguous()) {
                        int start = offset.getStartOffset();
                        for (int i = 0; i < offset.getCurrentVectorSize(); ++i) {
                            int physicalRow = StringFrameColumn.this.frame.physicalRow(i + start);
                            this.vector[i] = StringFrameColumn.this.getRowAsObject(physicalRow, true);
                        }
                    } else {
                        int[] offsets = offset.getOffsets();
                        for (int i = 0; i < offset.getCurrentVectorSize(); ++i) {
                            int physicalRow = StringFrameColumn.this.frame.physicalRow(offsets[i]);
                            this.vector[i] = StringFrameColumn.this.getRowAsObject(physicalRow, true);
                        }
                    }
                    this.id = offset.getId();
                }
            }
            return new StringFrameVectorObjectSelector();
        }

        @Override
        public int length() {
            return this.frame.numRows();
        }

        @Override
        public void close() {
        }

        @Override
        public ColumnType getType() {
            return ColumnType.STRING;
        }

        @Override
        public int numRows() {
            return this.length();
        }

        @Override
        protected Object getVal(int rowNum) {
            return this.getRowAsObject(this.frame.physicalRow(rowNum), true);
        }

        @Override
        protected Comparator<Object> getComparator() {
            return Comparator.nullsFirst(Comparator.comparing(o -> (String)o));
        }

        @Override
        public int compareRows(int rowNum1, int rowNum2) {
            return ObjectUtils.compare((Comparable)this.getStringUtf8(rowNum1), (Comparable)this.getStringUtf8(rowNum2));
        }

        @Nullable
        private ByteBuffer getStringUtf8(int index) {
            long dataStart;
            long dataEnd = this.startOfStringDataSection + (long)this.memory.getInt(this.startOfStringLengthSection + 4L * (long)index);
            int dataLength = Ints.checkedCast((long)(dataEnd - (dataStart = index == 0 ? this.startOfStringDataSection : this.startOfStringDataSection + (long)this.memory.getInt(this.startOfStringLengthSection + 4L * (long)(index - 1)))));
            if (dataLength == 1 && this.memory.getByte(dataStart) == -1) {
                return null;
            }
            return FrameReaderUtils.readByteBuffer(this.memory, dataStart, dataLength);
        }

        @Nullable
        private String getString(int index) {
            ByteBuffer stringUtf8 = this.getStringUtf8(index);
            if (stringUtf8 == null) {
                return null;
            }
            return StringUtils.fromUtf8(stringUtf8);
        }

        @Nullable
        private Object getRowAsObject(int physicalRow, boolean decode) {
            if (this.multiValue) {
                int cumulativeRowLength = FrameColumnReaderUtils.getCumulativeRowLength(this.memory, StringFrameColumnReader.getStartOfCumulativeLengthSection(), physicalRow);
                if (FrameColumnReaderUtils.isNullRow(cumulativeRowLength)) {
                    return null;
                }
                int rowLength = physicalRow == 0 ? cumulativeRowLength : cumulativeRowLength - FrameColumnReaderUtils.getAdjustedCumulativeRowLength(this.memory, StringFrameColumnReader.getStartOfCumulativeLengthSection(), physicalRow - 1);
                if (rowLength == 0) {
                    return Collections.emptyList();
                }
                if (rowLength == 1) {
                    int index = cumulativeRowLength - 1;
                    Object o = decode ? this.getString(index) : this.getStringUtf8(index);
                    return o;
                }
                Object[] row = new Object[rowLength];
                for (int i = 0; i < rowLength; ++i) {
                    int index = cumulativeRowLength - rowLength + i;
                    row[i] = decode ? this.getString(index) : this.getStringUtf8(index);
                }
                return Arrays.asList(row);
            }
            Object o = decode ? this.getString(physicalRow) : this.getStringUtf8(physicalRow);
            return o;
        }

        private List<ByteBuffer> getRowAsListUtf8(int physicalRow) {
            Object object = this.getRowAsObject(physicalRow, false);
            if (object == null) {
                return Collections.singletonList(null);
            }
            if (object instanceof List) {
                return (List)object;
            }
            return Collections.singletonList((ByteBuffer)object);
        }
    }
}

